/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.EntityConvertable;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AreaProtectionSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.entity.damage.UDamageSources;
import com.minelittlepony.unicopia.particle.ParticleSource;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.server.world.OfflinePlayerCache;
import com.minelittlepony.unicopia.util.SoundEmitter;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public interface Caster<E extends class_1297>
extends Owned<class_1309>,
Levelled,
Affine,
ParticleSource<E>,
SoundEmitter<E>,
EntityConvertable<E>,
UDamageSources {
    public Physics getPhysics();

    public SpellSlots getSpellSlot();

    public boolean subtractEnergyCost(double var1);

    default public Caster<?> getOriginatingCaster() {
        return Caster.of(this.getMaster()).orElse(this);
    }

    default public boolean canModifyAt(class_2338 pos) {
        return this.canModifyAt(pos, ModificationType.EITHER);
    }

    default public boolean canModifyAt(class_2338 pos, ModificationType mod) {
        if (mod.checkPhysical()) {
            if (this.asWorld().method_8320(pos).method_26214((class_1922)this.asWorld(), pos) < 0.0f) {
                return false;
            }
            Object e = this.getMaster();
            if (e instanceof class_1657) {
                class_1657 player = (class_1657)e;
                if (!player.method_7294() || !this.asWorld().method_8505(player, pos)) {
                    return false;
                }
            } else {
                class_3218 sw;
                class_3222 player;
                class_1937 class_19372 = this.asWorld();
                if (class_19372 instanceof class_3218 && ((player = OfflinePlayerCache.getOfflinePlayer(sw = (class_3218)class_19372, this.getMasterId().orElse(null))) != null && !player.method_7294() || !sw.method_8505((class_1657)player, pos))) {
                    return false;
                }
                if (!this.asWorld().method_8450().method_8355(class_1928.field_19388)) {
                    return false;
                }
            }
        }
        return !mod.checkMagical() || this.canCastAt(class_243.method_24953((class_2382)pos));
    }

    default public Stream<Caster<?>> findAllSpellsInRange(double radius) {
        return this.findAllSpellsInRange(radius, null);
    }

    default public Stream<Caster<?>> findAllSpellsInRange(double radius, @Nullable Predicate<class_1297> test) {
        return Caster.stream(this.findAllEntitiesInRange(radius, test == null ? EquinePredicates.IS_CASTER : EquinePredicates.IS_CASTER.and(test)));
    }

    default public Stream<class_1297> findAllEntitiesInRange(double radius, @Nullable Predicate<class_1297> test) {
        return VecHelper.findInRange(this.asEntity(), (class_1924)this.asWorld(), this.getOriginVector(), radius, test).stream();
    }

    default public Stream<class_1297> findAllEntitiesInRange(double radius) {
        return this.findAllEntitiesInRange(radius, null);
    }

    default public boolean canCast() {
        return this.canCastAt(this.getOriginVector());
    }

    default public boolean canCastAt(class_243 pos) {
        return !Ether.get(this.asWorld()).anyMatch(SpellType.ARCANE_PROTECTION, entry -> {
            AreaProtectionSpell spell;
            Caster<?> caster;
            EntityReference.EntityValues target = entry.entity.getTarget().orElse(null);
            if (target != null && target.pos().method_1022(pos) <= (double)entry.getRadius() && (caster = entry.getCaster()) != null && (spell = (AreaProtectionSpell)entry.getSpell()) != null) {
                return spell.blocksMagicFor(caster, this, pos);
            }
            return false;
        });
    }

    default public boolean canUse(Ability<?> ability) {
        return false;
    }

    public static Stream<Caster<?>> stream(Stream<class_1297> entities) {
        return entities.map(Caster::of).flatMap(Optional::stream);
    }

    public static Optional<Caster<?>> of(@Nullable class_1297 entity) {
        if (entity instanceof Caster) {
            return Optional.of((Caster)entity);
        }
        return Equine.of(entity, c -> c instanceof Caster);
    }
}

