/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;

public interface Levelled {
    public static final Codec<LevelStore> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("value").forGetter(LevelStore::get), (App)Codec.INT.fieldOf("max").forGetter(LevelStore::getMax)).apply((Applicative)instance, Levelled::of));
    public static final LevelStore ZERO = Levelled.of(0, 1);

    public static LevelStore of(final IntSupplier getter, final IntConsumer setter, final IntSupplier max) {
        return new LevelStore(){

            @Override
            public int get() {
                return getter.getAsInt();
            }

            @Override
            public void set(int level) {
                setter.accept(level);
            }

            @Override
            public int getMax() {
                return max.getAsInt();
            }
        };
    }

    public static LevelStore copyOf(LevelStore store) {
        return Levelled.of(store.get(), store.getMax());
    }

    public static LevelStore of(final int level, final int max) {
        return new LevelStore(){

            @Override
            public int get() {
                return level;
            }

            @Override
            public void set(int level2) {
            }

            @Override
            public int getMax() {
                return max;
            }
        };
    }

    public LevelStore getLevel();

    public LevelStore getCorruption();

    public static interface LevelStore {
        public int getMax();

        public int get();

        public void set(int var1);

        default public float getScaled(float max) {
            if (this.getMax() == 0) {
                return max;
            }
            return (float)this.get() / (float)this.getMax() * max;
        }

        default public boolean canLevelUp() {
            int max = this.getMax();
            return max < 0 || this.get() < max;
        }

        default public void add(int levels) {
            this.set(this.get() + levels);
        }
    }
}

