/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.IllusionarySpell;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.OrientedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.MimicSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ShieldSpell;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;

public interface SpellPredicate<T extends Spell>
extends Predicate<Spell> {
    public static final SpellPredicate<?> ALL = spell -> true;
    public static final SpellPredicate<IllusionarySpell> CAN_SUPPRESS = s -> s instanceof IllusionarySpell;
    public static final SpellPredicate<AbstractDisguiseSpell> IS_DISGUISE = s -> s instanceof AbstractDisguiseSpell;
    public static final SpellPredicate<MimicSpell> IS_MIMIC = s -> s instanceof MimicSpell;
    public static final SpellPredicate<ShieldSpell> IS_SHIELD_LIKE = spell -> spell instanceof ShieldSpell;
    public static final SpellPredicate<TimedSpell> IS_TIMED = spell -> spell instanceof TimedSpell;
    public static final SpellPredicate<OrientedSpell> IS_ORIENTED = spell -> spell instanceof OrientedSpell;
    public static final SpellPredicate<?> IS_VISIBLE = spell -> spell != null && !spell.isHidden();
    public static final SpellPredicate<?> IS_CORRUPTING = spell -> spell.getAffinity() == Affinity.BAD;

    @Override
    default public <Q extends Spell> SpellPredicate<Q> and(SpellPredicate<Q> predicate) {
        SpellPredicate self = this;
        return s -> self.test(s) && predicate.test(s);
    }

    @Override
    default public <Q extends Spell> SpellPredicate<? extends Spell> or(SpellPredicate<Q> predicate) {
        SpellPredicate self = this;
        return s -> self.test(s) || predicate.test(s);
    }

    @Override
    default public SpellPredicate<?> negate() {
        SpellPredicate self = this;
        return s -> !self.test(s);
    }

    default public boolean isOn(Caster<?> caster) {
        return caster.getSpellSlot().contains(this);
    }

    default public boolean isOn(class_1297 entity) {
        return Caster.of(entity).filter(this::isOn).isPresent();
    }

    default public SpellPredicate<T> withId(UUID uuid) {
        return this.and(spell -> spell.getUuid().equals(uuid));
    }
}

