/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.damage.MagicalDamageSource;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class ChangelingFeedingSpell
extends AbstractSpell {
    private List<EntityReference<class_1309>> targets = List.of();
    private int nextTargetIndex;
    private float healthToDrain;
    private int foodToDrain;
    private float damageThisTick;

    public ChangelingFeedingSpell(CustomisedSpellType<?> type) {
        super(type);
        this.setHidden(true);
    }

    public ChangelingFeedingSpell(List<class_1309> feedTarget, float healthToDrain, int foodToDrain) {
        this(SpellType.FEED.withTraits());
        this.targets = feedTarget.stream().map(EntityReference::new).collect(Collectors.toList());
        this.healthToDrain = healthToDrain;
        this.foodToDrain = foodToDrain;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Pony changeling;
        block9: {
            block8: {
                if (!(source instanceof Pony)) break block8;
                changeling = (Pony)source;
                if (situation == Situation.BODY && source.canUse(Abilities.FEED)) break block9;
            }
            return false;
        }
        class_1657 player = (class_1657)changeling.asEntity();
        if (!ChangelingFeedingSpell.canFeed(changeling)) {
            changeling.playSound(USounds.Vanilla.field_19149, 1.0f, (float)player.method_37908().field_9229.method_43385(1.0, (double)0.2f));
            return false;
        }
        float tickDrain = Math.min(0.05f, this.healthToDrain);
        this.damageThisTick += tickDrain;
        if (this.damageThisTick > 1.0f) {
            this.damageThisTick -= 1.0f;
            float healAmount = this.drain(changeling, 1.0f);
            float foodAmount = Math.min(healAmount / 3.0f, (float)this.foodToDrain);
            if (foodAmount > 0.0f) {
                healAmount -= foodAmount;
            }
            foodAmount = class_3532.method_15363((float)foodAmount, (float)0.0f, (float)this.foodToDrain);
            healAmount = class_3532.method_15363((float)healAmount, (float)0.0f, (float)this.healthToDrain);
            int shanks = class_3532.method_15375((float)foodAmount);
            player.method_7344().method_7585(shanks, foodAmount - (float)shanks);
            player.method_6025(healAmount);
            if (!ChangelingFeedingSpell.canFeed(changeling)) {
                changeling.playSound(USounds.Vanilla.field_19149, 1.0f, (float)player.method_37908().field_9229.method_43385(1.0, (double)0.2f));
            } else {
                changeling.playSound(USounds.ENTITY_PLAYER_CHANGELING_FEED, 0.1f, changeling.getRandomPitch());
            }
            this.foodToDrain = (int)((float)this.foodToDrain - foodAmount);
            this.healthToDrain -= healAmount;
        }
        return !this.targets.isEmpty() && (this.healthToDrain > 0.0f || this.foodToDrain > 0);
    }

    private float drain(Pony changeling, float max) {
        List<EntityReference<class_1309>> targets = this.targets;
        while (!targets.isEmpty()) {
            int index = class_3532.method_15340((int)this.nextTargetIndex, (int)0, (int)targets.size());
            class_1309 l = targets.get(index).getOrEmpty(changeling.asWorld()).orElse(null);
            if (l != null && !l.method_31481() && l.method_5739(changeling.asEntity()) < 4.0f) {
                this.nextTargetIndex = (this.nextTargetIndex + 1) % targets.size();
                return this.drainFrom(changeling, l, max);
            }
            targets.remove(index);
        }
        return 0.0f;
    }

    public float drainFrom(Pony changeling, class_1309 living, float damage) {
        MagicalDamageSource d = changeling.damageOf(UDamageTypes.LOVE_DRAINING, changeling);
        if (damage > 0.0f) {
            living.method_5643((class_1282)d, damage);
        }
        ParticleUtils.spawnParticles((class_2394)UParticles.CHANGELING_MAGIC, (class_1297)living, 7);
        ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)changeling.asEntity(), 0.2f), (class_1297)living, 1);
        if (((class_1657)changeling.asEntity()).method_6059(class_1294.field_5916)) {
            class_1293 effect = ((class_1657)changeling.asEntity()).method_6112(class_1294.field_5916);
            ((class_1657)changeling.asEntity()).method_6016(class_1294.field_5916);
            living.method_6092(effect);
        } else if (changeling.asWorld().field_9229.method_43048(2300) == 0) {
            living.method_6092(new class_1293(class_1294.field_5920, 20, 1));
        }
        if (living instanceof class_1657) {
            damage += 1.0f;
            damage *= 1.6f;
            if (!((class_1657)changeling.asEntity()).method_6059(class_1294.field_5914)) {
                ((class_1657)changeling.asEntity()).method_6092(new class_1293(class_1294.field_5914, 13000, 1));
            }
        }
        return damage;
    }

    public static boolean canFeed(Pony player) {
        return ((class_1657)player.asEntity()).method_6032() < ((class_1657)player.asEntity()).method_6063() || ((class_1657)player.asEntity()).method_7332(false);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10548("healthToDrain", this.healthToDrain);
        compound.method_10569("foodToDrain", this.foodToDrain);
        compound.method_10548("damageThisTick", this.damageThisTick);
        compound.method_10566("targets", NbtSerialisable.encode(EntityReference.listCodec(), this.targets, lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.healthToDrain = compound.method_10583("healthToDrain");
        this.foodToDrain = compound.method_10550("foodToDrain");
        this.damageThisTick = compound.method_10583("damageThisTick");
        this.targets = NbtSerialisable.decode(EntityReference.listCodec(), compound.method_10580("targets"), lookup).orElse(List.of());
    }
}

