/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.crafting;

import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2540;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record TraitIngredient(Optional<SpellTraits> min, Optional<SpellTraits> max) implements Predicate<SpellTraits>
{
    public static final TraitIngredient EMPTY = new TraitIngredient(Optional.empty(), Optional.empty());
    private static final Codec<TraitIngredient> INLINE_CODEC = SpellTraits.CODEC.xmap(traits -> new TraitIngredient(Optional.ofNullable(traits), Optional.empty()), ingredient -> ingredient.min().orElse(SpellTraits.EMPTY));
    private static final Codec<TraitIngredient> STRUCTURED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SpellTraits.CODEC.optionalFieldOf("min").forGetter(TraitIngredient::min), (App)SpellTraits.CODEC.optionalFieldOf("max").forGetter(TraitIngredient::max)).apply((Applicative)instance, TraitIngredient::new)).flatXmap(ingredient -> !ingredient.isEmpty() ? DataResult.success((Object)ingredient) : DataResult.error(() -> "No min or max supplied for ingredient"), DataResult::success);
    public static final Codec<TraitIngredient> CODEC = Codec.xor(INLINE_CODEC, STRUCTURED_CODEC).flatXmap(either -> either.left().or(() -> ((Either)either).right()).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Invalid traits")), ingredient -> DataResult.success((Object)(ingredient.max.isEmpty() ? Either.left((Object)ingredient) : Either.right((Object)ingredient))));
    public static final class_9139<class_2540, TraitIngredient> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56382(SpellTraits.PACKET_CODEC), TraitIngredient::min, (class_9139)class_9135.method_56382(SpellTraits.PACKET_CODEC), TraitIngredient::max, TraitIngredient::new);

    public static TraitIngredient of(SpellTraits minTraits) {
        if (minTraits.isEmpty()) {
            return EMPTY;
        }
        return new TraitIngredient(Optional.of(minTraits), Optional.empty());
    }

    public static TraitIngredient of(SpellTraits minTraits, SpellTraits maxTraits) {
        if (minTraits.isEmpty() && maxTraits.isEmpty()) {
            return EMPTY;
        }
        return new TraitIngredient(Optional.of(minTraits).filter(s -> !s.isEmpty()), Optional.of(maxTraits).filter(s -> !s.isEmpty()));
    }

    public boolean isEmpty() {
        return this.min.filter(SpellTraits::isPresent).isEmpty() && this.max.filter(SpellTraits::isPresent).isEmpty();
    }

    @Override
    public boolean test(SpellTraits t) {
        boolean minMatch = this.min.map(m -> t.includes((SpellTraits)m)).orElse(true);
        boolean maxMatch = this.max.map(m -> m.includes(t)).orElse(true);
        return minMatch && maxMatch;
    }
}

