/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.server.world.Ether;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public abstract class AbstractSpell
implements Spell {
    private UUID uuid = UUID.randomUUID();
    private final CustomisedSpellType<?> type;
    protected final DataTracker dataTracker = new DataTracker(0);
    private final DataTracker.Entry<Boolean> dead = this.dataTracker.startTracking(TrackableDataType.BOOLEAN, false);
    private final DataTracker.Entry<Boolean> dying = this.dataTracker.startTracking(TrackableDataType.BOOLEAN, false);
    private final DataTracker.Entry<Boolean> hidden = this.dataTracker.startTracking(TrackableDataType.BOOLEAN, false);
    private boolean destroyed;

    protected AbstractSpell(CustomisedSpellType<?> type) {
        this.type = type;
    }

    @Override
    public final DataTracker getDataTracker() {
        return this.dataTracker;
    }

    @Override
    public final UUID getUuid() {
        return this.uuid;
    }

    protected final SpellType<?> getType() {
        return this.type.type();
    }

    @Override
    public final CustomisedSpellType<?> getTypeAndTraits() {
        return this.type;
    }

    protected final SpellTraits getTraits() {
        return this.type.traits();
    }

    @Override
    public final void setDead() {
        this.dying.set(true);
    }

    @Override
    public final boolean isDead() {
        return this.dead.get();
    }

    @Override
    public final boolean isDying() {
        return this.dying.get();
    }

    @Override
    public final boolean isHidden() {
        return this.hidden.get();
    }

    @Override
    public final void setHidden(boolean hidden) {
        this.hidden.set(hidden);
    }

    @Override
    public void tickDying(Caster<?> caster) {
        this.dead.set(true);
    }

    @Override
    public final void destroy(Caster<?> caster) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.setDead();
        this.onDestroyed(caster);
    }

    protected void onDestroyed(Caster<?> caster) {
        if (!caster.isClient()) {
            Ether.get(caster.asWorld()).remove(this, caster);
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10556("dying", this.dying.get().booleanValue());
        compound.method_10556("dead", this.dead.get().booleanValue());
        compound.method_10556("hidden", this.hidden.get().booleanValue());
        compound.method_25927("uuid", this.uuid);
        compound.method_10566("traits", (class_2520)this.getTraits().toNbt());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_25928("uuid")) {
            this.uuid = compound.method_25926("uuid");
        }
        this.dying.set(compound.method_10577("dying"));
        this.dead.set(compound.method_10577("dead"));
        this.hidden.set(compound.method_10577("hidden"));
    }

    public final String toString() {
        return "Spell{" + String.valueOf(this.getTypeAndTraits()) + "}[uuid=" + String.valueOf(this.uuid) + ", dead=" + String.valueOf(this.dead) + ", hidden=" + String.valueOf(this.hidden) + "]";
    }
}

