/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public interface AttractionUtils {
    public static double getAttractiveForce(double wellMass, class_243 wellPosition, class_1297 target) {
        return wellMass * AttractionUtils.getMass(target) / class_3532.method_33723((double)wellPosition.method_1022(target.method_19538()));
    }

    public static double getMass(class_1297 entity) {
        double baseMass = entity.method_17681() * entity.method_17682();
        if (entity instanceof class_1542) {
            class_1542 item = (class_1542)entity;
            baseMass *= (double)item.method_6983().method_7947();
            @Nullable class_2248 block = class_2248.method_9503((class_1792)item.method_6983().method_7909());
            if (block != null) {
                baseMass *= (double)class_3532.method_15363((float)(1.0f + block.method_36555()), (float)1.0f, (float)5.0f);
            }
        }
        return baseMass;
    }

    public static void applyForce(class_243 center, class_1297 target, double force, double yChange, boolean clampVelocity) {
        if (clampVelocity) {
            target.method_18799(target.method_18798().method_1021(Math.min(1.0, 1.0 - force)));
        }
        center = target.method_19538().method_1020(center).method_1029().method_1021(force);
        if (target instanceof class_1309) {
            center = center.method_1021((double)(1.0f / EnchantmentUtil.getWeight((class_1309)target)));
        }
        target.method_5762(center.field_1352, center.field_1351 + yChange, center.field_1350);
        Living.updateVelocity(target);
    }

    public static double getForceAdjustment(class_1297 entity) {
        return Pony.of(entity).map(pony -> {
            double force = 0.75;
            if (EffectUtils.hasExtraDefenses(pony.asEntity())) {
                force /= 12.0;
            } else if (pony.getCompositeRace().canUseEarth()) {
                force /= 2.0;
            } else if (pony.getCompositeRace().canFly()) {
                force *= 2.0;
            }
            return force;
        }).orElse(1.0);
    }
}

