/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.minelittlepony.unicopia.projectile.MagicBeamEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public class DispellEvilSpell
extends AbstractSpell
implements ProjectileDelegate.HitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.POWER, 1.0f).build();
    private static final SpellAttribute<Double> RANGE;
    static final TooltipFactory TOOLTIP;

    protected DispellEvilSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (situation == Situation.PROJECTILE) {
            return !this.isDead();
        }
        source.findAllEntitiesInRange(RANGE.get(this.getTraits()), e -> e.method_5864() == class_1299.field_6078).forEach(entity -> {
            entity.method_5643(entity.method_48923().method_48831(), 50.0f);
            if (entity instanceof class_1309) {
                class_1309 l = (class_1309)entity;
                double d = source.getOriginVector().method_10216() - entity.method_23317();
                double e = source.getOriginVector().method_10215() - entity.method_23321();
                while (d * d + e * e < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    e = (Math.random() - Math.random()) * 0.01;
                }
                l.method_6005(1.0, d, e);
            }
            source.addParticle(LightningBoltParticleEffect.DEFAULT, entity.method_19538(), class_243.field_1353);
        });
        source.subtractEnergyCost(1000.0);
        return false;
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile) {
        if (projectile instanceof MagicBeamEntity) {
            MagicBeamEntity source = (MagicBeamEntity)projectile;
            this.tick(source, Situation.GROUND);
        }
    }

    static {
        TOOLTIP = RANGE = SpellAttribute.create(SpellAttributeType.RANGE, AttributeFormat.TIME, AttributeFormat.PERCENTAGE, Trait.POWER, power -> (double)(1.0f + power) * 10.0);
    }
}

