/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_243;

public class DisperseIllusionSpell
extends AbstractAreaEffectSpell {
    private static final SpellAttribute<Float> RANGE = SpellAttribute.create(SpellAttributeType.RANGE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, power -> Float.valueOf(Math.max(0.0f, 15.0f + power)));
    private static final SpellAttribute<Long> DURATION = SpellAttribute.create(SpellAttributeType.DURATION, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.STRENGTH, strength -> (1L + (long)strength) * 100L);
    static final TooltipFactory TOOLTIP = TooltipFactory.of(RANGE, DURATION);

    protected DisperseIllusionSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        float range = RANGE.get(this.getTraits()).floatValue();
        if (range == 0.0f) {
            return false;
        }
        if (source.isClient()) {
            MagicParticleEffect effect = new MagicParticleEffect(this.getType().getColor());
            source.spawnParticles(new Sphere(false, range), 5, pos -> source.addParticle(effect, (class_243)pos, class_243.field_1353));
            source.spawnParticles(effect, 5);
        }
        source.findAllSpellsInRange(range).forEach(e -> e.getSpellSlot().get(SpellPredicate.CAN_SUPPRESS).filter(spell -> spell.isVulnerable(source, this)).ifPresent(spell -> {
            spell.onSuppressed(source, DURATION.get(this.getTraits()).longValue());
            e.playSound(USounds.SPELL_ILLUSION_DISPERSE, 0.2f, 0.5f);
        }));
        return true;
    }
}

