/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.HomingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3966;
import net.minecraft.class_7225;

public class DisplacementSpell
extends AbstractSpell
implements HomingSpell,
ProjectileDelegate.HitListener {
    private static final SpellAttribute<Float> DAMAGE_TO_TARGET;
    static final TooltipFactory TOOLTIP;
    private final EntityReference<class_1297> target;
    private int ticks;

    protected DisplacementSpell(CustomisedSpellType<?> type) {
        super(type);
        this.target = this.dataTracker.startTracking(new EntityReference());
        this.ticks = 10;
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method.isIndirectCause() ? this : this.toPlaceable();
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Caster<?> originator = source.getOriginatingCaster();
        originator.asEntity().method_5834(true);
        if (situation == Situation.PROJECTILE) {
            return !this.isDead();
        }
        --this.ticks;
        if (originator.isClient()) {
            return !this.isDead() || this.ticks >= -10;
        }
        if (!originator.isClient()) {
            this.target.ifPresent(originator.asWorld(), target -> {
                target.method_5834(true);
                if (this.ticks == 0) {
                    this.apply(originator, (class_1297)target);
                }
            });
        }
        return this.ticks >= -10;
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        ProjectileDelegate.HitListener.super.onImpact(projectile, hit);
        Caster.of(projectile.getMaster()).ifPresent(originator -> this.apply((Caster<?>)originator, hit.method_17782()));
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile) {
        if (projectile.getMaster() != null) {
            ((class_1309)projectile.getMaster()).method_5834(false);
        }
        this.target.ifPresent(projectile.asWorld(), e -> e.method_5834(false));
    }

    private void apply(Caster<?> originator, class_1297 target) {
        class_243 destinationPos = target.method_19538();
        class_243 destinationVel = target.method_18798();
        class_243 sourcePos = originator.getOriginVector();
        class_243 sourceVel = originator.asEntity().method_18798();
        class_1297 targetVehicle = this.teleport(originator, target, sourcePos, sourceVel);
        class_1297 sourceVehicle = this.teleport(originator, (class_1297)originator.asEntity(), destinationPos, destinationVel);
        if (targetVehicle != null) {
            originator.asEntity().method_5804(targetVehicle);
        }
        if (sourceVehicle != null) {
            target.method_5804(sourceVehicle);
        }
        originator.subtractEnergyCost(destinationPos.method_1022(sourcePos) / 20.0);
    }

    private class_1297 teleport(Caster<?> source, class_1297 entity, class_243 pos, class_243 vel) {
        class_1297 oldVehicle = entity.method_5854();
        entity.method_33567(pos.field_1352, pos.field_1351, pos.field_1350);
        entity.method_18799(vel);
        entity.method_5834(false);
        entity.method_5783(USounds.SPELL_DISPLACEMENT_TELEPORT, 1.0f, 1.0f);
        float damage = DAMAGE_TO_TARGET.get(this.getTraits()).floatValue();
        if (damage > 0.0f) {
            entity.method_5643((class_1282)source.damageOf(UDamageTypes.EXHAUSTION, source), damage);
        }
        return oldVehicle;
    }

    @Override
    public boolean setTarget(class_1297 target) {
        this.target.set(target);
        return false;
    }

    @Override
    public int getRange(Caster<?> caster) {
        return 200 + Math.min(2000, 50 * (1 + caster.getLevel().get()));
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        caster.getOriginatingCaster().asEntity().method_5834(false);
        this.target.ifPresent(caster.asWorld(), e -> e.method_5834(false));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("ticks", this.ticks);
        compound.method_10566("target", (class_2520)this.target.toNBT(lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.ticks = compound.method_10550("ticks");
        this.target.fromNBT(compound.method_10562("target"), lookup);
    }

    static {
        TOOLTIP = DAMAGE_TO_TARGET = SpellAttribute.create(SpellAttributeType.DAMAGE_TO_TARGET, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.BLOOD, blood -> Float.valueOf(blood));
    }
}

