/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class FeatherFallSpell
extends AbstractSpell
implements TimedSpell {
    private static final int MIN_RANGE = 1;
    private static final int MAX_RANGE = 20;
    private static final int MIN_TARGETS = 1;
    private static final int MAX_TARGETS = 19;
    private static final float FOCUS_RANGE_WEIGHT = 0.1f;
    private static final float POWERS_RANGE_WEIGHT = 0.3f;
    private static final float MAX_GENEROSITY_FACTOR = 19.0f;
    private static final SpellAttribute<Integer> DURATION = SpellAttribute.create(SpellAttributeType.DURATION, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.FOCUS, focus -> 10 + (int)class_3532.method_15363((float)focus, (float)0.0f, (float)160.0f));
    private static final SpellAttribute<Float> STRENGTH = SpellAttribute.create(SpellAttributeType.STRENGTH, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.STRENGTH, strength -> Float.valueOf(class_3532.method_15363((float)strength, (float)2.0f, (float)9.0f)));
    private static final SpellAttribute<Float> RANGE = SpellAttribute.create(SpellAttributeType.RANGE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, power -> Float.valueOf(class_3532.method_15363((float)((power - 10.0f) * 0.3f), (float)1.0f, (float)20.0f)));
    private static final SpellAttribute<Long> SIMULTANIOUS_TARGETS = SpellAttribute.create(SpellAttributeType.SIMULTANIOUS_TARGETS, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.GENEROSITY, (traits, generosity) -> (long)(generosity.floatValue() + traits.get(Trait.FOCUS, 1.0f, 19.0f) * 2.0f));
    private static final SpellAttribute<Float> COST_PER_INDIVIDUAL = SpellAttribute.create(SpellAttributeType.COST_PER_INDIVIDUAL, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, (traits, power) -> Float.valueOf(class_3532.method_15363((float)((Math.max(power.floatValue(), 10.0f) - 10.0f) * 0.3f - (Math.max(traits.get(Trait.FOCUS), 80.0f) - 80.0f) * 0.1f), (float)1.0f, (float)7.0f)));
    private static final SpellAttribute<Float> TARGET_PREFERENCE = SpellAttribute.create(SpellAttributeType.TARGET_PREFERENCE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.GENEROSITY, generosity -> Float.valueOf(class_3532.method_15363((float)generosity, (float)1.0f, (float)19.0f) / 19.0f));
    private static final SpellAttribute<Float> CASTER_PREFERENCE = SpellAttribute.create(SpellAttributeType.CASTER_PREFERENCE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.GENEROSITY, (traits, generosity) -> Float.valueOf(1.0f - TARGET_PREFERENCE.get((SpellTraits)traits).floatValue()));
    private static final SpellAttribute<Boolean> NEGATES_FALL_DAMAGE = SpellAttribute.createConditional(SpellAttributeType.NEGATES_FALL_DAMAGE, Trait.GENEROSITY, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)generosity -> generosity > 0.5f));
    static final TooltipFactory TOOLTIP = TooltipFactory.of(DURATION, STRENGTH, RANGE, SIMULTANIOUS_TARGETS, COST_PER_INDIVIDUAL, TARGET_PREFERENCE, CASTER_PREFERENCE, NEGATES_FALL_DAMAGE);
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 80.0f).with(Trait.POWER, 10.0f).with(Trait.AIR, 0.1f).with(Trait.KINDNESS, 90.0f).with(Trait.ORDER, 15.0f).build();
    private final TimedSpell.Timer timer = new TimedSpell.Timer(DURATION.get(this.getTraits()));

    protected FeatherFallSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public TimedSpell.Timer getTimer() {
        return this.timer;
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        this.timer.tick();
        if (this.timer.getTicksRemaining() <= 0) {
            return false;
        }
        List<class_1297> targets = this.getTargets(caster).toList();
        if (targets.isEmpty()) {
            return true;
        }
        float strength = 1.0f / (STRENGTH.get(this.getTraits()).floatValue() / (float)targets.size());
        float targetPreference = TARGET_PREFERENCE.get(this.getTraits()).floatValue();
        float casterPreference = 1.0f - targetPreference;
        boolean negateFallDamage = NEGATES_FALL_DAMAGE.get(this.getTraits());
        Object entity = caster.asEntity();
        class_243 masterVelocity = entity.method_18798().method_1021(0.1);
        targets.forEach(target -> {
            if (target.method_18798().field_1351 < 0.0) {
                if (negateFallDamage) {
                    target.field_5992 = true;
                    target.method_24830(true);
                    target.field_6017 = 0.0f;
                }
                if (target instanceof class_1657) {
                    ((class_1657)target).method_31549().field_7479 = false;
                }
                float delta = strength * (caster.isOwnedBy(target) || target == entity ? casterPreference : targetPreference);
                target.method_18799(target.method_18798().method_18805(1.0, (double)delta, 1.0));
                if (situation == Situation.PROJECTILE && target != entity) {
                    target.method_5762(masterVelocity.field_1352, 0.0, masterVelocity.field_1350);
                }
            }
            ParticleUtils.spawnParticles(new MagicParticleEffect(this.getType().getColor()), target, 7);
        });
        return caster.subtractEnergyCost(this.timer.getTicksRemaining() % 50 == 0 ? (double)(COST_PER_INDIVIDUAL.get(this.getTraits()).floatValue() * (float)targets.size()) : 0.0);
    }

    protected Stream<class_1297> getTargets(Caster<?> caster) {
        return Stream.concat(Stream.of(caster.asEntity()), caster.findAllEntitiesInRange(RANGE.get(this.getTraits()).floatValue()).sorted((a, b) -> Integer.compare(FriendshipBraceletItem.isComrade(caster, a) ? 1 : 0, FriendshipBraceletItem.isComrade(caster, b) ? 1 : 0)).distinct()).limit(SIMULTANIOUS_TARGETS.get(this.getTraits()));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        this.timer.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.timer.fromNBT(compound, lookup);
    }
}

