/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.HomingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.TargetSelecter;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3966;
import net.minecraft.class_7225;

public class FireBoltSpell
extends AbstractSpell
implements HomingSpell,
ProjectileDelegate.ConfigurationListener,
ProjectileDelegate.EntityHitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 10.0f).with(Trait.CHAOS, 1.0f).with(Trait.STRENGTH, 11.0f).with(Trait.FIRE, 60.0f).build();
    public static final SpellTraits HOMING_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 50.0f).with(Trait.CHAOS, 10.0f).with(Trait.STRENGTH, 11.0f).with(Trait.FIRE, 60.0f).build();
    private static final SpellAttribute<Float> VELOCITY = SpellAttribute.create(SpellAttributeType.VELOCITY, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.STRENGTH, strength -> Float.valueOf(1.3f + strength / 11.0f));
    private static final SpellAttribute<Integer> PROJECTILE_COUNT = SpellAttribute.create(SpellAttributeType.PROJECTILE_COUNT, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.EARTH, earth -> 11 + (int)earth * 3);
    private static final SpellAttribute<Boolean> FOLLOWS_TARGET = SpellAttribute.createConditional(SpellAttributeType.FOLLOWS_TARGET, Trait.FOCUS, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)focus -> focus >= 50.0f));
    private static final SpellAttribute<Float> FOLLOW_RANGE = SpellAttribute.create(SpellAttributeType.FOLLOW_RANGE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.FOCUS, focus -> Float.valueOf(Math.max(0.0f, focus - 49.0f)));
    private static final SpellAttribute<Float> EXPLOSION_STRENGTH = SpellAttribute.createRanged(SpellAttributeType.EXPLOSION_STRENGTH, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, SpellAttribute.create(SpellAttributeType.EXPLOSION_STRENGTH, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.FOCUS, focus -> Float.valueOf(focus >= 50.0f ? 10.0f : 1.0f)), (traits, power) -> Float.valueOf(Math.max(power.floatValue() / 50.0f, 0.0f)), false);
    static final TooltipFactory TOOLTIP;
    private final EntityReference<class_1297> target;

    protected FireBoltSpell(CustomisedSpellType<?> type) {
        super(type);
        this.target = this.dataTracker.startTracking(new EntityReference());
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        hit.method_17782().method_5639(90.0f);
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        boolean followTarget = FOLLOWS_TARGET.get(this.getTraits());
        float followRage = FOLLOW_RANGE.get(this.getTraits()).floatValue();
        if (situation == Situation.PROJECTILE) {
            if (caster instanceof MagicProjectileEntity) {
                MagicProjectileEntity projectile = (MagicProjectileEntity)((Object)caster);
                if (followTarget) {
                    caster.findAllEntitiesInRange(followRage, class_1301.field_6157.and(TargetSelecter.validTarget(this, caster))).findFirst().ifPresent(target -> projectile.setHomingTarget((class_1297)target));
                }
            }
            return true;
        }
        if (followTarget && this.target.getOrEmpty(caster.asWorld()).isEmpty()) {
            this.target.set(caster.findAllEntitiesInRange(followRage, class_1301.field_6157.and(TargetSelecter.validTarget(this, caster))).findFirst().orElse(null));
        }
        for (int i = 0; i < this.getNumberOfBalls(caster); ++i) {
            this.getTypeAndTraits().create().toThrowable().throwProjectile(caster, 2.0f).ifPresent(c -> this.target.ifPresent(caster.asWorld(), c::setHomingTarget));
            caster.playSound(USounds.SPELL_FIRE_BOLT_SHOOT, 0.7f, 0.4f / (caster.asWorld().field_9229.method_43057() * 0.4f + 0.8f));
        }
        return false;
    }

    @Override
    public void configureProjectile(MagicProjectileEntity projectile, Caster<?> caster) {
        projectile.method_16940(class_1802.field_8814.method_7854());
        projectile.addThrowDamage(EXPLOSION_STRENGTH.get(this.getTraits()).floatValue());
        projectile.method_20803(900000);
        projectile.method_18799(projectile.method_18798().method_1021((double)VELOCITY.get(this.getTraits()).floatValue()));
    }

    protected int getNumberOfBalls(Caster<?> caster) {
        return PROJECTILE_COUNT.get(this.getTraits()) + caster.asWorld().field_9229.method_43048(3);
    }

    @Override
    public boolean setTarget(class_1297 target) {
        if (FOLLOWS_TARGET.get(this.getTraits()).booleanValue()) {
            this.target.set(target);
            return true;
        }
        return false;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10566("target", (class_2520)this.target.toNBT(lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.target.fromNBT(compound.method_10562("target"), lookup);
    }

    static {
        TooltipFactory[] tooltipFactoryArray = new TooltipFactory[5];
        tooltipFactoryArray[0] = EXPLOSION_STRENGTH;
        tooltipFactoryArray[1] = VELOCITY;
        tooltipFactoryArray[2] = PROJECTILE_COUNT;
        tooltipFactoryArray[3] = FOLLOWS_TARGET;
        tooltipFactoryArray[4] = FOLLOW_RANGE.conditionally(FOLLOWS_TARGET::get);
        TOOLTIP = TooltipFactory.of(tooltipFactoryArray);
    }
}

