/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.CastOn;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ShieldSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.minelittlepony.unicopia.util.shape.Shape;
import com.minelittlepony.unicopia.util.shape.Sphere;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7225;

public class HydrophobicSpell
extends AbstractSpell {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 5.0f).with(Trait.KNOWLEDGE, 1.0f).build();
    static final TooltipFactory TOOLTIP = TooltipFactory.of(ShieldSpell.CAST_ON, ShieldSpell.RANGE);
    private final class_6862<class_3611> affectedFluid;
    private final Set<Entry> storedFluidPositions = new HashSet<Entry>();

    protected HydrophobicSpell(CustomisedSpellType<?> type, class_6862<class_3611> affectedFluid) {
        super(type);
        this.affectedFluid = affectedFluid;
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        if ((method == CastingMethod.DIRECT || method == CastingMethod.STAFF) && ShieldSpell.CAST_ON.get(this.getTraits()) == CastOn.LOCATION) {
            return this.toPlaceable();
        }
        if (method == CastingMethod.STAFF) {
            return this.toThrowable();
        }
        return this;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (!source.isClient()) {
            class_1937 world = source.asWorld();
            Shape area = new Sphere(false, this.getRange(source)).translate(source.getOriginVector());
            this.storedFluidPositions.removeIf(entry -> {
                if (!area.isPointInside(class_243.method_24953((class_2382)entry.pos()))) {
                    if (source.canModifyAt(entry.pos())) {
                        entry.restore(world);
                    }
                    return true;
                }
                return false;
            });
            area.getBlockPositions().forEach(pos -> {
                pos = new class_2338((class_2382)pos);
                class_2680 state = world.method_8320(pos);
                if (source.canModifyAt((class_2338)pos) && state.method_26227().method_15767(this.affectedFluid)) {
                    class_2248 block = state.method_26204();
                    if (block instanceof class_2404) {
                        world.method_8652(pos, class_2246.field_10124.method_9564(), 2);
                        this.storedFluidPositions.add(new Entry((class_2338)pos, state));
                    } else if (state.method_28498((class_2769)class_2741.field_12508)) {
                        world.method_8652(pos, (class_2680)state.method_28493((class_2769)class_2741.field_12508), 2);
                        this.storedFluidPositions.add(new Entry((class_2338)pos, state));
                    }
                }
            });
            if (!source.subtractEnergyCost(this.storedFluidPositions.isEmpty() ? (double)0.001f : (double)0.02f)) {
                this.setDead();
            }
            double range = this.getRange(source);
            Ether.get(source.asWorld()).getOrCreate(this, source).setRadius((float)range);
            source.spawnParticles(new Sphere(true, range), 10, pos -> {
                class_2338 bp = class_2338.method_49638((class_2374)pos);
                if (source.canModifyAt(bp) && source.asWorld().method_8316(bp.method_10084()).method_15767(this.affectedFluid)) {
                    source.addParticle((class_2394)UParticles.RAIN_DROPS, (class_243)pos, class_243.field_1353);
                }
            });
            if (((class_1297)source.asEntity()).field_6012 % 200 == 0) {
                source.playSound(USounds.SPELL_AMBIENT, 0.5f);
            }
            if (this.storedFluidPositions.size() >= 100) {
                UCriteria.SPLIT_SEA.trigger((class_1297)source.asEntity());
            }
        }
        return !this.isDead();
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        this.storedFluidPositions.removeIf(entry -> {
            if (caster.canModifyAt(entry.pos())) {
                entry.restore(caster.asWorld());
            }
            return true;
        });
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10566("storedFluidPositions", NbtSerialisable.encode(Entry.SET_CODEC, this.storedFluidPositions, lookup));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.storedFluidPositions.clear();
        NbtSerialisable.decode(Entry.SET_CODEC, compound.method_10580("storedFluidPositions"), lookup).ifPresent(this.storedFluidPositions::addAll);
    }

    public double getRange(Caster<?> source) {
        float multiplier = 1.0f;
        float min = (float)(source instanceof Pony ? 0 : 2) + ShieldSpell.RANGE.get(this.getTraits()).floatValue();
        boolean isLimitedRange = source instanceof Pony || source instanceof MagicProjectileEntity;
        double range = (min + source.getLevel().getScaled(isLimitedRange ? 4.0f : 40.0f) * (float)(isLimitedRange ? 2 : 10)) / multiplier;
        return range;
    }

    public boolean blocksFlow(Ether.Entry<?> entry, class_243 center, class_2338 pos, class_3610 fluid) {
        return fluid.method_15767(this.affectedFluid) && pos.method_19769((class_2374)center, (double)entry.getRadius() + 1.0);
    }

    public static boolean blocksFluidFlow(class_1922 world, class_2338 pos, class_3610 state) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        class_3218 sw = (class_3218)world;
        return Ether.get((class_1937)sw).anyMatch(SpellType.HYDROPHOBIC, entry -> {
            EntityReference.EntityValues target = entry.entity.getTarget().orElse(null);
            if (target == null || !pos.method_19769((class_2374)target.pos(), (double)(entry.getRadius() + 1.0f))) {
                return false;
            }
            HydrophobicSpell spell = (HydrophobicSpell)entry.getSpell();
            return spell != null && target != null && spell.blocksFlow((Ether.Entry<?>)entry, target.pos(), pos, state);
        });
    }

    record Entry(class_2338 pos, class_2680 blockState) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Entry::pos), (App)class_2680.field_24734.optionalFieldOf("blockState", (Object)class_2246.field_10124.method_9564()).forGetter(Entry::blockState)).apply((Applicative)instance, Entry::new));
        public static final Codec<Set<Entry>> SET_CODEC = CodecUtils.setOf(CODEC);

        void restore(class_1937 world) {
            class_2680 state = world.method_8320(this.pos);
            if (state.method_26215()) {
                if (this.blockState.method_28498((class_2769)class_2741.field_12508)) {
                    world.method_8652(this.pos, this.blockState.method_26227().method_15759(), 2);
                } else {
                    world.method_8652(this.pos, this.blockState, 2);
                }
            } else if (state.method_28498((class_2769)class_2741.field_12508)) {
                world.method_8652(this.pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }
}

