/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.FireSpell;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.block.state.StateMaps;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class ScorchSpell
extends FireSpell
implements ProjectileDelegate.ConfigurationListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FIRE, 10.0f).build();

    protected ScorchSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method == CastingMethod.STAFF ? this.toThrowable() : this.toPlaceable();
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        class_2338 pos = PosHelper.findSolidGroundAt(source.asWorld(), source.getOrigin(), source.getPhysics().getGravitySignum());
        if (source.canModifyAt(pos) && StateMaps.FIRE_AFFECTED.convert(source.asWorld(), pos)) {
            source.spawnParticles(new Sphere(false, ((Float)RANGE.get(this.getTraits())).floatValue()), 5, p -> source.addParticle((class_2394)class_2398.field_11251, PosHelper.offset(p, (class_2382)pos), class_243.field_1353));
        }
        return true;
    }

    @Override
    protected void generateParticles(Caster<?> source) {
        source.addParticle((class_2394)class_2398.field_11207, source.getOriginVector(), class_243.field_1353);
        source.spawnParticles((class_2394)class_2398.field_11240, 3);
        source.spawnParticles(new MagicParticleEffect(this.getType().getColor()), 3);
    }

    @Override
    public void configureProjectile(MagicProjectileEntity projectile, Caster<?> caster) {
        projectile.method_5875(true);
    }
}

