/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;

public class TargetSelecter {
    private final Map<UUID, Target> targets = new TreeMap<UUID, Target>();
    private final Spell spell;
    private BiPredicate<Caster<?>, class_1297> filter = (a, b) -> true;
    private boolean targetOwner;
    private boolean targetAllies;

    public TargetSelecter(Spell spell) {
        this.spell = spell;
    }

    public TargetSelecter setFilter(BiPredicate<Caster<?>, class_1297> filter) {
        this.filter = filter;
        return this;
    }

    public TargetSelecter setTargetowner(boolean targetOwner) {
        this.targetOwner = targetOwner;
        return this;
    }

    public TargetSelecter setTargetAllies(boolean targetAllies) {
        this.targetAllies = targetAllies;
        return this;
    }

    public Stream<class_1297> getEntities(Caster<?> source, double radius) {
        this.targets.values().removeIf(Target::tick);
        return source.findAllEntitiesInRange(radius).filter(EquinePredicates.EXCEPT_MAGIC_IMMUNE).filter(entity -> entity != source.asEntity() && this.checkAlliegance(this.spell, source, (class_1297)entity) && this.filter.test(source, (class_1297)entity)).map(i -> {
            this.targets.computeIfAbsent(i.method_5667(), Target::new);
            return i;
        });
    }

    private boolean checkAlliegance(Affine affine, Caster<?> source, class_1297 target) {
        boolean isOwner = !this.targetOwner && source.isOwnerOrVehicle(target);
        boolean isFriend = !this.targetAllies && affine.applyInversion(source, source.isFriend(target));
        return !isOwner && !isFriend;
    }

    public long getTotalDamaged() {
        return this.targets.values().stream().filter(Target::canHurt).count();
    }

    public static <T extends class_1297> Predicate<T> validTarget(Affine affine, Caster<?> source) {
        return target -> TargetSelecter.validTarget(affine, source, target);
    }

    public static boolean validTarget(Affine affine, Caster<?> source, class_1297 target) {
        return !TargetSelecter.isOwnerOrFriend(affine, source, target);
    }

    public static boolean isOwnerOrFriend(Affine affine, Caster<?> source, class_1297 target) {
        return affine.applyInversion(source, source.isOwnerOrFriend(target));
    }

    private static final class Target {
        private int cooldown = 20;

        Target(UUID id) {
        }

        boolean tick() {
            return --this.cooldown < 0;
        }

        boolean canHurt() {
            return this.cooldown == 20;
        }
    }
}

