/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.block.SegmentedBlock;
import com.minelittlepony.unicopia.compat.seasons.FertilizableUtil;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SegmentedCropBlock
extends class_2302
implements SegmentedBlock {
    private static final Codec<Supplier<SegmentedCropBlock>> SEGMENT_CODEC = CodecUtils.supplierOf(class_7923.field_41175.method_39673().xmap(b -> (SegmentedCropBlock)b, b -> b));
    public static final MapCodec<SegmentedCropBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("max_age").forGetter(b -> b.method_9824().method_11898().stream().mapToInt(i -> i).max().orElse(0)), (App)Codec.INT.fieldOf("progression_age").forGetter(b -> b.progressionAge), (App)CodecUtils.ITEM.fieldOf("seeds").forGetter(b -> b.seeds), (App)SEGMENT_CODEC.optionalFieldOf("prev", null).forGetter(b -> b.prevSegmentSupplier), (App)SEGMENT_CODEC.optionalFieldOf("next", null).forGetter(b -> b.nextSegmentSupplier), (App)class_2244.method_54096()).apply((Applicative)instance, SegmentedCropBlock::create));
    static final float BASE_GROWTH_CHANCE = 50.0f;
    private final class_1935 seeds;
    @Nullable
    private final Supplier<SegmentedCropBlock> prevSegmentSupplier;
    @Nullable
    private Supplier<SegmentedCropBlock> nextSegmentSupplier;
    private final int progressionAge;

    public static SegmentedCropBlock create(final int maxAge, int progressionAge, class_1935 seeds, @Nullable Supplier<SegmentedCropBlock> prevSegmentSupplier, @Nullable Supplier<SegmentedCropBlock> nextSegmentSupplier, class_4970.class_2251 settings) {
        final class_2758 age = class_2758.method_11867((String)"age", (int)0, (int)maxAge);
        return new SegmentedCropBlock(progressionAge, settings, seeds, prevSegmentSupplier, nextSegmentSupplier){

            @Override
            public class_2758 method_9824() {
                return age;
            }

            public int method_9827() {
                return maxAge;
            }

            protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
                builder.method_11667(new class_2769[]{age});
            }
        };
    }

    protected SegmentedCropBlock(int progressionAge, class_4970.class_2251 settings, class_1935 seeds, @Nullable Supplier<SegmentedCropBlock> prevSegmentSupplier, @Nullable Supplier<SegmentedCropBlock> nextSegmentSupplier) {
        super(settings);
        this.seeds = seeds;
        this.prevSegmentSupplier = prevSegmentSupplier;
        this.nextSegmentSupplier = nextSegmentSupplier;
        this.progressionAge = progressionAge;
    }

    public class_2758 method_9824() {
        return super.method_9824();
    }

    public SegmentedCropBlock createNext(int progressionAge) {
        SegmentedCropBlock next = SegmentedCropBlock.create(this.method_9827() - this.progressionAge, progressionAge, this.seeds, () -> this, null, class_4970.class_2251.method_9630((class_4970)this));
        this.nextSegmentSupplier = () -> next;
        return next;
    }

    public MapCodec<? extends SegmentedCropBlock> method_53969() {
        return CODEC;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        double d;
        class_2338 tip = this.getTip(world, pos);
        class_2338 root = this.getRoot(world, pos);
        int height = tip.method_10264() - root.method_10264();
        class_2680 tipState = world.method_8320(tip);
        class_2248 class_22482 = tipState.method_26204();
        if (class_22482 instanceof SegmentedCropBlock) {
            SegmentedCropBlock tipBlock = (SegmentedCropBlock)class_22482;
            d = SegmentedBlock.getHeight(tipBlock.method_9829(tipState));
        } else {
            d = 0.0;
        }
        double tipHeight = d;
        double offset = (root.method_10264() - pos.method_10264()) * 16;
        return class_2248.method_9541((double)0.0, (double)offset, (double)0.0, (double)16.0, (double)((double)(height * 16) + tipHeight + offset), (double)16.0);
    }

    public class_1935 method_9832() {
        return this.seeds;
    }

    protected boolean method_9695(class_2680 state, class_1922 view, class_2338 pos) {
        SegmentedCropBlock o;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof SegmentedCropBlock && (o = (SegmentedCropBlock)class_22482).canSupportBlock((class_2248)this, state, view, pos) || super.method_9695(state, view, pos);
    }

    protected boolean canSupportBlock(class_2248 other, class_2680 state, class_1922 view, class_2338 pos) {
        return this.nextSegmentSupplier != null && this.nextSegmentSupplier.get() == other;
    }

    public void method_9826(class_1937 world, class_2338 pos, class_2680 state) {
        super.method_9826(world, pos, state);
        this.propagateGrowth(world, pos, state);
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11036 && !this.isNext(neighborState)) {
            return (class_2680)state.method_11657((class_2769)this.method_9824(), (Comparable)Integer.valueOf(Math.min((Integer)state.method_11654((class_2769)this.method_9824()), this.method_9827() - 1)));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int age;
        class_2338 tip = this.getTip((class_1922)world, pos);
        class_2338 root = this.getRoot((class_1922)world, pos);
        if (root.method_10264() != pos.method_10264()) {
            return;
        }
        if (world.method_22335(tip, 0) >= 9 && (age = this.method_9829(state)) < this.method_9827()) {
            float moisture = class_2302.method_9830((class_2248)world.method_8320(root).method_26204(), (class_1922)world, (class_2338)root);
            int steps = FertilizableUtil.getGrowthSteps(world, pos, state, random);
            while (steps-- > 0) {
                if (random.method_43048((int)(50.0f / moisture) + 1) != 0) continue;
                world.method_8652(pos, this.method_9828(age + 1), 2);
                this.propagateGrowth((class_1937)world, pos, state);
            }
        }
    }

    private void propagateGrowth(class_1937 world, class_2338 pos, class_2680 state) {
        int oldAge = this.method_9829(state);
        state = world.method_8320(pos);
        int ageChange = Math.max(1, this.method_9829(state) - oldAge);
        this.onGrown(world, pos, state, ageChange);
        class_2338 root = this.getRoot((class_1922)world, pos);
        class_2338 tip = this.getTip((class_1922)world, pos);
        for (class_2338 p : class_2338.method_10097((class_2338)root, (class_2338)tip)) {
            class_2680 s;
            class_2248 class_22482;
            if (p.method_10264() == pos.method_10264() || !((class_22482 = (s = world.method_8320(p)).method_26204()) instanceof SegmentedCropBlock)) continue;
            SegmentedCropBlock segment = (SegmentedCropBlock)class_22482;
            int segAge = Math.min(segment.method_9829(s) + ageChange, segment.method_9827());
            world.method_8501(p, (class_2680)s.method_11657((class_2769)segment.method_9824(), (Comparable)Integer.valueOf(segAge)));
            segment.onGrown(world, p, s, ageChange);
        }
    }

    private void onGrown(class_1937 world, class_2338 pos, class_2680 state, int ageChange) {
        if (this.nextSegmentSupplier != null && this.method_9829(state) >= this.progressionAge && world.method_22347(pos.method_10084())) {
            SegmentedCropBlock nxt = this.nextSegmentSupplier.get();
            world.method_8652(pos.method_10084(), nxt.method_9828(Math.min(ageChange, nxt.method_9827())), 2);
        }
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        class_2256 f;
        class_2248 class_22482;
        if (super.method_9651(world, pos, state)) {
            return true;
        }
        if (this.nextSegmentSupplier == null) {
            return false;
        }
        state = world.method_8320(pos = pos.method_10084());
        return state.method_26215() || this.isNext(state) && (class_22482 = state.method_26204()) instanceof class_2256 && (f = (class_2256)class_22482).method_9651(world, pos, state);
    }

    protected int method_9831(class_1937 world) {
        return super.method_9831(world) / 2;
    }

    @Override
    public boolean isBase(class_2680 state) {
        return state.method_26204() == this || this.prevSegmentSupplier != null && this.prevSegmentSupplier.get().isBase(state);
    }

    @Override
    public boolean isNext(class_2680 state) {
        return state.method_26204() == this || this.nextSegmentSupplier != null && this.nextSegmentSupplier.get().isNext(state);
    }

    @Nullable
    public SegmentedCropBlock getNext() {
        return this.nextSegmentSupplier == null ? null : this.nextSegmentSupplier.get();
    }
}

