/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import java.util.Arrays;
import java.util.function.Supplier;

class ExpandableList<T> {
    private final Supplier<T> defaultValue;
    private Object[] values;
    private int size;

    public ExpandableList(int initialCapacity, Supplier<T> defaultValue) {
        this.defaultValue = defaultValue;
        this.values = new Object[Math.max(0, initialCapacity)];
    }

    public int size() {
        return this.size;
    }

    public T get(int index) {
        Object t = this.values[index];
        if (t == null) {
            this.values[index] = t = this.defaultValue.get();
        }
        return (T)t;
    }

    public T getOrExpand(int index) {
        this.resize(index);
        return this.get(index);
    }

    public void set(int index, T value) {
        this.resize(index);
        this.values[index] = value;
    }

    private void resize(int index) {
        if (index >= this.values.length) {
            this.values = Arrays.copyOf(this.values, Math.max(index + 1, (this.values.length + 1) * 2));
        }
        this.size = Math.max(index + 1, this.size);
    }
}

