/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.zap;

import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.block.zap.ZapAppleLeavesBlock;
import com.minelittlepony.unicopia.server.world.ZapAppleStageStore;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public interface ZapStagedBlock {
    public ZapAppleStageStore.Stage getStage(class_2680 var1);

    default public void updateStage(class_2680 state, class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)world;
        ZapAppleStageStore.Stage currentStage = ZapAppleStageStore.get((class_1937)sw).getStage();
        if (currentStage != this.getStage(state)) {
            state = this.getState(currentStage);
            world.method_8501(pos, state);
        }
        world.method_39279(pos, state.method_26204(), 1);
    }

    default public void tryAdvanceStage(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int transitionRate;
        ZapAppleStageStore store = ZapAppleStageStore.get((class_1937)world);
        ZapAppleStageStore.Stage currentStage = store.getStage();
        if (!(world.method_8530() || currentStage == this.getStage(state) || (transitionRate = this.getTransitionRate(currentStage)) != 0 && random.method_43048(transitionRate) != 0)) {
            state = this.getState(currentStage);
            world.method_8501(pos, state);
            ZapStagedBlock.onStageChanged(store, currentStage, world, state, pos, random);
        }
        world.method_39279(pos, state.method_26204(), 1);
    }

    default public int getTransitionRate(ZapAppleStageStore.Stage stage) {
        if (stage == ZapAppleStageStore.Stage.HIBERNATING || stage == ZapAppleStageStore.Stage.GREENING) {
            return 10;
        }
        return 2500;
    }

    default public class_2680 getState(ZapAppleStageStore.Stage stage) {
        if (stage == ZapAppleStageStore.Stage.HIBERNATING) {
            return UBlocks.ZAP_LEAVES_PLACEHOLDER.method_9564();
        }
        if (stage == ZapAppleStageStore.Stage.FLOWERING) {
            return UBlocks.FLOWERING_ZAP_LEAVES.method_9564();
        }
        return (class_2680)UBlocks.ZAP_LEAVES.method_9564().method_11657(ZapAppleLeavesBlock.STAGE, (Comparable)((Object)stage));
    }

    private static void onStageChanged(ZapAppleStageStore store, ZapAppleStageStore.Stage stage, class_3218 world, class_2680 state, class_2338 pos, class_5819 random) {
        boolean mustFruit = class_5819.method_43049((long)state.method_26190(pos)).method_43048(5) < 2;
        class_2680 below = world.method_8320(pos.method_10074());
        if (world.method_22347(pos.method_10074()) && stage == ZapAppleStageStore.Stage.FRUITING && mustFruit) {
            world.method_8652(pos.method_10074(), UBlocks.ZAP_BULB.method_9564(), 3);
            store.triggerLightningStrike(pos);
        }
        if (stage != ZapAppleStageStore.Stage.HIBERNATING && world.method_8409().method_43048(10) == 0) {
            store.triggerLightningStrike(pos);
        }
        if (stage == ZapAppleStageStore.Stage.RIPE && below.method_27852(UBlocks.ZAP_BULB)) {
            world.method_8652(pos.method_10074(), UBlocks.ZAP_APPLE.method_9564(), 3);
            store.playMoonEffect(pos);
        }
        if (mustFruit && stage == ZapAppleStageStore.Stage.HIBERNATING && (below.method_27852(UBlocks.ZAP_APPLE) || below.method_27852(UBlocks.ZAP_BULB))) {
            world.method_8501(pos.method_10074(), class_2246.field_10124.method_9564());
        }
    }
}

