/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.element.Toggle;
import com.minelittlepony.common.client.gui.packing.GridPacker;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.unicopia.Config;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.gui.TribeButton;
import java.util.Set;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class LanSettingsScreen
extends GameGui {
    private static final GridPacker WHITELIST_GRID_PACKER = new GridPacker().setItemSpacing(25).setListWidth(200).setItemWidth(30).setItemHeight(0);
    private final Config config = Unicopia.getConfig();
    private final ScrollContainer content = new ScrollContainer();
    private boolean forceShowWhitelist;
    private boolean forceHideWhitelist;

    public LanSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"unicopia.options.title"), parent);
        this.content.margin.setVertical(30);
        this.content.getContentPadding().setHorizontal(10);
        this.content.getContentPadding().top = 10;
        this.content.getContentPadding().bottom = 20;
    }

    public void method_25426() {
        this.content.init(this::rebuildContent);
    }

    private void rebuildContent() {
        boolean whitelistEnabled;
        int LEFT = this.content.field_22789 / 2 - 100;
        class_1132 server = this.field_22787.method_1576();
        boolean canEditWhitelist = this.field_22787.field_1687 == null || server != null;
        this.getChildElements().add(this.content);
        ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 5).setCentered())).getStyle().setText(this.method_25440().getString());
        ((Button)this.addButton((class_364)new Button(this.field_22789 / 2 - 100, this.field_22790 - 25))).onClick(sender -> this.finish()).getStyle().setText("gui.done");
        int row = 0;
        ((Label)this.content.addButton((class_364)new Label(LEFT, row += 20))).getStyle().setText("unicopia.options.lan");
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, ((Boolean)this.config.enableCheats.get()).booleanValue()))).onChange(v -> {
            this.config.enableCheats.set(v);
            return v;
        }).getStyle().setText("unicopia.options.cheats");
        Set whitelist = (Set)this.config.speciesWhiteList.get();
        boolean bl = whitelistEnabled = (this.forceShowWhitelist || !whitelist.isEmpty()) && !this.forceHideWhitelist;
        if (whitelist.isEmpty() && this.forceShowWhitelist) {
            for (Race r : Race.REGISTRY) {
                if (r.isUnset()) continue;
                whitelist.add(r.getId().toString());
            }
        }
        ((Toggle)this.content.addButton((class_364)new Toggle(LEFT, row += 20, whitelistEnabled))).onChange(v -> {
            this.forceShowWhitelist = v;
            this.forceHideWhitelist = v == false;
            this.method_25426();
            return v;
        }).setEnabled(canEditWhitelist).getStyle().setText("unicopia.options.whitelist");
        if (whitelistEnabled) {
            ((Label)this.content.addButton((class_364)new Label(LEFT, row += 20))).getStyle().setText((class_2561)class_2561.method_43471((String)"unicopia.options.whitelist.details").method_27692(class_124.field_1077));
            row += 20;
            WHITELIST_GRID_PACKER.start();
            for (Race race : Race.REGISTRY) {
                if (race.isUnset() || !race.availability().isGrantable()) continue;
                Bounds bound = WHITELIST_GRID_PACKER.next();
                Button button = ((Toggle)this.content.addButton((class_364)new Toggle(LEFT + bound.left + 10, row + bound.top, whitelist.contains(race.getId().toString())))).onChange(v -> {
                    if (v.booleanValue()) {
                        whitelist.add(race.getId().toString());
                    } else {
                        whitelist.remove(race.getId().toString());
                    }
                    return v;
                }).setEnabled(canEditWhitelist).setStyle(LanSettingsScreen.createStyle(race));
                ((TextureSprite)button.getStyle().getIcon()).setPosition(-20, 0);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(context, mouseX, mouseY, tickDelta);
        this.content.method_25394(context, mouseX, mouseY, tickDelta);
    }

    public void method_25432() {
        if (this.forceHideWhitelist) {
            ((Set)this.config.speciesWhiteList.get()).clear();
        }
        this.config.save();
    }

    public static Style createStyle(Race race) {
        return new Style().setIcon(TribeButton.createSprite(race, 2, 2, 15)).setTooltip(race.getTranslationKey(), 0, 10);
    }
}

