/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.minelittlepony.unicopia.entity.mob.LevitatingItemEntity;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgPlayerTargetEntity;
import com.minelittlepony.unicopia.util.Trace;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_744;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector4f;

public class LevitatingItemActionWheel {
    @Nullable
    public LevitatingItemEntity targetEntity;
    private class_243 targetPosition = class_243.field_1353;
    @Nullable
    public LevitatingItemEntity.Action currentAction;
    private int unfocusDelay;
    private final class_310 client = class_310.method_1551();

    public void tick(class_310 client, Pony pony) {
        LevitatingItemEntity target;
        if (this.currentAction == LevitatingItemEntity.Action.MOVE && this.targetEntity != null && this.unfocusDelay > 0) {
            --this.unfocusDelay;
            pony.setLookedEntity(this.targetEntity);
            return;
        }
        class_1297 class_12972 = client.field_1692;
        this.targetEntity = class_12972 instanceof LevitatingItemEntity ? (target = (LevitatingItemEntity)class_12972) : (LevitatingItemEntity)Trace.create(pony.asEntity(), 100.0, client.method_60646().method_60637(false), e -> e instanceof LevitatingItemEntity).getEntity().orElse(null);
        if (this.targetEntity != null) {
            this.targetPosition = this.targetEntity.method_19538();
        }
        pony.setLookedEntity(this.targetEntity);
    }

    public boolean handleInput(class_744 input) {
        if (this.currentAction == LevitatingItemEntity.Action.MOVE && this.targetEntity != null) {
            int verticalMovement;
            class_241 horizontalMovement = input.method_3128();
            int n = input.field_3904 ? 1 : (verticalMovement = input.field_3903 ? -1 : 0);
            if (horizontalMovement.method_35584() > 1.0E-5f || verticalMovement != 0) {
                this.unfocusDelay = 30;
                input.field_3903 = false;
                Channel.CLIENT_PLAYER_LOOK_AT_ENTITY.sendToServer((Object)new MsgPlayerTargetEntity(Optional.of(this.targetEntity.method_5628()), Optional.of(UHud.INSTANCE.levitatingItemActions.currentAction), Optional.of(new class_243((double)horizontalMovement.field_1343, (double)verticalMovement, (double)horizontalMovement.field_1342).method_1024(-this.client.field_1773.method_19418().method_19330() * ((float)Math.PI / 180)))));
            }
        }
        return this.currentAction == LevitatingItemEntity.Action.MOVE;
    }

    private Vector2i getCrosshairPos() {
        class_310 client = class_310.method_1551();
        int scaledWidth = client.method_22683().method_4486();
        int scaledHeight = client.method_22683().method_4502();
        class_4184 cam = client.field_1773.method_19418();
        class_243 offset = (this.currentAction == LevitatingItemEntity.Action.MOVE ? this.targetPosition : this.targetEntity.method_19538()).method_1031(0.0, (double)(this.targetEntity.method_17682() * 0.5f), 0.0).method_1020(cam.method_19326());
        Quaternionf rotation = cam.method_23767().conjugate(new Quaternionf());
        Matrix4f matrix = new Matrix4f().identity().rotate((Quaternionfc)rotation);
        Vector4f projectedPosition = matrix.transform(new Vector4f((float)offset.field_1352, (float)offset.field_1351, (float)offset.field_1350, 0.0f));
        int crosshairX = -((int)(projectedPosition.x * (float)scaledWidth));
        int crosshairY = (int)(projectedPosition.y * (float)scaledHeight);
        return new Vector2i(crosshairX, crosshairY);
    }

    public void render(class_332 context, float tickDelta) {
        if (this.targetEntity == null) {
            this.currentAction = null;
            return;
        }
        Pony.of((class_1657)this.client.field_1724).setLookedEntity(this.targetEntity);
        int scaledWidth = this.client.method_22683().method_4486();
        int scaledHeight = this.client.method_22683().method_4502();
        Vector2i crosshair = this.getCrosshairPos();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904((double)scaledWidth * 0.5, (double)scaledHeight * 0.5, 0.0);
        DrawableUtil.drawLine(matrices, crosshair.x, crosshair.y - 5, crosshair.x, crosshair.y + 5, -1);
        DrawableUtil.drawLine(matrices, crosshair.x - 5, crosshair.y, crosshair.x + 5, crosshair.y, -1);
        this.drawOptionsWheel(context, crosshair, this.targetEntity.getDefaultAction(), this.targetEntity.getValidActions());
        matrices.method_22909();
    }

    private void drawOptionsWheel(class_332 context, Vector2i crosshair, LevitatingItemEntity.Action defaultAction, List<LevitatingItemEntity.Action> options) {
        double rad;
        int ringInnerDiameter = 30;
        int ringOuterDiameter = 55;
        int ringMarkerWidth = 3;
        int iconSize = 17;
        int segmenticonRadius = ringInnerDiameter + ringInnerDiameter / 2;
        int segmentCount = options.size();
        double segmentAngle = Math.PI * 2 / (double)segmentCount;
        double segmentsStartAngle = Math.PI - segmentAngle / 2.0;
        double theta = Math.atan2(crosshair.x, -crosshair.y) + Math.PI;
        int selection = this.getSelection(theta, rad = Math.max((double)crosshair.y / Math.cos(theta), (double)(-crosshair.x) / Math.sin(theta)), segmentsStartAngle, segmentAngle);
        this.currentAction = selection < 0 || selection >= options.size() ? defaultAction : options.get(selection);
        DrawableUtil.drawArc(context.method_51448(), ringInnerDiameter, ringInnerDiameter + 1, 0.0, Math.PI * 2, -222);
        DrawableUtil.drawArc(context.method_51448(), ringInnerDiameter, ringOuterDiameter, 0.0, Math.PI * 2, 85);
        DrawableUtil.drawArc(context.method_51448(), ringOuterDiameter, ringOuterDiameter + ringMarkerWidth, theta - segmentAngle / 2.0, segmentAngle, -187);
        class_2561 selectedItemLabel = this.currentAction.getLabel();
        class_327 class_3272 = this.client.field_1772;
        int n = -this.client.field_1772.method_27525((class_5348)selectedItemLabel) / 2;
        Objects.requireNonNull(this.client.field_1772);
        context.method_51439(class_3272, selectedItemLabel, n, -9 / 2, -1, true);
        for (int i = 0; i < segmentCount; ++i) {
            double segmentMinAngle = ((double)i * segmentAngle + segmentsStartAngle) % (Math.PI * 2);
            if (i == selection) {
                DrawableUtil.drawArc(context.method_51448(), ringInnerDiameter, ringOuterDiameter, segmentMinAngle, segmentAngle, -219);
            }
            LevitatingItemEntity.Action action = options.get(i);
            float iconPositionAngle = (float)(-segmentMinAngle - segmentAngle * 0.5);
            int x = (int)(class_3532.method_15374((float)iconPositionAngle) * (float)segmenticonRadius);
            int y = (int)(class_3532.method_15362((float)iconPositionAngle) * (float)segmenticonRadius);
            context.method_25290(UHud.HUD_TEXTURE, x - iconSize / 2, y - iconSize / 2, (float)(144 + action.getU() * iconSize), (float)(action.getV() * iconSize), iconSize, iconSize, 256, 256);
        }
    }

    private int getSelection(double theta, double rad, double firstSegmentStart, double segmentSize) {
        if (rad <= 0.0) {
            return -1;
        }
        if ((theta -= firstSegmentStart) < 0.0) {
            theta += Math.PI * 2;
        }
        theta %= Math.PI * 2;
        return (int)(theta /= segmentSize);
    }
}

