/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilityDispatcher;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.client.KeyBindingsHandler;
import com.minelittlepony.unicopia.client.UnicopiaClient;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

class Slot {
    protected final UHud uHud;
    private final AbilitySlot aSlot;
    private final AbilitySlot bSlot;
    protected int x;
    protected int y;
    private float lastCooldown;
    private final int slotPadding;
    private final int labelX;
    private final int labelY;
    private final int size;
    private final int iconSize;
    private int backgroundU;
    private int backgroundV;
    private int foregroundU = 105;
    private int foregroundV = 105;

    public Slot(UHud uHud, AbilitySlot normalSlot, AbilitySlot backupSlot, int x, int y) {
        this(uHud, normalSlot, backupSlot, x, y, 3, 22, 17, 17, 19);
        this.background(80, 105);
    }

    public Slot(UHud uHud, AbilitySlot normalSlot, AbilitySlot backupSlot, int x, int y, int padding, int size, int labelX, int labelY, int iconSize) {
        this.uHud = uHud;
        this.aSlot = normalSlot;
        this.bSlot = backupSlot;
        this.x = x;
        this.y = y;
        this.slotPadding = padding;
        this.labelX = labelX;
        this.labelY = labelY;
        this.size = size;
        this.iconSize = iconSize;
    }

    Slot background(int u, int v) {
        this.backgroundU = u;
        this.backgroundV = v;
        return this;
    }

    Slot foreground(int u, int v) {
        this.foregroundU = u;
        this.foregroundV = v;
        return this;
    }

    int getX() {
        if (this.uHud.xDirection < 0) {
            return 49 - this.size - this.x;
        }
        return this.x;
    }

    int getY() {
        return this.y;
    }

    void renderBackground(class_332 context, AbilityDispatcher abilities, boolean bSwap, float tickDelta) {
        if (this.aSlot != this.bSlot) {
            bSwap |= !abilities.isFilled(this.aSlot);
            bSwap &= abilities.isFilled(this.bSlot);
        }
        int page = (Integer)Unicopia.getConfig().hudPage.get();
        AbilityDispatcher.Stat stat = abilities.getStat(bSwap ? this.bSlot : this.aSlot);
        if (stat.getAbility(page).isEmpty() && (this.aSlot != AbilitySlot.PRIMARY || !abilities.getStat(AbilitySlot.SECONDARY).getAbility(page).isEmpty() && !abilities.getStat(AbilitySlot.TERTIARY).getAbility(page).isEmpty())) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)this.getX(), (float)this.getY(), 0.0f);
        context.method_25290(UHud.HUD_TEXTURE, 0, 0, (float)this.backgroundU, (float)this.backgroundV, this.size, this.size, 128, 128);
        int iconPosition = (this.size - this.iconSize + this.slotPadding + 1) / 2;
        int sz = this.iconSize - this.slotPadding;
        this.uHud.renderAbilityIcon(context, stat, iconPosition, iconPosition, sz, sz, sz, sz);
        float cooldown = stat.getFillProgress();
        if (cooldown > 0.0f && cooldown <= 1.0f) {
            float lerpCooldown;
            this.lastCooldown = lerpCooldown = class_3532.method_16439((float)tickDelta, (float)cooldown, (float)this.lastCooldown);
            int progressBottom = this.size - this.slotPadding;
            int progressMax = this.size - this.slotPadding * 2;
            int progressTop = progressBottom - (int)((float)progressMax * cooldown);
            context.method_25294(this.slotPadding, progressTop, this.size - this.slotPadding, progressBottom, -805306369);
        }
        this.renderContents(context, abilities, bSwap, tickDelta);
        matrices.method_22909();
    }

    protected void renderContents(class_332 context, AbilityDispatcher abilities, boolean bSwap, float tickDelta) {
        boolean flip;
        boolean bl = flip = class_310.method_1551().field_1724.method_6068() == class_1306.field_6182;
        if (flip) {
            context.method_25293(UHud.HUD_TEXTURE, 0, 0, this.size, this.size, (float)(this.foregroundU + this.size), (float)this.foregroundV, -this.size, this.size, 128, 128);
        } else {
            context.method_25290(UHud.HUD_TEXTURE, 0, 0, (float)this.foregroundU, (float)this.foregroundV, this.size, this.size, 128, 128);
        }
    }

    void renderLabel(class_332 context, AbilityDispatcher abilities, float tickDelta) {
        Optional<Ability<?>> ability = abilities.getStat(this.aSlot).getAbility(((Integer)Unicopia.getConfig().hudPage.get()).intValue());
        if (ability.isEmpty()) {
            return;
        }
        class_5250 label = KeyBindingsHandler.INSTANCE.getBinding(this.aSlot).getLabel().method_27661();
        int x = this.getX();
        if (this.uHud.xDirection > 0) {
            x += this.labelX;
        } else {
            x += this.labelX - this.size / 3;
            x -= this.uHud.client.field_1772.method_27525((class_5348)label) / 2;
        }
        ActivationType activation = KeyBindingsHandler.INSTANCE.getForcedActivationType();
        if (activation.isResult()) {
            label = label.method_27693("+T" + activation.getTapCount());
            if (!ability.get().acceptsQuickAction(UnicopiaClient.getClientPony(), activation)) {
                label = label.method_27692(class_124.field_1061);
            }
        }
        DrawableUtil.drawScaledText(context, (class_2561)label, x, this.getY() + this.labelY, 0.5f, -1);
    }
}

