/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilityDispatcher;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.GradientUtil;
import com.minelittlepony.unicopia.client.gui.HidesHud;
import com.minelittlepony.unicopia.client.gui.HudPosition;
import com.minelittlepony.unicopia.client.gui.LevitatingItemActionWheel;
import com.minelittlepony.unicopia.client.gui.ManaRingSlot;
import com.minelittlepony.unicopia.client.gui.Slot;
import com.minelittlepony.unicopia.client.gui.SpellIconRenderer;
import com.minelittlepony.unicopia.client.render.RenderLayers;
import com.minelittlepony.unicopia.client.render.spell.DarkVortexSpellRenderer;
import com.minelittlepony.unicopia.client.sound.LoopingSoundInstance;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import com.minelittlepony.unicopia.entity.effect.SunBlindnessStatusEffect;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.AmuletItem;
import com.minelittlepony.unicopia.item.GlassesItem;
import com.minelittlepony.unicopia.item.UItems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_744;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class UHud {
    public static final UHud INSTANCE = new UHud();
    public static final class_2960 HUD_TEXTURE = Unicopia.id("textures/gui/hud.png");
    public static final int PRIMARY_SLOT_SIZE = 49;
    private static final float EQUIPPED_GEMSTONE_SCALE = 0.7f;
    public class_327 font;
    final class_310 client = class_310.method_1551();
    private final List<Slot> slots = List.of(new ManaRingSlot(this, AbilitySlot.PRIMARY, AbilitySlot.PASSIVE, 0, 0), new Slot(this, AbilitySlot.SECONDARY, AbilitySlot.SECONDARY, 30, -10), new Slot(this, AbilitySlot.TERTIARY, AbilitySlot.TERTIARY, 43, 10));
    public final LevitatingItemActionWheel levitatingItemActions = new LevitatingItemActionWheel();
    @Nullable
    private class_2561 message;
    private int messageTime;
    int xDirection;
    @Nullable
    private LoopingSoundInstance<class_1657> heartbeatSound;
    @Nullable
    private LoopingSoundInstance<class_1657> partySound;
    private boolean prevPointed;
    private boolean prevReplacing;
    private SpellType<?> focusedType = SpellType.empty();

    public void render(class_329 hud, class_332 context, class_9779 tickCounter) {
        boolean canCast;
        float exhaustion;
        HudPosition.Alignment armAlignment;
        if (this.client.field_1724 == null) {
            return;
        }
        RenderSystem.enableDepthTest();
        int scaledWidth = this.client.method_22683().method_4486();
        int scaledHeight = this.client.method_22683().method_4502();
        class_4587 matrices = context.method_51448();
        Pony pony = Pony.of((class_1657)this.client.field_1724);
        float tickDelta = tickCounter.method_60637(false);
        matrices.method_22903();
        this.renderViewEffects(pony, context, scaledWidth, scaledHeight, tickDelta);
        matrices.method_22909();
        if (this.client.field_1755 instanceof HidesHud || this.client.field_1724.method_7325() || this.client.field_1690.field_1842) {
            return;
        }
        this.font = this.client.field_1772;
        HudPosition hudPos = (HudPosition)((Object)Unicopia.getConfig().hudPosition.get());
        HudPosition.Alignment alignment = armAlignment = this.client.field_1724.method_6068() == class_1306.field_6182 ? HudPosition.Alignment.START : HudPosition.Alignment.END;
        if (hudPos == HudPosition.OFF_HAND) {
            armAlignment = armAlignment.opposite();
        }
        this.xDirection = hudPos.getHorizontal().or(armAlignment.opposite()).opposite().getSignum();
        this.levitatingItemActions.render(context, tickDelta);
        matrices.method_22903();
        matrices.method_46416((float)(scaledWidth / 2), (float)(scaledHeight / 2), 0.0f);
        float flapCooldown = pony.getPhysics().getFlapCooldown(tickDelta);
        if (flapCooldown > 0.0f) {
            float angle = (float)Math.PI * 2 * flapCooldown;
            DrawableUtil.drawArc(context.method_51448(), 3.0, 6.0, -angle / 2.0f, angle, -2004318033);
        }
        matrices.method_22909();
        matrices.method_22903();
        int hudX = hudPos.getHorizontal().pick(2, scaledWidth - 50, (scaledWidth - 50) / 2 + 109 * armAlignment.getSignum());
        int hudY = hudPos.getVertical().pick(12, scaledHeight - 50, scaledHeight - 50);
        if (hudPos == HudPosition.BOTTOM_CENTER) {
            hudY -= 22;
        }
        if ((exhaustion = pony.getMagicalReserves().getExhaustion().getPercentFill()) > 0.5f || EquinePredicates.RAGING.test((class_1297)this.client.field_1724)) {
            class_5819 rng = this.client.field_1687.field_9229;
            hudX = (int)((float)hudX + (rng.method_43057() - 0.5f));
            hudY = (int)((float)hudY + (rng.method_43057() - 0.5f));
        }
        matrices.method_46416((float)hudX, (float)hudY, 0.0f);
        AbilityDispatcher abilities = pony.getAbilities();
        if (this.message != null && this.messageTime > 0) {
            this.renderMessage(context, tickDelta);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        boolean swap = this.client.field_1690.field_1832.method_1434();
        this.slots.forEach(slot -> slot.renderBackground(context, abilities, swap, tickDelta));
        int currentPage = (Integer)Unicopia.getConfig().hudPage.get();
        int maxPages = pony.getAbilities().getMaxPage();
        Ability ability = pony.getAbilities().getStat(AbilitySlot.PRIMARY).getAbility(currentPage).orElse(null);
        boolean bl = canCast = ability == Abilities.CAST || ability == Abilities.KIRIN_CAST || ability == Abilities.SHOOT;
        if (canCast) {
            boolean replacing;
            matrices.method_22903();
            matrices.method_46416(24.5f, 24.5f, 0.0f);
            boolean first = !((class_1657)pony.asEntity()).method_5715();
            class_1271<CustomisedSpellType<?>> inHand = pony.getCharms().getSpellInHand(false);
            boolean bl2 = replacing = inHand.method_5467().method_23665() && pony.getAbilities().getStat(AbilitySlot.PRIMARY).getActiveAbility().isEmpty();
            if (first != this.prevPointed || replacing != this.prevReplacing || ((CustomisedSpellType)inHand.method_5466()).type() != this.focusedType) {
                this.focusedType = ((CustomisedSpellType)inHand.method_5466()).type();
                this.prevPointed = first;
                this.prevReplacing = replacing;
                this.setMessage(ability.getName(pony));
            }
            int baseAngle = this.xDirection < 0 ? 100 : 0;
            int secondAngleDif = this.xDirection * 30;
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(baseAngle + 37 + (first ? 0 : secondAngleDif))));
            matrices.method_46416(-23.0f, 0.0f, 0.0f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(-26.0f));
            matrices.method_22905(0.8f, 0.8f, 1.0f);
            int u = replacing ? 16 : 3;
            context.method_25290(HUD_TEXTURE, 0, 0, (float)u, 120.0f, 13, 7, 128, 128);
            matrices.method_22909();
        }
        this.slots.forEach(slot -> slot.renderLabel(context, abilities, tickDelta));
        if (this.xDirection < 0) {
            matrices.method_46416(-48.0f, 0.0f, 0.0f);
        }
        DrawableUtil.drawScaledText(context, (class_2561)class_2561.method_43470((String)(currentPage + 1 + "/" + (maxPages + 1))), 44, 38, 0.5f, -1);
        context.method_25290(HUD_TEXTURE, 42, 43, 52.0f, currentPage == 0 ? 6.0f : 0.0f, 6, 6, 128, 128);
        context.method_25290(HUD_TEXTURE, 48, 43, 57.0f, currentPage < maxPages ? 0.0f : 6.0f, 8, 6, 128, 128);
        matrices.method_22909();
        if (canCast) {
            matrices.method_22903();
            if (this.xDirection < 0) {
                hudX = (int)((float)hudX + 16.5f);
            }
            SpellIconRenderer.renderSpell(context, pony.getCharms().getEquippedSpell(class_1268.field_5808), hudX + 10 - this.xDirection * 13, hudY + 2, 0.7f);
            SpellIconRenderer.renderSpell(context, pony.getCharms().getEquippedSpell(class_1268.field_5810), hudX + 8 - this.xDirection * 2, hudY - 6, 0.7f);
            matrices.method_22909();
        }
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private void renderMessage(class_332 context, float tickDelta) {
        float time = (float)this.messageTime - tickDelta;
        int progress = Math.min(255, (int)(time * 255.0f / 20.0f));
        if (progress > 8) {
            int color = class_5253.class_5254.method_58144((int)progress, (int)-1);
            HudPosition hudPos = (HudPosition)((Object)Unicopia.getConfig().hudPosition.get());
            int messageWidth = this.font.method_27525((class_5348)this.message);
            int messageX = hudPos.getHorizontal().pick(0, 25 - messageWidth / 2, -messageWidth + 45, 25 - messageWidth / 2);
            int messageY = hudPos.getVertical().pick(55, -17, -17, -17);
            context.method_51439(this.font, this.message, messageX, messageY, color, true);
        }
    }

    protected void renderViewEffects(Pony pony, class_332 context, int scaledWidth, int scaledHeight, float tickDelta) {
        float exhaustion;
        float vortexDistortion = DarkVortexSpellRenderer.getCameraDistortion();
        if (vortexDistortion > 25.0f) {
            context.method_51739(RenderLayers.method_23574(), 0, 0, scaledWidth, scaledHeight, 0);
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(scaledWidth / 2), (float)(scaledHeight / 2), 0.0f);
            DrawableUtil.drawArc(context.method_51448(), 0.0, 20.0, 0.0, 6.2831854820251465, 255);
            context.method_51448().method_22909();
            return;
        }
        if (vortexDistortion > 0.0f) {
            context.method_25294(0, 0, scaledWidth, scaledHeight, (int)(Math.min(20.0f, vortexDistortion) / 20.0f * 255.0f) << 24);
        }
        boolean hasEffect = this.client.field_1724.method_6059(UEffects.SUN_BLINDNESS);
        class_1799 glasses = GlassesItem.getForEntity((class_1309)this.client.field_1724).stack();
        if (hasEffect || !glasses.method_31573(UTags.Items.PROTECTS_BAT_PONY_EYES) && pony.getObservedSpecies() == Race.BAT && SunBlindnessStatusEffect.hasSunExposure((class_1309)this.client.field_1724)) {
            float i = hasEffect ? ((float)this.client.field_1724.method_6112(UEffects.SUN_BLINDNESS).method_5584() - tickDelta) / 250.0f : 0.0f;
            float pulse = (1.0f + (float)Math.sin((float)this.client.field_1724.field_6012 / 108.0f)) * 0.25f;
            float strength = class_3532.method_15363((float)(pulse + i), (float)0.3f, (float)1.0f);
            int alpha1 = (int)(strength * 205.0f);
            int alpha2 = (int)((float)alpha1 * 0.6f);
            int color = 0xFFFFFF;
            if (hasEffect) {
                GradientUtil.fillRadialGradient(context.method_51448(), 0, 0, scaledWidth, scaledHeight, color | alpha1 << 24, color | alpha2 << 24, 0, 1.0f);
            } else {
                GradientUtil.fillVerticalGradient(context.method_51448(), 0, 0, scaledHeight / 2, scaledWidth, scaledHeight, color | alpha1 << 24, color | alpha2 << 24, color | alpha1 << 24, 0);
            }
        }
        if (glasses.method_31573(UTags.Items.TINTED_SHADES)) {
            if (GlassesItem.isCoolAndHasShades((class_1309)this.client.field_1724)) {
                int delay = 7;
                int current = this.client.field_1724.field_6012 / 7;
                int tint = class_1767.method_7791((int)(current % class_1767.values().length)).method_16357();
                context.method_25296(0, 0, scaledWidth, scaledHeight, 0x1F000000 | tint, 0x5F000000 | tint);
                if (this.partySound == null || this.partySound.method_4793()) {
                    this.partySound = new LoopingSoundInstance<class_1657>((class_1657)this.client.field_1724, GlassesItem::isCoolAndHasShades, (class_3414)USounds.Vanilla.field_23968.comp_349(), 1.0f, 1.0f, this.client.field_1687.field_9229);
                    this.client.method_1483().method_4873(this.partySound);
                } else if (this.partySound != null) {
                    this.partySound.setMuted(false);
                }
            } else {
                if (this.partySound != null) {
                    this.partySound.setMuted(true);
                }
                context.method_25296(0, 0, scaledWidth, scaledHeight, 0xA000088, 0x7E000000);
            }
        } else if (this.partySound != null) {
            this.partySound.setMuted(true);
        }
        if (AmuletItem.isApplicable((class_1309)this.client.field_1724, (class_1935)UItems.ALICORN_AMULET)) {
            float radius = (float)pony.getArmour().getTicks((class_1935)UItems.ALICORN_AMULET) / 120000.0f;
            this.renderVignette(context, 0, radius, radius, scaledWidth, scaledHeight);
        }
        if ((exhaustion = class_3532.method_15363((float)pony.getMagicalReserves().getExhaustion().getPercentFill(), (float)0.0f, (float)0.6f)) > 0.0f) {
            if (exhaustion > 0.5f && (this.heartbeatSound == null || this.heartbeatSound.method_4793())) {
                this.heartbeatSound = new LoopingSoundInstance<class_1657>((class_1657)this.client.field_1724, player -> this.partySound == null && Pony.of(player).getMagicalReserves().getExhaustion().getPercentFill() > 0.5f, USounds.ENTITY_PLAYER_HEARTBEAT_LOOP, 1.0f, 1.0f, this.client.field_1687.field_9229);
                this.client.method_1483().method_4873(this.heartbeatSound);
            }
            float rate = exhaustion > 0.5f ? 2.5f : 7.0f;
            float radius = (1.0f + (float)Math.sin((float)this.client.field_1724.field_6012 / rate)) / 2.0f;
            this.renderVignette(context, 0x880000, exhaustion * radius, 0.1f + radius * 0.3f, scaledWidth, scaledHeight);
        }
        float anger = pony.getMagicalReserves().getCharge().getPercentFill();
        if (pony.getObservedSpecies() == Race.KIRIN && anger >= 1.0f) {
            float radius = (1.0f + (float)Math.sin((float)this.client.field_1724.field_6012 / 25.0f)) / 5.0f;
            this.renderVignette(context, 0, anger * radius, 0.1f + radius * 0.3f, scaledWidth, scaledHeight);
        }
        if (EquinePredicates.RAGING.test((class_1297)this.client.field_1724)) {
            context.method_25296(0, 0, scaledWidth, scaledHeight / 4, -1426128896, 0xFF0000);
            int alpha = 58 + (int)(125.0f * Math.abs(class_3532.method_15374((float)((float)this.client.field_1724.field_6012 / 25.0f))));
            context.method_25294(0, 0, scaledWidth, scaledHeight, 0xFF0000 | alpha << 24);
            context.method_25296(0, (int)((double)scaledHeight / 1.5), scaledWidth, scaledHeight, 0xFF0000, -1426128896);
        }
        if (pony.getPhysics().isFlyingSurvival) {
            float effectStrength = (float)class_3532.method_15350((double)(pony.getPhysics().getClientVelocity().method_1033() / 15.0), (double)0.0, (double)1.0);
            class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
            float innerRadiusPulse = class_3532.method_15362((float)(((float)((class_1657)pony.asEntity()).field_6012 + tickDelta) / 2.0f)) * 6.0f + effectStrength * (float)scaledHeight / 2.0f;
            double points = 22.0;
            float wedgeAngle = 0.05f + class_3532.method_15374((float)(((float)((class_1657)pony.asEntity()).field_6012 + tickDelta) / 3.0f)) * 0.01f;
            float outerRadius = Math.max(scaledWidth, scaledHeight);
            float alpha = effectStrength * (0.6f + Math.abs(class_3532.method_15374((float)(((float)((class_1657)pony.asEntity()).field_6012 + tickDelta) / 10.0f))));
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)scaledWidth / 2.0f, (float)scaledHeight / 2.0f, 0.0f);
            Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
            int i = 0;
            while ((double)i < points) {
                float angle = (float)Math.PI * 2 * (float)i / (float)points - wedgeAngle * 0.5f;
                float innerRadius = Math.max(0.0f, (float)scaledHeight / 2.0f + (float)(i % 2 * 72) + 14.0f * (1.0f - effectStrength) - innerRadiusPulse);
                float centerX = class_3532.method_15374((float)angle) * innerRadius;
                float centerY = class_3532.method_15362((float)angle) * innerRadius;
                vertexConsumer.method_22918(matrix4f, centerX, centerY, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha * 0.3f);
                vertexConsumer.method_22918(matrix4f, class_3532.method_15374((float)(angle - wedgeAngle)) * outerRadius, class_3532.method_15362((float)(angle - wedgeAngle)) * outerRadius, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
                vertexConsumer.method_22918(matrix4f, class_3532.method_15374((float)(angle + wedgeAngle)) * outerRadius, class_3532.method_15362((float)(angle + wedgeAngle)) * outerRadius, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha);
                vertexConsumer.method_22918(matrix4f, centerX, centerY, 0.0f).method_22915(1.0f, 1.0f, 1.0f, alpha * 0.3f);
                ++i;
            }
            context.method_51448().method_22909();
        }
    }

    private void renderVignette(class_332 context, int color, float alpha, float radius, int scaledWidth, int scaledHeight) {
        if (radius <= 0.0f) {
            return;
        }
        float alpha2 = class_3532.method_15363((float)(radius - 1.0f), (float)0.0f, (float)1.0f) * 255.0f;
        float alpha1 = Math.max(alpha2, class_3532.method_15363((float)(alpha * 2.0f), (float)0.0f, (float)1.0f) * 205.0f);
        GradientUtil.fillRadialGradient(context.method_51448(), 0, 0, scaledWidth, scaledHeight, (color &= 0xFFFFFF) | (int)alpha1 << 24, color | (int)alpha2 << 24, 0, Math.min(1.0f, radius));
    }

    public void setMessage(class_2561 message) {
        this.message = message;
        this.messageTime = 60;
    }

    public void tick() {
        if (!this.client.method_1493() && this.messageTime > 0) {
            --this.messageTime;
        }
        if (!this.client.method_1493() && this.client.field_1724 != null) {
            this.levitatingItemActions.tick(this.client, Pony.of((class_1657)this.client.field_1724));
        }
    }

    public boolean handleInput(class_744 input) {
        if (this.client.method_1493() || this.client.field_1724 == null) {
            return false;
        }
        if (Pony.of((class_1657)this.client.field_1724).getAcrobatics().isImmobile()) {
            input.field_3907 = 0.0f;
            input.field_3905 = 0.0f;
        }
        return this.levitatingItemActions.handleInput(input) || EffectUtils.getAmplifier((class_1309)this.client.field_1724, UEffects.PARALYSIS) > 1;
    }

    void renderAbilityIcon(class_332 context, AbilityDispatcher.Stat stat, int x, int y, int u, int v, int frameWidth, int frameHeight) {
        stat.getAbility(((Integer)Unicopia.getConfig().hudPage.get()).intValue()).ifPresent(ability -> context.method_25290(ability.getIcon(Pony.of((class_1657)this.client.field_1724)), x, y, 0.0f, 0.0f, frameWidth, frameHeight, u, v));
    }

    public static class_2960 getHeartTexture(class_329.class_6411 heartsType, class_2960 vanillaTexture, boolean hardcore, boolean blinking, boolean half) {
        if (class_310.method_1551().field_1724 == null || !AmuletItem.isApplicable((class_1309)class_310.method_1551().field_1724, (class_1935)UItems.ALICORN_AMULET) || heartsType == class_329.class_6411.field_33944) {
            // empty if block
        }
        return vanillaTexture;
    }

    @Nullable
    public static class_329.class_6411 getHeartsType(class_1657 player, class_329.class_6411 vanillaHeartType) {
        if (AmuletItem.isApplicable((class_1309)player, (class_1935)UItems.ALICORN_AMULET) || EffectUtils.isChangingRace((class_1309)player)) {
            return class_329.class_6411.field_33947;
        }
        if (EffectUtils.isPoisoned((class_1309)player)) {
            return class_329.class_6411.field_33946;
        }
        return vanillaHeartType;
    }
}

