/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.unicopia.Debug;
import com.minelittlepony.unicopia.client.gui.spellbook.ClientChapters;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.container.spellbook.SpellbookChapter;
import com.minelittlepony.unicopia.container.spellbook.TabSide;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class SpellbookChapterList {
    private final SpellbookScreen screen;
    private final Chapter craftingChapter;
    private final Map<class_2960, Chapter> chapters = new HashMap<class_2960, Chapter>();

    public SpellbookChapterList(SpellbookScreen screen, Chapter craftingChapter, Chapter ... builtIn) {
        this.screen = screen;
        this.craftingChapter = craftingChapter;
        this.chapters.putAll(ClientChapters.getChapters());
        this.chapters.put(craftingChapter.id(), craftingChapter);
        for (Chapter i : builtIn) {
            this.chapters.put(i.id(), i);
        }
    }

    public Stream<Chapter> getTabs(TabSide side) {
        return this.chapters.values().stream().filter(chapter -> chapter.side() == side);
    }

    public Chapter getCurrentChapter() {
        if (Debug.SPELLBOOK_CHAPTERS) {
            ClientChapters.getChapters().forEach((id, chapter) -> this.chapters.compute((class_2960)id, (key, old) -> {
                Optional.ofNullable(old).flatMap(Chapter::content).ifPresent(o -> chapter.content().ifPresent(neu -> neu.copyStateFrom((Content)o)));
                return chapter;
            }));
        }
        return this.screen.getState().getCurrentPageId().map(this.chapters::get).orElse(this.craftingChapter);
    }

    public record Chapter(class_2960 id, TabSide side, int tabY, int color, Optional<Content> content) implements SpellbookChapter
    {
        public static class_2960 createIcon(class_2960 id, String suffex) {
            return id.method_45134(p -> "textures/gui/container/pages/" + p + suffex + ".png");
        }
    }

    public static interface Content
    extends Drawable {
        public void init(SpellbookScreen var1, class_2960 var2);

        default public void copyStateFrom(Content old) {
        }

        default public class_2960 getIcon(Chapter chapter, class_2960 icon) {
            return icon;
        }

        public static Optional<Content> of(final BiConsumer<SpellbookScreen, class_2960> init, final Drawable obj) {
            return Optional.of(new Content(){

                @Override
                public void init(SpellbookScreen screen, class_2960 pageId) {
                    init.accept(screen, pageId);
                }

                @Override
                public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
                    obj.draw(context, mouseX, mouseY, container);
                }
            });
        }
    }

    public static interface Drawable {
        public void draw(class_332 var1, int var2, int var3, IViewRoot var4);
    }
}

