/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.ability.magic.spell.trait.TraitDiscovery;
import com.minelittlepony.unicopia.client.TextHelper;
import com.minelittlepony.unicopia.client.gui.spellbook.IngredientTree;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.group.ItemGroupRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4720;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class SpellbookTraitDexPageContent
implements SpellbookChapterList.Content,
SpellbookScreen.RecipesChangedListener {
    private final Trait[] traits = Trait.values();
    private SpellbookState.PageState state = new SpellbookState.PageState();
    private final DexPage leftPage = new DexPage();
    private final DexPage rightPage = new DexPage();
    private final SpellbookScreen screen;
    private final Function<class_2960, class_2960> unreadIcon = class_156.method_34866(id -> SpellbookChapterList.Chapter.createIcon(id, "_unread"));

    public SpellbookTraitDexPageContent(SpellbookScreen screen) {
        this.screen = screen;
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
    }

    @Override
    public class_2960 getIcon(SpellbookChapterList.Chapter chapter, class_2960 icon) {
        if (Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries().isUnread()) {
            return this.unreadIcon.apply(chapter.id());
        }
        return icon;
    }

    @Override
    public void init(SpellbookScreen screen, class_2960 pageId) {
        this.state = screen.getState().getState(pageId);
        int page = this.state.getOffset() * 2;
        this.leftPage.init(screen, page);
        this.rightPage.init(screen, page + 1);
        screen.addPageButtons(187, 30, 350, incr -> {
            this.state.swap(incr, (int)Math.ceil((float)this.traits.length / 2.0f));
            this.leftPage.verticalScrollbar.scrollBy((double)this.leftPage.verticalScrollbar.getScrubber().getPosition());
            this.rightPage.verticalScrollbar.scrollBy((double)this.rightPage.verticalScrollbar.getScrubber().getPosition());
        });
    }

    public void pageTo(SpellbookScreen screen, Trait trait) {
        int page = Arrays.binarySearch(this.traits, trait);
        if (page < 0) {
            return;
        }
        this.state = screen.getState().getState(SpellbookState.TRAIT_DEX_ID);
        this.state.setOffset(page /= 2);
        this.leftPage.verticalScrollbar.scrollBy((double)this.leftPage.verticalScrollbar.getScrubber().getPosition());
        this.rightPage.verticalScrollbar.scrollBy((double)this.rightPage.verticalScrollbar.getScrubber().getPosition());
        GameGui.playSound((class_3414)USounds.Vanilla.field_17481);
        screen.method_41843();
    }

    @Override
    public void onRecipesChanged() {
        this.init(this.screen, SpellbookState.TRAIT_DEX_ID);
    }

    private final class DexPage
    extends ScrollContainer {
        public DexPage() {
            this.verticalScrollbar.layoutToEnd = true;
            this.backgroundColor = -397357;
            this.getContentPadding().setVertical(10);
        }

        public void init(SpellbookScreen screen, int page) {
            if (page < 0 || page >= SpellbookTraitDexPageContent.this.traits.length) {
                return;
            }
            this.margin.left = screen.getX() + 20;
            this.margin.top = screen.getY() + 15;
            this.margin.right = screen.field_22789 - screen.getBackgroundWidth() - screen.getX() + 25;
            this.margin.bottom = screen.field_22790 - screen.getBackgroundHeight() - screen.getY() + 40;
            if (page % 2 == 1) {
                this.margin.left += screen.getBackgroundWidth() / 2 - 15;
            } else {
                this.margin.right += screen.getBackgroundWidth() / 2 - 15;
            }
            this.init(() -> {
                Trait trait = SpellbookTraitDexPageContent.this.traits[page];
                boolean known = Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries().isKnown(trait);
                this.addButton((class_364)new TraitButton(this.field_22789 / 2 - 8, 8, trait));
                ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 26).setCentered())).getStyle().setText((class_2561)(known ? class_2561.method_43469((String)"gui.unicopia.trait.label", (Object[])new Object[]{class_2561.method_43471((String)("trait." + trait.getId().method_12836() + "." + trait.getId().method_12832() + ".name"))}) : class_2561.method_43470((String)"???")));
                IngredientTree tree = new IngredientTree(0, 50, this.field_22789 + 18).noLabels();
                List<class_1792> knownItems = Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries().getKnownItems(trait).toList();
                SpellTraits.getItems(trait).sorted(Comparator.comparing(u -> knownItems.contains(u) ? 0 : 1)).forEach(i -> {
                    List<class_1799> stacks = ItemGroupRegistry.getVariations(i);
                    if (knownItems.contains(i)) {
                        tree.input(stacks);
                    } else {
                        tree.mystery(stacks);
                    }
                });
                tree.build((IViewRoot)this);
            });
            screen.method_37060(this);
            ((IViewRoot)screen).getChildElements().add(this);
        }

        public void drawOverlays(class_332 context, int mouseX, int mouseY, float tickDelta) {
            int i;
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)this.margin.left, (float)this.margin.top, 0.0f);
            matrices.method_46416(-2.0f, -2.0f, 200.0f);
            RenderSystem.enableBlend();
            int tileSize = 25;
            int bottom = this.field_22790 - tileSize + 4;
            int right = this.field_22789 - tileSize + 9;
            context.method_25290(SpellbookScreen.TEXTURE, 0, 0, 405.0f, 62.0f, tileSize, tileSize, 512, 256);
            context.method_25290(SpellbookScreen.TEXTURE, 0, bottom, 405.0f, 72.0f, tileSize, tileSize, 512, 256);
            for (i = tileSize; i < right; i += tileSize) {
                context.method_25290(SpellbookScreen.TEXTURE, i, 0, 415.0f, 62.0f, tileSize, tileSize, 512, 256);
                context.method_25290(SpellbookScreen.TEXTURE, i, bottom, 415.0f, 72.0f, tileSize, tileSize, 512, 256);
            }
            for (i = tileSize; i < bottom; i += tileSize) {
                context.method_25290(SpellbookScreen.TEXTURE, 0, i, 405.0f, 67.0f, tileSize, tileSize, 512, 256);
                context.method_25290(SpellbookScreen.TEXTURE, right, i, 425.0f, 67.0f, tileSize, tileSize, 512, 256);
            }
            context.method_25290(SpellbookScreen.TEXTURE, right, 0, 425.0f, 62.0f, tileSize, tileSize, 512, 256);
            context.method_25290(SpellbookScreen.TEXTURE, right, bottom, 425.0f, 72.0f, tileSize, tileSize, 512, 256);
            matrices.method_22909();
            if (this == SpellbookTraitDexPageContent.this.rightPage) {
                SpellbookTraitDexPageContent.this.leftPage.drawDelayed(context, mouseX, mouseY, 0.0f);
                SpellbookTraitDexPageContent.this.rightPage.drawDelayed(context, mouseX, mouseY, 0.0f);
            }
        }

        public void drawDelayed(class_332 context, int mouseX, int mouseY, float tickDelta) {
            super.drawOverlays(context, mouseX, mouseY, tickDelta);
        }
    }

    static class TraitButton
    extends SpellbookScreen.ImageButton {
        private final Trait trait;
        private final Style revealedStyle = new Style();
        private final Style hiddenStyle = new Style();

        public TraitButton(int x, int y, Trait trait) {
            super(x, y, 16, 16);
            this.trait = trait;
            this.revealedStyle.setIcon(this::renderIcon).setTooltip(Tooltip.of(TextHelper.wrap(trait.getTooltip(), 200).toList()));
            this.hiddenStyle.setTooltip(Tooltip.of(TextHelper.wrap(trait.getObfuscatedTooltip(), 200).toList()));
            this.onClick(sender -> Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries().markRead(trait));
        }

        private void renderIcon(class_332 context, int x, int y, int mouseX, int mouseY, float partialTicks) {
            float amplify = Math.abs(class_3532.method_15374((float)(((float)class_310.method_1551().field_1724.field_6012 + partialTicks) / 80.0f)) * 8.0f);
            float x1 = 0.0f;
            float x2 = 16.0f + amplify * 2.0f;
            float y1 = 0.0f;
            float y2 = 16.0f + amplify * 2.0f;
            float z = 0.0f;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)x - amplify, (float)y - amplify, 0.0f);
            Matrix4f posMat = context.method_51448().method_23760().method_23761();
            Vector3f normal = context.method_51448().method_23760().method_56820(-1.0f, -1.0f, -1.0f, new Vector3f());
            context.method_51448().method_22909();
            Vector4f vec = new Vector4f();
            class_4597.class_4598 vertices = context.method_51450();
            class_4588 buffer = class_4720.method_24037((class_4588)new class_4583(vertices.getBuffer(class_1921.method_23590()), context.method_51448().method_23760(), 7.8125E-5f), (class_4588)vertices.getBuffer(class_1921.method_23576((class_2960)this.trait.getSprite())));
            int color = -1;
            posMat.transform(vec.set(x1, y1, z));
            buffer.method_23919(vec.x(), vec.y(), vec.z(), color, 0.0f, 0.0f, class_4608.field_21444, 0xF000F0, normal.x(), normal.y(), normal.z());
            posMat.transform(vec.set(x1, y2, z));
            buffer.method_23919(vec.x(), vec.y(), vec.z(), color, 0.0f, 1.0f, class_4608.field_21444, 0xF000F0, normal.x(), normal.y(), normal.z());
            posMat.transform(vec.set(x2, y2, z));
            buffer.method_23919(vec.x(), vec.y(), vec.z(), color, 1.0f, 1.0f, class_4608.field_21444, 0xF000F0, normal.x(), normal.y(), normal.z());
            posMat.transform(vec.set(x2, y1, z));
            buffer.method_23919(vec.x(), vec.y(), vec.z(), color, 1.0f, 0.0f, class_4608.field_21444, 0xF000F0, normal.x(), normal.y(), normal.z());
            vertices.method_22993();
        }

        @Override
        public void method_48579(class_332 context, int mouseX, int mouseY, float tickDelta) {
            this.field_22762 = this.method_25405(mouseX, mouseY);
            TraitDiscovery discoveries = Pony.of((class_1657)class_310.method_1551().field_1724).getDiscoveries();
            boolean known = discoveries.isKnown(this.trait);
            this.setStyle(known ? this.revealedStyle : this.hiddenStyle);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            context.method_25290(SpellbookScreen.TEXTURE, this.method_46426() - 2, this.method_46427() - 8, 204.0f, 219.0f, 22, 32, 512, 256);
            if (!known) {
                context.method_25290(SpellbookScreen.TEXTURE, this.method_46426() - 2, this.method_46427() - 1, 74.0f, 223.0f, 18, 18, 512, 256);
            }
            if (discoveries.isUnread(this.trait)) {
                context.method_25290(SpellbookScreen.TEXTURE, this.method_46426() - 8, this.method_46427() - 8, 225.0f, 219.0f, 35, 32, 512, 256);
            }
            super.method_48579(context, mouseX, mouseY, tickDelta);
            this.field_22762 &= this.field_22763;
        }

        public Button setEnabled(boolean enable) {
            this.field_22765 = enable ? 1.0f : 0.1125f;
            return super.setEnabled(enable);
        }
    }
}

