/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook.element;

import com.google.common.base.Suppliers;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.IngredientWithSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.block.state.Schematic;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.element.DynamicContent;
import com.minelittlepony.unicopia.client.gui.spellbook.element.Image;
import com.minelittlepony.unicopia.client.gui.spellbook.element.Recipe;
import com.minelittlepony.unicopia.client.gui.spellbook.element.Stack;
import com.minelittlepony.unicopia.client.gui.spellbook.element.Structure;
import com.minelittlepony.unicopia.client.gui.spellbook.element.TextBlock;
import com.minelittlepony.unicopia.container.spellbook.Flow;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public interface PageElement
extends SpellbookChapterList.Drawable {
    @Override
    default public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
    }

    public Bounds bounds();

    default public Flow flow() {
        return Flow.NONE;
    }

    default public boolean isInline() {
        return this.flow() == Flow.NONE;
    }

    default public boolean isFloating() {
        return !this.isInline();
    }

    default public void compile(int y, IViewRoot Container2) {
    }

    public static PageElement read(DynamicContent.Page page, class_2540 buffer) {
        byte type = buffer.readByte();
        return switch (type) {
            case 0 -> new Image(buffer.method_10810(), PageElement.boundsFromBuffer(buffer), (Flow)buffer.method_10818(Flow.class));
            case 1 -> new Recipe(page, buffer.method_10810(), Bounds.empty());
            case 2 -> new Stack(page, (IngredientWithSpell)IngredientWithSpell.PACKET_CODEC.decode((Object)((class_9129)buffer)), PageElement.boundsFromBuffer(buffer));
            case 3 -> new TextBlock(page, List.of(Suppliers.ofInstance((Object)((class_2561)class_8824.field_49668.decode((Object)buffer)))));
            case 4 -> new TextBlock(page, buffer.method_34066(b -> {
                int count = b.method_10816();
                byte t = b.readByte();
                return switch (t) {
                    case 1 -> PageElement.formatLine(PageElement.capture(b.method_10810(), id -> ((class_1792)class_7923.field_41178.method_10223(id)).method_7854().method_7964()), "item", count);
                    case 2 -> PageElement.formatLine(Trait.of(b.method_19772()).get()::getShortName, "trait", count);
                    case 3 -> Suppliers.ofInstance((Object)((class_2561)class_8824.field_49668.decode(b)));
                    case 4 -> PageElement.formatLine(SpellType.getKey(b.method_10810())::getName, "spell", count);
                    default -> throw new IllegalArgumentException("Unexpected value: " + t);
                };
            }));
            case 5 -> new Structure(Bounds.empty(), Schematic.fromPacket(buffer));
            default -> throw new IllegalArgumentException("Unexpected value: " + type);
        };
    }

    private static <T, V> Supplier<V> capture(T t, Function<T, V> func) {
        return () -> func.apply(t);
    }

    private static Supplier<class_2561> formatLine(Supplier<class_2561> line, String kind, int count) {
        return () -> class_2561.method_43469((String)("gui.unicopia.spellbook.page.requirements.entry." + kind), (Object[])new Object[]{count, line.get()});
    }

    private static Bounds boundsFromBuffer(class_2540 buffer) {
        return new Bounds(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }
}

