/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.minelittlepony;

import com.minelittlepony.api.events.PonyModelPrepareCallback;
import com.minelittlepony.api.model.ModelAttributes;
import com.minelittlepony.api.model.PonyModel;
import com.minelittlepony.api.model.gear.Gear;
import com.minelittlepony.api.pony.DefaultPonySkinHelper;
import com.minelittlepony.api.pony.Pony;
import com.minelittlepony.api.pony.PonyData;
import com.minelittlepony.api.pony.PonyForm;
import com.minelittlepony.api.pony.PonyPosture;
import com.minelittlepony.client.render.MobRenderers;
import com.minelittlepony.client.render.entity.AquaticPlayerPonyRenderer;
import com.minelittlepony.client.render.entity.FormChangingPlayerPonyRenderer;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.minelittlepony.AmuletGear;
import com.minelittlepony.unicopia.client.minelittlepony.BangleGear;
import com.minelittlepony.unicopia.client.minelittlepony.BodyPartGear;
import com.minelittlepony.unicopia.client.minelittlepony.GlassesGear;
import com.minelittlepony.unicopia.client.minelittlepony.HeldEntityGear;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.minelittlepony.SpellEffectGear;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.util.AnimationUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7298;

public class Main
extends MineLPDelegate
implements ClientModInitializer {
    private static final Map<com.minelittlepony.api.pony.meta.Race, Race> PONY_RACE_MAPPING = new HashMap<com.minelittlepony.api.pony.meta.Race, Race>();
    private static final Function<com.minelittlepony.api.pony.meta.Race, Race> LOOKUP_CACHE = class_156.method_34866(race -> Optional.ofNullable(PONY_RACE_MAPPING.get(race)).or(() -> Race.REGISTRY.method_17966(Unicopia.id(race.name().toLowerCase(Locale.ROOT)))).orElse(Race.UNSET));
    private boolean hookErroring;

    public static void registerRaceMapping(com.minelittlepony.api.pony.meta.Race minelpRace, Race unicopiaRace) {
        PONY_RACE_MAPPING.put(minelpRace, unicopiaRace);
    }

    public void onInitializeClient() {
        INSTANCE = this;
        PonyForm.register((class_2960)Unicopia.id("seapony"), PonyPosture::hasSeaponyForm, (context, slimArms) -> new AquaticPlayerPonyRenderer(context, slimArms, DefaultPonySkinHelper.SEAPONY_SKIN_TYPE_ID, entity -> EquinePredicates.PLAYER_SEAPONY.test((class_1297)entity)));
        PonyForm.register((class_2960)Unicopia.id("nirik"), PonyPosture::hasNirikForm, (context, slimArms) -> new FormChangingPlayerPonyRenderer(context, slimArms, DefaultPonySkinHelper.NIRIK_SKIN_TYPE_ID, entity -> EquinePredicates.PLAYER_KIRIN.test((class_1297)entity) && EquinePredicates.RAGING.test((class_1297)entity)));
        PonyModelPrepareCallback.EVENT.register(this::onPonyModelPrepared);
        Gear.register(() -> new BangleGear(TrinketsDelegate.MAIN_GLOVE));
        Gear.register(() -> new BangleGear(TrinketsDelegate.SECONDARY_GLOVE));
        Gear.register(HeldEntityGear::new);
        Gear.register(BodyPartGear::pegasusWings);
        Gear.register(BodyPartGear::batWings);
        Gear.register(BodyPartGear::bugWings);
        Gear.register(BodyPartGear::unicornHorn);
        Gear.register(AmuletGear::new);
        Gear.register(GlassesGear::new);
        Gear.register(SpellEffectGear::new);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.CHANGEDLING, Race.CHANGELING);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.ZEBRA, Race.EARTH);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.GRYPHON, Race.PEGASUS);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.HIPPOGRIFF, Race.HIPPOGRIFF);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.BATPONY, Race.BAT);
        Main.registerRaceMapping(com.minelittlepony.api.pony.meta.Race.SEAPONY, Race.SEAPONY);
    }

    private void onPonyModelPrepared(class_1297 entity, PonyModel<?> model, ModelAttributes.Mode mode) {
        if (this.hookErroring) {
            return;
        }
        try {
            if (entity instanceof class_1657) {
                com.minelittlepony.unicopia.entity.player.Pony pony;
                Owned o;
                Object e;
                class_1657 player = (class_1657)entity;
                if (entity instanceof Owned && (e = (o = (Owned)entity).getMaster()) instanceof class_1657) {
                    class_1657 master;
                    player = master = (class_1657)e;
                }
                if ((pony = com.minelittlepony.unicopia.entity.player.Pony.of(player)).getMotion().isFlying()) {
                    model.getAttributes().wingAngle = class_3532.method_15363((float)(pony.getMotion().getWingAngle() / 3.0f - 1.2566371f), (float)-2.0f, (float)0.0f);
                    class_243 motion = pony.getMotion().getClientVelocity();
                    double zMotion = Math.sqrt(motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350);
                    model.getAttributes().isGoingFast = model.getAttributes().isGoingFast | zMotion > (double)0.4f;
                    model.getAttributes().isGoingFast |= pony.getMotion().isDiving();
                }
                model.getAttributes().isGoingFast |= pony.getMotion().isRainbooming();
                model.getAttributes().isGoingFast = model.getAttributes().isGoingFast & !pony.getEntityInArms().isPresent();
                if (pony.getAnimation().isOf(PlayerPoser.Animation.SPREAD_WINGS)) {
                    model.getAttributes().wingAngle = -AnimationUtil.seeSitSaw(pony.getAnimationProgress(1.0f), 1.5f) * (float)Math.PI / 1.2f;
                    model.getAttributes().isFlying = true;
                }
            }
        }
        catch (Throwable t) {
            Unicopia.LOGGER.error("Exception occured in MineLP hook:onPonyModelPrepared", t);
            this.hookErroring = true;
        }
    }

    @Override
    public int getMagicColor(class_1297 entity) {
        return Pony.getManager().getPony(entity).map(Pony::metadata).map(PonyData::glowColor).orElse(0);
    }

    @Override
    public Race getPlayerPonyRace(class_1657 player) {
        return Main.toUnicopiaRace(Pony.getManager().getPony(player).race());
    }

    @Override
    public Race getRace(class_1297 entity) {
        if (entity instanceof class_7298) {
            return MobRenderers.ALLAY.get() ? Race.PEGASUS : Race.HUMAN;
        }
        return Pony.getManager().getPony(entity).map(Pony::race).map(Main::toUnicopiaRace).orElse(Race.HUMAN);
    }

    @Override
    public float getPonyHeight(class_1297 entity) {
        return super.getPonyHeight(entity) * Pony.getManager().getPony(entity).map(pony -> Float.valueOf(pony.race().isHuman() ? 1.0f : pony.metadata().size().scaleFactor() + 0.1f)).orElse(Float.valueOf(1.0f)).floatValue();
    }

    private static Race toUnicopiaRace(com.minelittlepony.api.pony.meta.Race race) {
        return LOOKUP_CACHE.apply(race);
    }
}

