/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.common.util.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1088;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4668;

public final class RenderLayers
extends class_1921 {
    public static final int DEFAULT_MAGIC_COLOR = Color.argbToHex((float)0.6f, (float)0.8f, (float)0.9f, (float)1.0f);
    private static final List<class_1921> BLOCK_DESTRUCTION_STAGE_LAYERS = class_1088.field_21020.stream().map(texture -> {
        class_4668.class_4683 texture2 = new class_4668.class_4683(texture, false, false);
        return class_1921.method_24048((String)"alpha_crumbling", (class_293)class_290.field_1590, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_29426).method_34577((class_4668.class_5939)texture2).method_23616(field_21350).method_23603(field_21345).method_23604(field_21347).method_23615(field_21369).method_23617(false));
    }).toList();
    private static final class_1921 MAGIC_NO_COLOR = RenderLayers.method_24049((String)"magic_no_color", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21370).method_23610(field_25280).method_23617(false));
    private static final class_1921 MAGIC_SHIELD = RenderLayers.method_24049((String)"magic_shield", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21370).method_23610(field_25280).method_23603(field_21345).method_23616(field_21350).method_23617(false));
    private static final Function<Integer, class_1921> MAGIC_COLORIN_FUNC = class_156.method_34866(color -> RenderLayers.method_24049((String)("magic_colored_" + color), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(field_29442).method_23615(field_21370).method_23607(field_22241).method_23614(RenderLayers.solid(color)).method_23617(false)));
    private static final class_1921 MAGIC_COLORED = RenderLayers.getMagicColored(DEFAULT_MAGIC_COLOR);
    private static final BiFunction<class_2960, Integer, class_1921> MAGIC_TINT_FUNC = class_156.method_34865((texture, color) -> RenderLayers.method_24049((String)("magic_tint_" + color), (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new Colored((class_2960)texture, (int)color)).method_34578(field_29414).method_23616(field_21350).method_23615(field_21370).method_23607(field_22241).method_23603(field_21345).method_23617(false)));

    private RenderLayers() {
        super(null, null, null, 0, false, false, null, null);
    }

    public static class_1921 getCrumbling(int stage) {
        return BLOCK_DESTRUCTION_STAGE_LAYERS.get(stage);
    }

    public static class_1921 getMagicNoColor() {
        return MAGIC_NO_COLOR;
    }

    public static class_1921 getMagicShield() {
        return MAGIC_SHIELD;
    }

    public static class_1921 getMagicColored() {
        return MAGIC_COLORED;
    }

    public static class_1921 getMagicColored(int color) {
        return MAGIC_COLORIN_FUNC.apply(color);
    }

    public static class_1921 getMagicColored(class_2960 texture, int color) {
        return MAGIC_TINT_FUNC.apply(texture, color);
    }

    private static class_4668.class_4684 solid(int color) {
        float r = Color.r((int)color);
        float g = Color.g((int)color);
        float b = Color.b((int)color);
        float a = Color.a((int)color);
        return new class_4668.class_4684("solid", () -> RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a), () -> RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
    }

    private static class Colored
    extends class_4668.class_4683 {
        private final float red;
        private final float green;
        private final float blue;
        private final float alpha;

        public Colored(class_2960 texture, int color) {
            super(texture, false, false);
            this.red = Color.r((int)color);
            this.green = Color.g((int)color);
            this.blue = Color.b((int)color);
            this.alpha = Color.a((int)color);
        }

        public void method_23516() {
            RenderSystem.setShaderColor((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
            super.method_23516();
        }

        public void method_23518() {
            super.method_23518();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public boolean equals(Object other) {
            return super.equals(other) && ((Colored)((Object)other)).red == this.red && ((Colored)((Object)other)).green == this.green && ((Colored)((Object)other)).blue == this.blue && ((Colored)((Object)other)).alpha == this.alpha;
        }
    }
}

