/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.model;

import com.minelittlepony.unicopia.client.render.RenderUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class BakedModel {
    protected final List<RenderUtil.Vertex> vertices = new ObjectArrayList();
    private final Matrix4f textureMatrix = new Matrix4f();

    public Matrix4f getTextureMatrix() {
        return this.textureMatrix;
    }

    public void scaleUV(float uScale, float vScale) {
        this.getTextureMatrix().scale(uScale, vScale, 1.0f);
    }

    protected void addVertex(Vector4f vertex) {
        this.addVertex(vertex.x, vertex.y, vertex.z, (vertex.x + 1.0f) * 0.5f, (vertex.z + 1.0f) * 0.5f);
    }

    protected void addVertex(float x, float y, float z, float u, float v) {
        this.vertices.add(new RenderUtil.Vertex(x, y, z, u, v));
    }

    public final void render(class_4587 matrices, class_4588 buffer, int light, int overlay, float scale, int color) {
        if ((scale = Math.abs(scale)) < 0.001f) {
            return;
        }
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale);
        Matrix4f positionmatrix = matrices.method_23760().method_23761();
        for (RenderUtil.Vertex vertex : this.vertices) {
            Vector4f pos = vertex.position(positionmatrix);
            Vector4f tex = vertex.texture(this.textureMatrix);
            buffer.method_23919(pos.x, pos.y, pos.z, color, tex.x, tex.y, overlay, light, 0.0f, 0.0f, 0.0f);
        }
        matrices.method_22909();
        this.textureMatrix.identity();
    }

    public final void render(class_4587 matrices, class_4588 buffer, int light, float scale, int color) {
        if ((scale = Math.abs(scale)) < 0.001f) {
            return;
        }
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale);
        Matrix4f positionmatrix = matrices.method_23760().method_23761();
        for (RenderUtil.Vertex vertex : this.vertices) {
            Vector4f pos = vertex.position(positionmatrix);
            Vector4f tex = vertex.texture(this.textureMatrix);
            buffer.method_22912(pos.x, pos.y, pos.z).method_22913(tex.x, tex.y).method_39415(color).method_60803(this.getLightAt(pos, light));
        }
        matrices.method_22909();
        this.textureMatrix.identity();
    }

    protected int getLightAt(Vector4f pos, int light) {
        return light;
    }
}

