/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.shader;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonSyntaxException;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.IOException;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1657;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_280;
import net.minecraft.class_283;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4013;
import net.minecraft.class_5912;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ViewportShader
implements class_4013,
IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 ID = Unicopia.id("viewport_shader");
    public static final ViewportShader INSTANCE = new ViewportShader();
    public static final class_2960 CREEPER_SHADER = class_2960.method_60656((String)"shaders/post/creeper.json");
    public static final class_2960 DESATURATION_SHADER = Unicopia.id("shaders/post/desaturate.json");
    private final class_310 client = class_310.method_1551();
    @Nullable
    private LoadedShader shader;

    public class_2960 getFabricId() {
        return ID;
    }

    public void loadShader(@Nullable class_2960 shaderId) {
        if (this.shader != null) {
            try {
                this.shader.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.shader = null;
            }
        }
        if (shaderId == null || ((Boolean)Unicopia.getConfig().disableShaders.get()).booleanValue()) {
            return;
        }
        try {
            this.shader = new LoadedShader(this.client, shaderId);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load shader: {}", (Object)shaderId, (Object)e);
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Failed to parse shader: {}", (Object)shaderId, (Object)e);
        }
    }

    public void onResized(int width, int height) {
        if (this.shader != null) {
            this.shader.method_1259(width, height);
        }
    }

    public void render(class_9779 tickCounter) {
        Pony pony;
        float corruption;
        if (((Boolean)Unicopia.getConfig().disableShaders.get()).booleanValue()) {
            return;
        }
        if (this.shader != null && this.client.field_1724 != null && !class_3532.method_15347((float)(corruption = (pony = Pony.of((class_1657)this.client.field_1724)).getCorruption().getScaled(0.9f)), (float)0.0f)) {
            corruption = pony.getInterpolator().interpolate("corruption", corruption, 10.0f);
            corruption = 1.0f - corruption + 0.05f;
            this.shader.setUniformValue("color_convolve", "Saturation", corruption);
            this.shader.method_1258(tickCounter.method_60636());
        }
    }

    public void method_14491(class_3300 var1) {
        this.loadShader(this.shader != null ? this.shader.id : DESATURATION_SHADER);
    }

    static class LoadedShader
    extends class_279 {
        private final Object2FloatMap<String> uniformValues = new Object2FloatOpenHashMap();
        private Multimap<String, class_280> programs;
        private final class_2960 id;

        public LoadedShader(class_310 client, class_2960 id) throws IOException, JsonSyntaxException {
            super(client.method_1531(), (class_5912)client.method_1478(), client.method_1522(), id);
            this.id = id;
            this.method_1259(client.method_22683().method_4489(), client.method_22683().method_4506());
        }

        public class_283 method_1262(String programName, class_276 source, class_276 dest, boolean linear) throws IOException {
            class_283 pass = super.method_1262(programName, source, dest, linear);
            if (this.programs == null) {
                this.programs = LinkedListMultimap.create();
            }
            this.programs.put((Object)pass.method_1295().method_35763(), (Object)pass.method_1295());
            return pass;
        }

        public void setUniformValue(String programName, String uniformName, float value) {
            float currentValue;
            float f = currentValue = this.uniformValues.containsKey((Object)uniformName) ? 0.0f : this.uniformValues.getFloat((Object)uniformName);
            if (!class_3532.method_15347((float)value, (float)currentValue)) {
                this.uniformValues.put((Object)uniformName, value);
                this.programs.get((Object)programName).forEach(program -> {
                    class_284 uniform = program.method_1271(uniformName);
                    if (uniform != null) {
                        uniform.method_1251(value);
                    }
                });
            }
        }
    }
}

