/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.spell;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.entity.mob.CastSpellEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionf;

public class SpellRenderer<T extends Spell> {
    public static final SpellRenderer<?> DEFAULT = new SpellRenderer();
    protected final class_310 client = class_310.method_1551();

    public boolean shouldRenderEffectPass(int pass) {
        return true;
    }

    public void render(class_4587 matrices, class_4597 vertices, T spell, Caster<?> caster, int light, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (caster.asEntity() == this.client.field_1719 || caster.asEntity() instanceof MagicProjectileEntity) {
            return;
        }
        if (EquinePredicates.IS_CASTER.test((class_1297)this.client.field_1724)) {
            this.renderGemstone(matrices, vertices, spell, caster, light, tickDelta, animationProgress);
        }
    }

    private void renderGemstone(class_4587 matrices, class_4597 vertices, T spell, Caster<?> caster, int light, float tickDelta, float animationProgress) {
        matrices.method_22903();
        float scale = 0.125f;
        matrices.method_22905(scale, scale, scale);
        this.transformGemstone(matrices, vertices, spell, caster, animationProgress);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(animationProgress));
        this.client.method_1480().method_23178(spell.getTypeAndTraits().getDefaultStack(), class_811.field_4319, light, 0, matrices, vertices, caster.asWorld(), 0);
        matrices.method_22909();
        if (spell instanceof TimedSpell) {
            class_1309 l;
            TimedSpell timed = (TimedSpell)spell;
            Object e = caster.asEntity();
            if (e instanceof class_1309 && !(l = (class_1309)e).method_41328(class_4050.field_18078)) {
                class_1297 class_12972;
                float bodyYaw = class_3532.method_17821((float)tickDelta, (float)l.field_6220, (float)l.field_6283);
                float headYaw = class_3532.method_17821((float)tickDelta, (float)l.field_6259, (float)l.field_6241);
                float yawDifference = headYaw - bodyYaw;
                if (l.method_5765() && (class_12972 = l.method_5854()) instanceof class_1309) {
                    class_1309 vehicle = (class_1309)class_12972;
                    bodyYaw = class_3532.method_17821((float)tickDelta, (float)vehicle.field_6220, (float)vehicle.field_6283);
                    yawDifference = headYaw - bodyYaw;
                    float clampedYawDifference = class_3532.method_15363((float)class_3532.method_15393((float)yawDifference), (float)-85.0f, (float)85.0f);
                    bodyYaw = headYaw - clampedYawDifference;
                    if (clampedYawDifference * clampedYawDifference > 2500.0f) {
                        bodyYaw += clampedYawDifference * 0.2f;
                    }
                    yawDifference = headYaw - bodyYaw;
                }
                matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - bodyYaw));
            }
            this.renderCountdown(matrices, timed, tickDelta);
        }
        matrices.method_22909();
    }

    protected void renderCountdown(class_4587 matrices, TimedSpell spell, float tickDelta) {
        matrices.method_22907(this.client.method_1561().method_24197().invert(new Quaternionf()));
        float radius = 0.6f;
        float timeRemaining = spell.getTimer().getPercentTimeRemaining(tickDelta);
        DrawableUtil.drawArc(matrices, radius, radius + 0.3f, 0.0, Math.PI * 2 * (double)timeRemaining, class_5253.class_5254.method_48780((float)class_3532.method_15363((float)(timeRemaining * 4.0f), (float)0.0f, (float)1.0f), (int)-16776961, (int)-1));
    }

    protected void transformGemstone(class_4587 matrices, class_4597 vertices, T spell, Caster<?> caster, float animationProgress) {
        float y = -caster.asEntity().method_17682();
        if (caster.asEntity() instanceof CastSpellEntity) {
            y = 1.0f;
        }
        matrices.method_46416(0.0f, y * 8.0f + class_3532.method_15374((float)(animationProgress / 3.0f)) * 0.2f, 0.0f);
    }
}

