/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.compat.tla;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.state.Schematic;
import com.minelittlepony.unicopia.compat.tla.Main;
import com.minelittlepony.unicopia.compat.tla.RecipeCategory;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.recipe.TransformCropsRecipe;
import com.minelittlepony.unicopia.recipe.URecipes;
import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.SlotConfig;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaRecipe;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import org.joml.Quaternionfc;

public class StructureInteractionTlaRecipe
implements TlaRecipe {
    private final RecipeCategory category;
    private final class_2960 id;
    private final Schematic schematic;
    private final List<TlaIngredient> allInputs;
    private final List<TlaIngredient> inputs;
    private final List<TlaIngredient> catalysts;
    private final List<TlaStack> output;
    private final TextureConfig processIcon;
    private int age;

    static void generateFarmingRecipes(RecipeCategory category, PluginContext context) {
        context.addRecipeGenerator(URecipes.GROWING, recipe -> new StructureInteractionTlaRecipe(category, recipe.comp_1932(), new Schematic.Builder().fill(0, 0, 0, 6, 0, 6, ((TransformCropsRecipe)recipe.comp_1933()).getCatalystState()).set(3, 0, 3, class_2246.field_10362.method_9564()).set(3, 1, 3, ((TransformCropsRecipe)recipe.comp_1933()).getTargetState()).build(), List.of(TlaStack.of((class_1799)((TransformCropsRecipe)recipe.comp_1933()).getTarget()).asIngredient(), TlaStack.of((ItemVariant)ItemVariant.of((class_1799)((TransformCropsRecipe)recipe.comp_1933()).getCatalyst()), (long)48L).asIngredient()), (TlaStack)TlaStack.of((class_1799)((TransformCropsRecipe)recipe.comp_1933()).getOutput()), Unicopia.id("textures/gui/ability/grow.png")));
    }

    static void generateAltarRecipes(RecipeCategory category, PluginContext context) {
        context.addGenerator(client -> List.of(new StructureInteractionTlaRecipe(category, Unicopia.id("altar/spectral_clock"), Schematic.ALTAR, List.of(TlaStack.of((class_1935)class_1802.field_8557).asIngredient(), TlaStack.of((class_1935)UItems.SPELLBOOK).asIngredient(), TlaStack.of((class_1935)class_2246.field_10114).asIngredient(), TlaStack.of((class_1935)class_2246.field_23261).asIngredient(), TlaStack.of((class_1935)class_2246.field_10540, (long)40L).asIngredient()), (TlaStack)TlaStack.of((class_1935)UItems.SPECTRAL_CLOCK), Unicopia.id("textures/gui/race/alicorn.png")), new StructureInteractionTlaRecipe(category, Unicopia.id("altar/totem_of_dying"), Schematic.ALTAR, List.of(TlaStack.of((class_1935)class_1802.field_8288).asIngredient(), TlaStack.of((class_1935)UItems.SPELLBOOK).asIngredient(), TlaStack.of((class_1935)class_2246.field_10114).asIngredient(), TlaStack.of((class_1935)class_2246.field_23261).asIngredient(), TlaStack.of((class_1935)class_2246.field_10540, (long)40L).asIngredient()), (TlaStack)TlaStack.of((class_1935)UItems.TOTEM_OF_DYING), Unicopia.id("textures/gui/race/alicorn.png"))));
    }

    public StructureInteractionTlaRecipe(RecipeCategory category, class_2960 id, Schematic schematic, List<TlaIngredient> inputs, TlaStack output, class_2960 processIcon) {
        this.category = category;
        this.id = id;
        this.schematic = schematic;
        this.allInputs = inputs;
        this.inputs = inputs.stream().limit(1L).toList();
        this.catalysts = inputs.stream().skip(1L).toList();
        this.output = List.of(output);
        this.processIcon = TextureConfig.builder().texture(processIcon).size(13, 13).regionSize(16, 16).textureSize(16, 16).build();
    }

    public RecipeCategory getCategory() {
        return this.category;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<TlaIngredient> getInputs() {
        return this.inputs;
    }

    public List<TlaStack> getOutputs() {
        return this.output;
    }

    public List<TlaIngredient> getCatalysts() {
        return this.catalysts;
    }

    public void buildGui(GuiBuilder widgets) {
        int y = this.schematic.dy() * 8;
        int row = 0;
        this.age = 0;
        widgets.addCustomWidget(10, y / 2, 100, 100, this::renderSchematic);
        int x = 10;
        for (int i = 0; i < this.allInputs.size(); ++i) {
            if (i > 1) {
                x -= 40;
                row += 20;
            }
            if (i > 0) {
                widgets.addTexture(Main.PLUS, x + 3, y + 53 + row);
                x += 20;
            }
            SlotConfig slot = widgets.addSlot(this.allInputs.get(i), x, y + 50 + row);
            if (i > 0) {
                slot.markCatalyst();
            }
            x += 20;
        }
        widgets.addArrow(73, y + 52, false);
        widgets.addSlot(this.output.get(0), 100, y + 47).makeLarge().markOutput();
        widgets.addTexture(this.processIcon, 73, y + 45).addTooltip(List.of(class_2561.method_43471((String)(class_156.method_646((String)"recipe", (class_2960)this.category.getId()) + ".instruction"))));
    }

    private void renderSchematic(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.schematic.volume() == 0) {
            return;
        }
        class_4587 matrices = context.method_51448();
        class_4597.class_4598 immediate = context.method_51450();
        class_310 client = class_310.method_1551();
        matrices.method_22903();
        float minSize = (Math.max(this.schematic.dz(), Math.max(this.schematic.dx(), this.schematic.dy())) + 1) * 16;
        float scale = 60.0f / minSize;
        matrices.method_22905(scale, scale, 1.0f);
        matrices.method_46416(95.0f, 40.0f, 100.0f);
        matrices.method_22905(16.0f, -16.0f, 16.0f);
        matrices.method_23760().method_23762().scale(1.0f, -1.0f, 1.0f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(20.0f));
        matrices.method_23760().method_23761().rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(40.0f));
        matrices.method_46416((float)(-this.schematic.dx() - 1) / 2.0f, (float)(-this.schematic.dy() - 1) / 2.0f, (float)(-this.schematic.dz() - 1) / 2.0f);
        class_308.method_24210();
        ++this.age;
        for (Schematic.Entry entry : this.schematic.states()) {
            int z;
            int x = entry.x() - this.schematic.dx() / 2;
            int distance = x * x + (z = entry.z() - this.schematic.dz() / 2) * z;
            if (this.age < distance * 2) continue;
            matrices.method_22903();
            matrices.method_46416((float)entry.x(), (float)entry.y(), (float)entry.z());
            client.method_1541().method_3353(entry.state(), matrices, (class_4597)immediate, 0xF000F0, class_4608.field_21444);
            matrices.method_22909();
        }
        matrices.method_22909();
    }
}

