/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.container.spellbook;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.IngredientWithSpell;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.block.state.StateUtil;
import com.minelittlepony.unicopia.container.spellbook.Flow;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8824;
import net.minecraft.class_9129;

public interface ChapterPageElement {
    public static final byte IMAGE = 0;
    public static final byte RECIPE = 1;
    public static final byte STACK = 2;
    public static final byte TEXT_BLOCK = 3;
    public static final byte INGREDIENTS = 4;
    public static final byte STRUCTURE = 5;
    public static final Codec<ChapterPageElement> CODEC = class_5699.field_40721.xmap(json -> {
        if (!json.isJsonPrimitive()) {
            JsonObject el = class_3518.method_15295((JsonElement)json, (String)"element");
            if (el.has("texture")) {
                return new Image(el);
            }
            if (el.has("recipe")) {
                return new Recipe(el);
            }
            if (el.has("item")) {
                return new Stack(el);
            }
            if (el.has("ingredients")) {
                return new Ingredients(el);
            }
            if (el.has("structure")) {
                return new Structure(el);
            }
        }
        return new TextBlock((JsonElement)json);
    }, page -> {
        throw new RuntimeException();
    });

    public static void write(class_2540 buffer, ChapterPageElement element) {
        element.toBuffer((class_9129)buffer);
    }

    private static Bounds boundsFromJson(JsonObject el) {
        return new Bounds(class_3518.method_15282((JsonObject)el, (String)"y", (int)0), class_3518.method_15282((JsonObject)el, (String)"x", (int)0), class_3518.method_15282((JsonObject)el, (String)"width", (int)0), class_3518.method_15282((JsonObject)el, (String)"height", (int)0));
    }

    private static void boundsToBuffer(Bounds bounds, class_2540 buffer) {
        buffer.method_53002(bounds.top);
        buffer.method_53002(bounds.left);
        buffer.method_53002(bounds.width);
        buffer.method_53002(bounds.height);
    }

    public void toBuffer(class_9129 var1);

    public record Image(class_2960 texture, Bounds bounds, Flow flow) implements ChapterPageElement
    {
        public Image(JsonObject json) {
            this(class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"texture")), ChapterPageElement.boundsFromJson(json), Flow.valueOf(class_3518.method_15253((JsonObject)json, (String)"flow", (String)"RIGHT")));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(0);
            buffer.method_10812(this.texture);
            ChapterPageElement.boundsToBuffer(this.bounds, (class_2540)buffer);
            buffer.method_10817((Enum)this.flow);
        }
    }

    public record Recipe(class_2960 value) implements ChapterPageElement
    {
        public Recipe(JsonObject json) {
            this(class_2960.method_60654((String)class_3518.method_15265((JsonObject)json, (String)"recipe")));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(1);
            buffer.method_10812(this.value);
        }
    }

    public record Stack(IngredientWithSpell ingredient, Bounds bounds) implements ChapterPageElement
    {
        public Stack(JsonObject json) {
            this((IngredientWithSpell)((Pair)IngredientWithSpell.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json.get("item")).result().get()).getFirst(), ChapterPageElement.boundsFromJson(json));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(2);
            IngredientWithSpell.PACKET_CODEC.encode((Object)buffer, (Object)this.ingredient);
            ChapterPageElement.boundsToBuffer(this.bounds, (class_2540)buffer);
        }
    }

    public record Ingredients(List<ChapterPageElement> entries) implements ChapterPageElement
    {
        public Ingredients(JsonObject json) {
            this(class_3518.method_15261((JsonObject)json, (String)"ingredients").asList().stream().map(JsonElement::getAsJsonObject).map(Ingredients::loadIngredient).toList());
        }

        @Deprecated
        static ChapterPageElement loadIngredient(JsonObject json) {
            int count = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
            if (json.has("item")) {
                return new Multi(count, new Id(1, class_2960.method_12829((String)json.get("item").getAsString())));
            }
            if (json.has("trait")) {
                return new Multi(count, new Id(2, Trait.of(json.get("trait").getAsString()).orElseThrow().getId()));
            }
            if (json.has("spell")) {
                return new Multi(count, new Id(4, class_2960.method_12829((String)json.get("spell").getAsString())));
            }
            return new Multi(count, new TextBlock(json.get("text")));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(4);
            buffer.method_34062(this.entries, (b, c) -> c.toBuffer(buffer));
        }

        record Multi(int count, ChapterPageElement element) implements ChapterPageElement
        {
            @Override
            public void toBuffer(class_9129 buffer) {
                buffer.method_10804(this.count);
                this.element.toBuffer(buffer);
            }
        }

        record Id(byte id, class_2960 value) implements ChapterPageElement
        {
            @Override
            public void toBuffer(class_9129 buffer) {
                buffer.method_52997((int)this.id);
                buffer.method_10812(this.value);
            }
        }
    }

    public record Structure(List<ChapterPageElement> commands) implements ChapterPageElement
    {
        public Structure(JsonObject json) {
            this(class_3518.method_15261((JsonObject)json, (String)"structure").asList().stream().map(JsonElement::getAsJsonObject).map(Structure::loadCommand).toList());
        }

        static ChapterPageElement loadCommand(JsonObject json) {
            if (json.has("pos")) {
                JsonArray pos = class_3518.method_15261((JsonObject)json, (String)"pos");
                return new Set(pos.get(0).getAsInt(), pos.get(1).getAsInt(), pos.get(2).getAsInt(), StateUtil.stateFromString(json.get("state").getAsString()));
            }
            JsonArray min = class_3518.method_15261((JsonObject)json, (String)"min");
            JsonArray max = class_3518.method_15261((JsonObject)json, (String)"max");
            return new Fill(min.get(0).getAsInt(), min.get(1).getAsInt(), min.get(2).getAsInt(), max.get(0).getAsInt(), max.get(1).getAsInt(), max.get(2).getAsInt(), StateUtil.stateFromString(json.get("state").getAsString()));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(5);
            buffer.method_34062(this.commands, (b, c) -> c.toBuffer(buffer));
        }

        record Set(int x, int y, int z, class_2680 state) implements ChapterPageElement
        {
            @Override
            public void toBuffer(class_9129 buffer) {
                buffer.method_52997(1);
                buffer.method_53002(this.x);
                buffer.method_53002(this.y);
                buffer.method_53002(this.z);
                buffer.method_53002(class_2248.method_9507((class_2680)this.state));
            }
        }

        record Fill(int x1, int y1, int z1, int x2, int y2, int z2, class_2680 state) implements ChapterPageElement
        {
            @Override
            public void toBuffer(class_9129 buffer) {
                buffer.method_52997(2);
                buffer.method_53002(this.x1);
                buffer.method_53002(this.y1);
                buffer.method_53002(this.z1);
                buffer.method_53002(this.x2);
                buffer.method_53002(this.y2);
                buffer.method_53002(this.z2);
                buffer.method_53002(class_2248.method_9507((class_2680)this.state));
            }
        }
    }

    public record TextBlock(class_2561 text) implements ChapterPageElement
    {
        public TextBlock(JsonElement json) {
            this((class_2561)(json.isJsonPrimitive() ? class_2561.method_43471((String)json.getAsString()) : class_2561.class_2562.method_10872((JsonElement)json, (class_7225.class_7874)class_5455.field_40585)));
        }

        @Override
        public void toBuffer(class_9129 buffer) {
            buffer.method_52997(3);
            class_8824.field_49668.encode((Object)buffer, (Object)this.text);
        }
    }
}

