/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datafix;

import com.mojang.serialization.Dynamic;
import java.util.Set;
import net.minecraft.class_9267;

final class UnicopiaItemStackComponentizations {
    private static final Set<String> ENCHANTED_ITEMS = Set.of("unicopia:gemstone", "unicopia:magic_staff");

    UnicopiaItemStackComponentizations() {
    }

    static void run(class_9267.class_9268 data, Dynamic<?> dynamic) {
        if (data.method_57270("unicopia:friendship_bracelet")) {
            data.method_57266("glowing", "unicopia:glowing");
            data.method_57262("issuer_id").result().ifPresent(id -> data.method_57263("unicopia:issuer", dynamic.emptyMap().set("id", id).setFieldIfPresent("name", data.method_57262("issuer").result())));
        }
        if (data.method_57270("unicopia:grogars_bell")) {
            UnicopiaItemStackComponentizations.fixEnergy(data, dynamic, 1000, 1000);
        }
        if (data.method_57270("unicopia:magic_staff")) {
            UnicopiaItemStackComponentizations.fixEnergy(data, dynamic, 3, 3);
        }
        if (data.method_57270("unicopia:pegasus_amulet")) {
            UnicopiaItemStackComponentizations.fixEnergy(data, dynamic, 900, 450);
        }
        if (data.method_57270("unicopia:zap_apple")) {
            UnicopiaItemStackComponentizations.fixAppearance(data, dynamic, true);
        }
        if (data.method_57270("unicopia:filled_jar")) {
            UnicopiaItemStackComponentizations.fixAppearance(data, dynamic, false);
        }
        if (data.method_57269(ENCHANTED_ITEMS)) {
            data.method_57266("spell", "unicopia:stored_spell");
            data.method_57266("spell_traits", "unicopia:spell_traits");
        }
        if (data.method_57270("unicopia:butterfly")) {
            data.method_57262("variant").result().ifPresent(variant -> data.method_57263("unicopia:butterfly_variant", dynamic.emptyMap().set("variant", variant).set("show_in_tooltip", dynamic.createBoolean(true))));
        }
        if (data.method_57270("unicopia:giant_balloon")) {
            data.method_57266("design", "unicopia:balloon_design");
        }
        if (data.method_57270("unicopia:spellbook")) {
            data.method_57266("spellbookState", "unicopia:spellbook_state");
        }
    }

    private static void fixAppearance(class_9267.class_9268 data, Dynamic<?> dynamic, boolean replaceFully) {
        data.method_57262("appearance").result().ifPresent(appearance -> data.method_57263("unicopia:appearance", dynamic.emptyMap().set("item", appearance).set("replace_fully", dynamic.createBoolean(replaceFully))));
    }

    private static void fixEnergy(class_9267.class_9268 data, Dynamic<?> dynamic, int maximum, int baseline) {
        data.method_57262("energy").result().ifPresent(energy -> data.method_57263("unicopia:charges", dynamic.emptyMap().set("energy", dynamic.createInt(energy.get("energy").asInt(energy.asInt(baseline)))).set("maximum", dynamic.createInt(maximum)).set("baseline", dynamic.createInt(baseline)).set("show_in_tooltip", dynamic.createBoolean(true))));
    }
}

