/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.datagen.DataCollector;
import com.minelittlepony.unicopia.datagen.providers.DietProfileGenerator;
import com.minelittlepony.unicopia.datagen.providers.FoodGroupsGenerator;
import com.minelittlepony.unicopia.diet.DietProfile;
import com.minelittlepony.unicopia.diet.FoodGroup;
import com.minelittlepony.unicopia.diet.FoodGroupEffects;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2474;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public class DietsProvider
implements class_2405 {
    private final DataCollector dietsCollector;
    private final DataCollector categoriesCollector;
    private final CompletableFuture<class_2474.class_8211<class_1792>> itemTagLookup;

    public DietsProvider(FabricDataOutput output, class_2474<class_1792> tagProvider) {
        this.dietsCollector = new DataCollector(output.method_45973(class_7784.class_7490.field_39367, "diet/races"));
        this.categoriesCollector = new DataCollector(output.method_45973(class_7784.class_7490.field_39367, "diet/food_groups"));
        this.itemTagLookup = tagProvider.method_49662();
    }

    public String method_10321() {
        return "Diets";
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.itemTagLookup.thenCompose(tagLookup -> {
            BiConsumer<class_2960, Supplier<JsonElement>> diets = this.categoriesCollector.prime();
            HashMap<class_2960, Set> keyToGroupId = new HashMap<class_2960, Set>();
            new FoodGroupsGenerator().generate((id, builder) -> {
                FoodGroupEffects attributes = builder.build();
                attributes.tags().forEach(key -> {
                    if (!tagLookup.contains(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)key.id()))) {
                        throw new IllegalArgumentException("Food group " + String.valueOf(id) + " references unknown item tag " + String.valueOf(key.id()));
                    }
                    keyToGroupId.computeIfAbsent(key.id(), i -> new HashSet()).add(id);
                });
                diets.accept((class_2960)id, () -> (JsonElement)FoodGroup.EFFECTS_CODEC.encode((Object)attributes, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().get());
            });
            BiConsumer<class_2960, Supplier<JsonElement>> profiles = this.dietsCollector.prime();
            new DietProfileGenerator().generate((race, profile) -> {
                class_2960 id = Race.REGISTRY.method_10221(race);
                StringBuilder issues = new StringBuilder();
                profile.validate(issue -> issues.append(System.lineSeparator()).append((String)issue), this.categoriesCollector::isDefined);
                if (!issues.isEmpty()) {
                    throw new IllegalArgumentException("Diet profile " + String.valueOf(id) + " failed validation: " + issues.toString());
                }
                profiles.accept(id, () -> (JsonElement)DietProfile.CODEC.encode(profile, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).result().get());
            });
            keyToGroupId.forEach((tag, groups) -> {
                if (groups.size() > 1) {
                    throw new IllegalArgumentException("Multiple groups referenced the same tag " + String.valueOf(tag) + " held by " + groups.stream().map(class_2960::toString).collect(Collectors.joining()));
                }
            });
            return CompletableFuture.allOf(this.categoriesCollector.upload(writer), this.dietsCollector.upload(writer));
        });
    }
}

