/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers;

import com.google.gson.JsonElement;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.block.FruitBearingBlock;
import com.minelittlepony.unicopia.block.PieBlock;
import com.minelittlepony.unicopia.block.PileBlock;
import com.minelittlepony.unicopia.block.ShellsBlock;
import com.minelittlepony.unicopia.block.SlimePustuleBlock;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.block.zap.ZapAppleLeavesBlock;
import com.minelittlepony.unicopia.datagen.UBlockFamilies;
import com.minelittlepony.unicopia.datagen.providers.BlockModels;
import com.minelittlepony.unicopia.datagen.providers.BlockRotation;
import com.minelittlepony.unicopia.datagen.providers.FireModels;
import com.minelittlepony.unicopia.datagen.providers.ItemModels;
import com.minelittlepony.unicopia.datagen.providers.UModelProvider;
import com.minelittlepony.unicopia.server.world.Tree;
import com.minelittlepony.unicopia.server.world.ZapAppleStageStore;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2429;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7923;

public class UBlockStateModelGenerator
extends class_4910 {
    static final class_2960 AIR_BLOCK_ID = class_2960.method_60656((String)"block/air");
    static final class_2960 AIR_ITEM_ID = class_2960.method_60656((String)"item/air");

    static UBlockStateModelGenerator create(class_4910 modelGenerator) {
        return new UBlockStateModelGenerator(modelGenerator.field_22830, modelGenerator.field_22831, arg_0 -> ((class_4910)modelGenerator).method_25540(arg_0));
    }

    protected UBlockStateModelGenerator(class_4910 modelGenerator) {
        this(modelGenerator.field_22830, modelGenerator.field_22831, arg_0 -> ((class_4910)modelGenerator).method_25540(arg_0));
    }

    public UBlockStateModelGenerator(Consumer<class_4917> blockStateCollector, BiConsumer<class_2960, Supplier<JsonElement>> modelCollector, Consumer<class_2248> simpleItemModelExemptionCollector) {
        super(blockStateCollector, (id, jsonSupplier) -> {
            if (AIR_BLOCK_ID.equals(id) || AIR_ITEM_ID.equals(id)) {
                throw new IllegalStateException("Registered air id for block model: " + ((JsonElement)jsonSupplier.get()).toString());
            }
            modelCollector.accept((class_2960)id, (Supplier<JsonElement>)jsonSupplier);
        }, item -> simpleItemModelExemptionCollector.accept(class_2248.method_9503((class_1792)item)));
    }

    public void method_25534() {
        for (int i = 0; i < class_4943.field_22958.length; ++i) {
            class_4943.field_22958[i].method_25852(Unicopia.id("block/apple_sprout_stage" + i), class_4944.method_25888((class_2248)class_2246.field_46287), this.field_22831);
        }
        this.registerAll((g, block) -> g.method_25623((class_2248)block, class_4941.method_25842((class_2248)block)), UBlocks.SHAPING_BENCH, UBlocks.SURFACE_CHITIN);
        this.registerAll(class_4910::method_25681, UBlocks.SHAPING_BENCH, UBlocks.BANANAS);
        this.registerAll(UBlockStateModelGenerator::registerStableDoor, UBlocks.STABLE_DOOR, UBlocks.DARK_OAK_DOOR, UBlocks.CLOUD_DOOR);
        this.registerLockingDoor(UBlocks.CRYSTAL_DOOR);
        this.createCustomTexturePool(UBlocks.CLOUD, class_4946.field_23036).method_54827(UBlocks.CLOUD, UBlocks.UNSTABLE_CLOUD).method_25724(UBlocks.CLOUD_SLAB).method_25725((class_2248)UBlocks.CLOUD_STAIRS);
        this.createCustomTexturePool(UBlocks.ETCHED_CLOUD, class_4946.field_23036).method_25724(UBlocks.ETCHED_CLOUD_SLAB).method_25725(UBlocks.ETCHED_CLOUD_STAIRS);
        this.createCustomTexturePool(UBlocks.DENSE_CLOUD, class_4946.field_23036).method_25724(UBlocks.DENSE_CLOUD_SLAB).method_25725(UBlocks.DENSE_CLOUD_STAIRS);
        this.createCustomTexturePool(UBlocks.CLOUD_PLANKS, class_4946.field_23036).method_25724(UBlocks.CLOUD_PLANK_SLAB).method_25725(UBlocks.CLOUD_PLANK_STAIRS);
        this.createCustomTexturePool(UBlocks.CLOUD_BRICKS, class_4946.field_23036).method_25724(UBlocks.CLOUD_BRICK_SLAB).method_25725(UBlocks.CLOUD_BRICK_STAIRS);
        this.createTwoStepTexturePool(UBlocks.SOGGY_CLOUD, class_4946.field_23040.method_35912(textures -> textures.method_25868(class_4945.field_23014, class_4941.method_25842((class_2248)UBlocks.CLOUD)))).method_25724((class_2248)UBlocks.SOGGY_CLOUD_SLAB).method_25725((class_2248)UBlocks.SOGGY_CLOUD_STAIRS);
        this.registerRotated(UBlocks.CARVED_CLOUD, class_4946.field_23038);
        this.registerPillar(UBlocks.CLOUD_PILLAR);
        this.registerAll(UBlockStateModelGenerator::registerCompactedBlock, UBlocks.COMPACTED_CLOUD, UBlocks.COMPACTED_CLOUD_BRICKS, UBlocks.COMPACTED_CLOUD_PLANKS, UBlocks.COMPACTED_DENSE_CLOUD, UBlocks.COMPACTED_ETCHED_CLOUD);
        this.registerChest(UBlocks.CLOUD_CHEST, UBlocks.CLOUD);
        this.registerFancyBed(UBlocks.CLOUD_BED, UBlocks.CLOUD);
        this.registerFancyBed(UBlocks.CLOTH_BED, class_2246.field_9975);
        this.registerTopsoil(UBlocks.SURFACE_CHITIN, UBlocks.CHITIN);
        this.registerHollow(UBlocks.CHITIN);
        this.method_25650(UBlocks.CHISELLED_CHITIN).method_33522(UBlockFamilies.CHISELED_CHITIN);
        this.method_25650(UBlocks.POLISHED_CHITIN).method_33522(UBlockFamilies.POLISHED_CHITIN);
        this.registerHiveBlock(UBlocks.HIVE);
        this.registerRotated(UBlocks.CHITIN_SPIKES, BlockModels.SPIKES);
        this.registerHull(UBlocks.CHISELLED_CHITIN_HULL, UBlocks.CHITIN, UBlocks.CHISELLED_CHITIN);
        this.registerHull(UBlocks.POLISHED_CHITIN_HULL, UBlocks.CHITIN, UBlocks.POLISHED_CHITIN);
        this.method_25537(UBlocks.SLIME_PUSTULE.method_8389());
        this.registerSlimeLayers(UBlocks.SLIME);
        this.field_22830.accept(class_4925.method_25769((class_2248)UBlocks.SLIME_PUSTULE).method_25775(class_4926.method_25783(SlimePustuleBlock.SHAPE).method_25795(state -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)UBlocks.SLIME_PUSTULE, (String)("_" + state.method_15434()))))));
        this.registerPie(UBlocks.APPLE_PIE);
        this.method_25676(UBlocks.PALM_LOG).method_25730(UBlocks.PALM_LOG).method_25728(UBlocks.PALM_WOOD);
        this.method_25676(UBlocks.STRIPPED_PALM_LOG).method_25730(UBlocks.STRIPPED_PALM_LOG).method_25728(UBlocks.STRIPPED_PALM_WOOD);
        this.method_25650(UBlocks.PALM_PLANKS).method_33522(UBlockFamilies.PALM);
        this.method_46190(UBlocks.STRIPPED_PALM_LOG, UBlocks.PALM_HANGING_SIGN, UBlocks.PALM_WALL_HANGING_SIGN);
        this.method_25622(UBlocks.PALM_LEAVES, class_4946.field_23049);
        this.method_25676(UBlocks.ZAP_LOG).method_25730(UBlocks.ZAP_LOG).method_25728(UBlocks.ZAP_WOOD).method_25730(UBlocks.WAXED_ZAP_LOG).method_25728(UBlocks.WAXED_ZAP_WOOD);
        this.method_25676(UBlocks.STRIPPED_ZAP_LOG).method_25730(UBlocks.STRIPPED_ZAP_LOG).method_25728(UBlocks.STRIPPED_ZAP_WOOD).method_25730(UBlocks.WAXED_STRIPPED_ZAP_LOG).method_25728(UBlocks.WAXED_STRIPPED_ZAP_WOOD);
        this.method_25650(UBlocks.ZAP_PLANKS).method_33522(UBlockFamilies.ZAP).method_54827(UBlocks.ZAP_PLANKS, UBlocks.WAXED_ZAP_PLANKS).method_33522(UBlockFamilies.WAXED_ZAP);
        this.registerZapLeaves(UBlocks.ZAP_LEAVES);
        this.method_25622(UBlocks.FLOWERING_ZAP_LEAVES, class_4946.field_23049);
        this.method_25543(UBlocks.ZAP_LEAVES_PLACEHOLDER, class_2246.field_10124);
        this.method_25641(UBlocks.GOLDEN_OAK_LEAVES);
        this.method_25676((class_2248)UBlocks.GOLDEN_OAK_LOG).method_25730((class_2248)UBlocks.GOLDEN_OAK_LOG).method_25728((class_2248)UBlocks.GOLDEN_OAK_WOOD);
        this.method_25676((class_2248)UBlocks.STRIPPED_GOLDEN_OAK_LOG).method_25730((class_2248)UBlocks.STRIPPED_GOLDEN_OAK_LOG).method_25728((class_2248)UBlocks.STRIPPED_GOLDEN_OAK_WOOD);
        this.method_25650(UBlocks.GOLDEN_OAK_PLANKS).method_33522(UBlockFamilies.GOLDEN_OAK);
        Tree.REGISTRY.stream().filter(tree -> tree.sapling().isPresent()).forEach(tree -> this.method_25545(tree.sapling().get(), tree.pot().get(), class_4910.class_4913.field_22840));
        this.method_25548((class_2248)UBlocks.CURING_JOKE, class_4910.class_4913.field_22840);
        this.registerWithStages(UBlocks.GOLD_ROOT, (class_2769<Integer>)class_2741.field_12550, BlockModels.CROP, 0, 0, 1, 1, 2, 2, 2, 3);
        this.registerTallCrop((class_2248)UBlocks.PINEAPPLE, (class_2769<Integer>)class_2741.field_12550, class_2741.field_12518, {0, 1, 2, 3, 4, 5, 5, 6}, {0, 0, 1, 2, 3, 4, 5, 6});
        this.registerPlunderVine(UBlocks.PLUNDER_VINE, UBlocks.PLUNDER_VINE_BUD);
        this.registerAll(UBlockStateModelGenerator::registerFloweringLeaves, UBlocks.GREEN_APPLE_LEAVES, UBlocks.SOUR_APPLE_LEAVES, UBlocks.SWEET_APPLE_LEAVES);
        this.registerAll(UBlockStateModelGenerator::registerSprout, UBlocks.GREEN_APPLE_SPROUT, UBlocks.SOUR_APPLE_SPROUT, UBlocks.SWEET_APPLE_SPROUT, UBlocks.GOLDEN_OAK_SPROUT);
        this.method_25543(UBlocks.MANGO_LEAVES, class_2246.field_10335);
        this.method_25623(UBlocks.MANGO_LEAVES, class_4941.method_25842((class_2248)class_2246.field_10335));
        UModelProvider.FRUITS.forEach((block, item) -> this.method_35868((class_2248)block, class_4944.method_25880((class_2960)class_4941.method_25840((class_1792)item)), BlockModels.FRUIT));
        this.registerAll(UBlockStateModelGenerator::registerShell, UBlocks.CLAM_SHELL, UBlocks.TURRET_SHELL, UBlocks.SCALLOP_SHELL);
        this.method_25641(UBlocks.WORM_BLOCK);
        this.method_25542(UBlocks.WEATHER_VANE, UBlocks.WEATHER_VANE.method_8389());
        this.registerWithStages(UBlocks.FROSTED_OBSIDIAN, (class_2769<Integer>)class_2741.field_12497, BlockModels.CUBE_ALL, 0, 1, 2, 3);
        this.registerWithStagesBuiltinModels(UBlocks.ROCKS, (class_2769<Integer>)class_2741.field_12550, 0, 1, 2, 3, 4, 5, 6, 7);
        this.registerWithStagesBuiltinModels(UBlocks.MYSTERIOUS_EGG, (class_2769<Integer>)PileBlock.COUNT, 1, 2, 3);
        this.method_25537(UBlocks.MYSTERIOUS_EGG.method_8389());
        FireModels.registerSoulFire(this, UBlocks.SPECTRAL_FIRE, class_2246.field_22089);
        this.field_22830.accept(UBlockStateModelGenerator.method_25644((class_2248)UBlocks.JAR, (class_2960)BlockModels.TEMPLATE_JAR));
        this.registerWeatherJar(UBlocks.CLOUD_JAR);
        this.registerWeatherJar(UBlocks.STORM_JAR);
        this.registerWeatherJar(UBlocks.ZAP_JAR);
        this.registerWeatherJar(UBlocks.LIGHTNING_JAR);
    }

    public void registerWeatherJar(class_2248 jar) {
        this.field_22830.accept(class_4922.method_25758((class_2248)jar).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)BlockModels.TEMPLATE_JAR)).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)jar, (String)"_filling"))));
    }

    @SafeVarargs
    public final <T> UBlockStateModelGenerator registerAll(BiConsumer<? super UBlockStateModelGenerator, T> register, T ... blocks) {
        for (T block : blocks) {
            register.accept((UBlockStateModelGenerator)((UBlockStateModelGenerator)this), (UBlockStateModelGenerator)((Object)block));
        }
        return this;
    }

    public void method_25623(class_2248 block, class_2960 parentModelId) {
        class_1792 item = block.method_8389();
        if (item != class_1802.field_8162) {
            this.method_25538(item, parentModelId);
        }
    }

    public class_4910.class_4912 createCustomTexturePool(class_2248 block, class_4946.class_4947 modelFactory) {
        class_4946 texturedModel = modelFactory.get(block);
        final class_4944 textures = texturedModel.method_25921();
        return new class_4910.class_4912(textures){

            public class_4910.class_4912 method_25725(class_2248 block) {
                class_4944 textMap = textures.method_25879(BlockModels.STEP, textures.method_25867(class_4945.field_23018));
                class_2960 inner = BlockModels.INNER_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                class_2960 straight = BlockModels.STRAIGHT_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                class_2960 outer = BlockModels.OUTER_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                UBlockStateModelGenerator.this.field_22830.accept(class_4910.method_25646((class_2248)block, (class_2960)inner, (class_2960)straight, (class_2960)outer));
                UBlockStateModelGenerator.this.method_25623(block, straight);
                return this;
            }
        }.method_25718(block, texturedModel.method_25914());
    }

    public class_4910.class_4912 createTwoStepTexturePool(class_2248 block, class_4946.class_4947 modelFactory) {
        class_4946 texturedModel = modelFactory.get(block);
        final class_4944 textures = texturedModel.method_25921();
        final class_2960 baseModelId = class_4941.method_25842((class_2248)block);
        final class_2960 twoStepTexture = class_4941.method_25843((class_2248)block, (String)"_slab_side");
        return new class_4910.class_4912(textures){

            public class_4910.class_4912 method_25725(class_2248 block) {
                class_4944 textMap = textures.method_25879(BlockModels.STEP, twoStepTexture);
                class_2960 inner = BlockModels.INNER_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                class_2960 straight = BlockModels.STRAIGHT_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                class_2960 outer = BlockModels.OUTER_STAIRS.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                UBlockStateModelGenerator.this.field_22830.accept(class_4910.method_25646((class_2248)block, (class_2960)inner, (class_2960)straight, (class_2960)outer));
                UBlockStateModelGenerator.this.method_25623(block, straight);
                return this;
            }

            public class_4910.class_4912 method_25724(class_2248 block) {
                class_4944 textMap = textures.method_25879(class_4945.field_23018, twoStepTexture);
                class_2960 lower = class_4943.field_22909.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                class_2960 upper = class_4943.field_22910.method_25846(block, textMap, UBlockStateModelGenerator.this.field_22831);
                UBlockStateModelGenerator.this.field_22830.accept(class_4910.method_25668((class_2248)block, (class_2960)lower, (class_2960)upper, (class_2960)baseModelId));
                UBlockStateModelGenerator.this.method_25623(block, lower);
                return this;
            }
        }.method_25718(block, texturedModel.method_25914());
    }

    public void registerTopsoil(class_2248 block, class_2248 dirt) {
        class_4946 model = class_4946.field_23040.get(dirt);
        this.method_25560(block, model.method_25916(block, this.field_22831), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4943.field_22977.method_25847(dirt, "_snow", model.method_25921().method_25879(class_4945.field_23018, class_4941.method_25843((class_2248)dirt, (String)"_side_snow_covered")), this.field_22831)));
    }

    public void registerHollow(class_2248 block) {
        class_2960 outside = class_4941.method_25842((class_2248)UBlocks.CHITIN);
        class_2960 inside = class_4941.method_25843((class_2248)UBlocks.CHITIN, (String)"_bottom");
        this.method_35868(UBlocks.CHITIN, new class_4944().method_25868(class_4945.field_23018, outside).method_25868(class_4945.field_23015, outside).method_25868(class_4945.field_23014, inside), class_4943.field_22977);
    }

    public void registerRotated(class_2248 block, class_4946.class_4947 modelFactory) {
        class_2960 modelId = modelFactory.get(block).method_25916(block, this.field_22831);
        this.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId)).method_25775(this.method_25675()));
    }

    public void registerPlunderVine(class_2248 plant, class_2248 bud) {
        class_4926.class_4927 rotationVariants = class_4926.method_25783((class_2769)class_2741.field_12525);
        this.createDownDefaultFacingVariantMap((arg_0, arg_1) -> ((class_4926.class_4927)rotationVariants).method_25793(arg_0, arg_1));
        this.field_22830.accept(class_4925.method_25770((class_2248)bud, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25842((class_2248)bud))).method_25775((class_4926)rotationVariants));
        class_4922 supplier = class_4922.method_25758((class_2248)plant);
        String[] stages = new String[]{"", "_2", "_3", "_4", "_4"};
        class_2741.field_37654.method_11898().forEach(age -> {
            class_2960 modelId = class_4941.method_25843((class_2248)plant, (String)("_branch" + stages[age]));
            this.createDownDefaultFacingVariantMap((direction, variant) -> supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_37654, (Comparable)age).method_25751((class_2769)class_2429.field_11329.get(direction), (Comparable)Boolean.valueOf(true)), variant.method_25828(class_4936.field_22887, (Object)modelId)));
        });
        this.field_22830.accept(supplier);
        this.method_25623(bud, class_4941.method_25842((class_2248)bud));
    }

    public final void createDownDefaultFacingVariantMap(BiConsumer<class_2350, class_4935> builder) {
        builder.accept(class_2350.field_11033, class_4935.method_25824());
        builder.accept(class_2350.field_11036, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892));
        builder.accept(class_2350.field_11035, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891));
        builder.accept(class_2350.field_11043, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892));
        builder.accept(class_2350.field_11034, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893));
        builder.accept(class_2350.field_11039, class_4935.method_25824().method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
    }

    public void registerCompactedBlock(class_2248 block) {
        for (class_4942 model : BlockModels.FLATTENED_MODELS) {
            model.method_25846(block, class_4944.method_25875((class_2960)class_4941.method_25842((class_2248)block).method_45134(p -> p.replace("compacted_", ""))), this.field_22831);
        }
        class_4922 supplier = class_4922.method_25758((class_2248)block);
        for (int i = 0; i < BlockModels.FLATTENED_MODEL_ROTATIONS.length; i = (int)((byte)(i + 1))) {
            class_2746 yAxis = (i & 4) == 0 ? class_2741.field_12546 : class_2741.field_12519;
            class_2746 xAxis = (i & 2) == 0 ? class_2741.field_12489 : class_2741.field_12540;
            class_2746 zAxis = (i & 1) == 0 ? class_2741.field_12487 : class_2741.field_12527;
            class_4936.class_4937 xRot = yAxis == class_2741.field_12546 ? class_4936.class_4937.field_22890 : class_4936.class_4937.field_22892;
            class_4936.class_4937 yRot = BlockModels.FLATTENED_MODEL_ROTATIONS[i];
            String[] suffexes = yRot.ordinal() % 2 == 0 ? BlockModels.FLATTENED_MODEL_SUFFEXES : BlockModels.FLATTENED_MODEL_SUFFEXES_ROT;
            for (int v = 0; v < suffexes.length; v = (int)((byte)(v + 1))) {
                supplier.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)yAxis, (Comparable)Boolean.valueOf((v & 4) != 0)).method_25751((class_2769)xAxis, (Comparable)Boolean.valueOf((v & 2) != 0)).method_25751((class_2769)zAxis, (Comparable)Boolean.valueOf((v & 1) != 0)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)block, (String)("_corner_" + suffexes[v]))).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22885, (Object)xRot).method_25828(class_4936.field_22886, (Object)yRot));
            }
        }
        this.field_22830.accept(supplier);
    }

    public void registerChest(class_2248 chest, class_2248 particleSource) {
        this.method_25585(class_4941.method_25842((class_2248)chest), particleSource).method_25715(new class_2248[]{chest});
        ItemModels.CHEST.method_25852(class_4941.method_25840((class_1792)chest.method_8389()), class_4944.method_25901((class_2248)particleSource), this.field_22831);
    }

    public void registerFancyBed(class_2248 bed, class_2248 particleSource) {
        this.method_25660(bed, class_4941.method_25842((class_2248)particleSource));
        super.method_25682(bed, particleSource);
    }

    public void registerStableDoor(class_2248 door) {
        class_4926.class_4930 variants = class_4926.method_25786((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12533, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537);
        this.method_25537(door.method_8389());
        this.buildDoorStateModels(door, "", (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((class_4926.class_4930)variants).method_25811(arg_0, arg_1, arg_2, arg_3, arg_4));
        this.field_22830.accept(class_4925.method_25769((class_2248)door).method_25775((class_4926)variants));
    }

    public void registerLockingDoor(class_2248 door) {
        class_4926.class_4931 variants = class_4926.method_25787((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12533, (class_2769)class_2741.field_12520, (class_2769)class_2741.field_12537, (class_2769)class_2741.field_12502);
        this.method_25537(door.method_8389());
        this.buildDoorStateModels(door, "", (facing, half, hinge, open, map) -> variants.method_25813((Comparable)facing, (Comparable)half, (Comparable)hinge, (Comparable)Boolean.valueOf(open), (Comparable)Boolean.valueOf(false), map));
        this.buildDoorStateModels(door, "_locked", (facing, half, hinge, open, map) -> variants.method_25813((Comparable)facing, (Comparable)half, (Comparable)hinge, (Comparable)Boolean.valueOf(open), (Comparable)Boolean.valueOf(true), map));
        this.field_22830.accept(class_4925.method_25769((class_2248)door).method_25775((class_4926)variants));
    }

    private void buildDoorStateModels(class_2248 door, String suffex, DoorStateConsumer variants) {
        class_4944 topTextures = new class_4944().method_25868(class_4945.field_23015, class_4944.method_25866((class_2248)door, (String)("_top" + suffex))).method_25868(class_4945.field_23014, class_4944.method_25866((class_2248)door, (String)("_bottom" + suffex)));
        class_4944 bottomTextures = topTextures.method_25879(class_4945.field_23015, topTextures.method_25867(class_4945.field_23014));
        UBlockStateModelGenerator.fillStableDoorVariantMap(variants, class_2756.field_12607, BlockModels.DOOR_LEFT.method_25847(door, "_bottom_left" + suffex, bottomTextures, this.field_22831), BlockModels.DOOR_RIGHT.method_25847(door, "_bottom_right" + suffex, bottomTextures, this.field_22831));
        UBlockStateModelGenerator.fillStableDoorVariantMap(variants, class_2756.field_12609, BlockModels.DOOR_LEFT.method_25847(door, "_top_left" + suffex, topTextures, this.field_22831), BlockModels.DOOR_RIGHT.method_25847(door, "_top_right" + suffex, topTextures, this.field_22831));
    }

    private static void fillStableDoorVariantMap(DoorStateConsumer variantMap, class_2756 targetHalf, class_2960 leftModelId, class_2960 rightModelId) {
        UBlockStateModelGenerator.fillStableDoorVariantMap(variantMap, targetHalf, class_2750.field_12588, false, class_4936.class_4937.field_22890, leftModelId);
        UBlockStateModelGenerator.fillStableDoorVariantMap(variantMap, targetHalf, class_2750.field_12586, false, class_4936.class_4937.field_22890, rightModelId);
        UBlockStateModelGenerator.fillStableDoorVariantMap(variantMap, targetHalf, class_2750.field_12588, true, class_4936.class_4937.field_22891, rightModelId);
        UBlockStateModelGenerator.fillStableDoorVariantMap(variantMap, targetHalf, class_2750.field_12586, true, class_4936.class_4937.field_22893, leftModelId);
    }

    public static void fillStableDoorVariantMap(DoorStateConsumer variantMap, class_2756 targetHalf, class_2750 hinge, boolean open, class_4936.class_4937 rotation, class_2960 modelId) {
        for (int i = 0; i < BlockRotation.DIRECTIONS.length; ++i) {
            variantMap.register(BlockRotation.DIRECTIONS[i], targetHalf, hinge, open, class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId).method_25828(class_4936.field_22886, (Object)BlockRotation.cycle(rotation, i)));
        }
    }

    public void registerPillar(class_2248 pillar) {
        class_4944 textures = new class_4944().method_25868(class_4945.field_23018, class_4941.method_25843((class_2248)pillar, (String)"_side")).method_25868(class_4945.field_23015, class_4941.method_25843((class_2248)pillar, (String)"_lip")).method_25868(class_4945.field_23014, class_4941.method_25843((class_2248)pillar, (String)"_end")).method_25868(class_4945.field_23013, class_4941.method_25843((class_2248)pillar, (String)"_side_end"));
        class_2960 middle = BlockModels.TEMPLATE_PILLAR.method_25846(pillar, textures, this.field_22831);
        class_2960 end = BlockModels.TEMPLATE_PILLAR_END.method_25846(pillar, textures, this.field_22831);
        this.field_22830.accept(class_4922.method_25758((class_2248)pillar).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)middle).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048).method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11048).method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)middle)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052).method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11052).method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11051), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)middle).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11051).method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12496, (Comparable)class_2350.class_2351.field_11051).method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)end).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)));
        ItemModels.TEMPLATE_PILLAR.method_25852(class_4941.method_25840((class_1792)pillar.method_8389()), textures, this.field_22831);
    }

    public void registerHiveBlock(class_2248 hive) {
        class_2960 core = class_4941.method_25843((class_2248)hive, (String)"_core");
        class_2960 side = class_4941.method_25843((class_2248)hive, (String)"_side");
        this.field_22830.accept(class_4922.method_25758((class_2248)hive).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)core)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)side).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22893)));
        class_4943.field_22972.method_25852(class_4941.method_25840((class_1792)hive.method_8389()), class_4944.method_25875((class_2960)class_4941.method_25843((class_2248)hive, (String)"_side")), this.field_22831);
    }

    public void registerWithStages(class_2248 crop, class_2769<Integer> ageProperty, BlockModels.Factory modelFactory, int ... stages) {
        if (ageProperty.method_11898().size() != stages.length) {
            throw new IllegalArgumentException();
        }
        int offset = (Integer)ageProperty.method_11898().iterator().next();
        Int2ObjectOpenHashMap uploadedModels = new Int2ObjectOpenHashMap();
        this.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(class_4926.method_25783(ageProperty).method_25795(age -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)((class_2960)uploadedModels.computeIfAbsent(stages[age - offset], stage -> modelFactory.upload(crop, "_stage" + stage, this.field_22831)))))));
    }

    public void registerWithStagesBuiltinModels(class_2248 crop, class_2769<Integer> ageProperty, int ... stages) {
        if (ageProperty.method_11898().size() != stages.length) {
            throw new IllegalArgumentException();
        }
        int offset = (Integer)ageProperty.method_11898().iterator().next();
        this.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(class_4926.method_25783(ageProperty).method_25795(age -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)crop, (String)("_stage" + stages[age - offset]))))));
    }

    public <T extends Enum<T>> void registerTallCrop(class_2248 crop, class_2769<Integer> ageProperty, class_2754<T> partProperty, int[] ... ageTextureIndices) {
        HashMap uploadedModels = new HashMap();
        this.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(class_4926.method_25784(partProperty, ageProperty).method_25800((part, age) -> {
            int i = ageTextureIndices[part.ordinal()][age];
            class_2960 identifier = uploadedModels.computeIfAbsent("_" + ((class_3542)part).method_15434() + "_stage" + i, variant -> this.method_25557(crop, (String)variant, class_4943.field_22921, class_4944::method_25880));
            return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier);
        })));
    }

    public void registerSlimeLayers(class_2248 block) {
        class_2960 fullModel = class_4941.method_25842((class_2248)class_2246.field_10030);
        this.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4926.method_25783((class_2769)class_2741.field_12536).method_25795(height -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)(height < 8 ? class_4941.method_25843((class_2248)block, (String)("_height" + height * 2)) : fullModel)))));
        this.method_25623(block, class_4941.method_25843((class_2248)block, (String)"_height2"));
    }

    public void registerPie(class_2248 pie) {
        class_4944 textures = new class_4944().method_25868(class_4945.field_23015, class_4941.method_25843((class_2248)pie, (String)"_top")).method_25868(class_4945.field_23014, class_4941.method_25843((class_2248)pie, (String)"_bottom")).method_25868(class_4945.field_23018, class_4941.method_25843((class_2248)pie, (String)"_side")).method_25868(class_4945.field_27791, class_4941.method_25843((class_2248)pie, (String)"_inside"));
        class_4944 stompedTextures = textures.method_25879(class_4945.field_23015, class_4941.method_25843((class_2248)pie, (String)"_top_stomped"));
        this.field_22830.accept(class_4925.method_25769((class_2248)pie).method_25775(class_4926.method_25784((class_2769)PieBlock.BITES, (class_2769)PieBlock.STOMPED).method_25800((bites, stomped) -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)BlockModels.PIE_MODELS[bites].method_25847(pie, stomped != false ? "_stomped" : "", stomped != false ? stompedTextures : textures, this.field_22831)))));
    }

    public void registerFloweringLeaves(class_2248 block) {
        class_2960 baseModel = class_4946.field_23049.method_25923(block, this.field_22831);
        class_2960 floweringModel = class_4943.field_22972.method_25847(block, "_flowering", class_4944.method_25883((class_4945)class_4945.field_23010, (class_2960)class_4941.method_25843((class_2248)block, (String)"_flowering")), this.field_22831);
        this.field_22830.accept(class_4922.method_25758((class_2248)block).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)baseModel)).method_25760((class_4918)class_4918.method_25744().method_25751(FruitBearingBlock.STAGE, (Comparable)((Object)FruitBearingBlock.Stage.FLOWERING)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)floweringModel)));
    }

    public void registerZapLeaves(class_2248 block) {
        class_2960 baseModel = class_4946.field_23049.method_25923(block, this.field_22831);
        class_2960 floweringModel = class_7923.field_41175.method_10221((Object)block).method_45138("block/flowering_");
        class_2960 airModel = class_4941.method_25842((class_2248)class_2246.field_10124);
        this.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4926.method_25783(ZapAppleLeavesBlock.STAGE).method_25795(stage -> {
            class_4935 class_49352 = class_4935.method_25824();
            return class_49352.method_25828(class_4936.field_22887, (Object)(switch (stage) {
                case ZapAppleStageStore.Stage.HIBERNATING -> airModel;
                case ZapAppleStageStore.Stage.FLOWERING -> floweringModel;
                default -> baseModel;
            }));
        })));
    }

    public void registerSprout(class_2248 sprout) {
        this.field_22830.accept(class_4925.method_25769((class_2248)sprout).method_25775(class_4926.method_25783((class_2769)class_2741.field_12550).method_25795(age -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)Unicopia.id("block/apple_sprout_stage" + age)))));
    }

    public void registerShell(class_2248 shell) {
        this.field_22830.accept(class_4925.method_25769((class_2248)shell).method_25775(class_4926.method_25783((class_2769)ShellsBlock.COUNT).method_25795(count -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)BlockModels.SHELL_MODELS[count - 1].method_25846(shell, class_4944.method_25883((class_4945)BlockModels.SHELL, (class_2960)class_7923.field_41175.method_10221((Object)shell).method_45138("item/")), this.field_22831)))));
    }

    public void registerHull(class_2248 block, class_2248 core, class_2248 shell) {
        this.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4943.field_22977.method_25846(block, new class_4944().method_25868(class_4945.field_23014, class_4941.method_25842((class_2248)core)).method_25868(class_4945.field_23015, class_4941.method_25842((class_2248)shell)).method_25868(class_4945.field_23018, class_4941.method_25843((class_2248)shell, (String)"_half")), this.field_22831))).method_25775(this.method_25675()));
    }

    static interface DoorStateConsumer {
        public void register(class_2350 var1, class_2756 var2, class_2750 var3, boolean var4, class_4935 var5);
    }
}

