/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.IItemEntity;
import com.minelittlepony.unicopia.entity.ItemPhysics;
import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.item.ItemDuck;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.item.enchantment.UEnchantments;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.DataTrackerManager;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.VecHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1924;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class ItemImpl
implements Equine<class_1542> {
    private final class_1542 entity;
    private final ItemPhysics physics;
    private final DataTrackerManager trackers;
    protected final DataTracker tracker;
    private final DataTracker.Entry<Race> race;

    public ItemImpl(class_1542 owner) {
        this.entity = owner;
        this.trackers = Trackable.of((class_1297)this.entity).getDataTrackers();
        this.tracker = this.trackers.getPrimaryTracker();
        this.physics = new ItemPhysics(owner);
        this.race = this.tracker.startTracking(TrackableDataType.RACE, Race.HUMAN);
    }

    @Override
    public boolean onProjectileImpact(class_1676 projectile) {
        return false;
    }

    @Override
    public boolean beforeUpdate() {
        class_5819 random;
        if (!this.entity.method_37908().field_9236 && EnchantmentUtil.getWantItNeedItLevel(this.entity) > 0 && (random = this.entity.method_37908().field_9229).method_43048(15) == 0) {
            ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, this.entity.method_19538().method_1019(VecHelper.sphere(random).get().method_1031(0.0, 1.0, 0.0)), 0.2f), (class_1297)this.entity, 1);
        }
        class_1799 stack = this.entity.method_6983();
        IItemEntity i = (IItemEntity)this.entity;
        ItemDuck duck = ItemDuck.of(stack);
        if (!stack.method_7960()) {
            if (duck.isClingy(stack)) {
                class_5819 rng = this.entity.method_37908().field_9229;
                this.entity.method_37908().method_8406(duck.getParticleEffect(i), this.entity.method_23317() + (double)rng.method_43057() - 0.5, this.entity.method_23318() + (double)rng.method_43057() - 0.5, this.entity.method_23321() + (double)rng.method_43057() - 0.5, 0.0, 0.0, 0.0);
                class_243 position = this.entity.method_19538();
                VecHelper.findInRange((class_1297)this.entity, (class_1924)this.entity.method_37908(), this.entity.method_19538(), duck.getFollowDistance(i), e -> e instanceof class_1657).stream().sorted((a, b) -> (int)(a.method_19538().method_1022(position) - b.method_19538().method_1022(position))).findFirst().ifPresent(player -> {
                    double distance = player.method_19538().method_1022(this.entity.method_19538());
                    this.entity.method_5784(class_1313.field_6308, player.method_19538().method_1020(this.entity.method_19538()).method_1021(distance < 0.3 ? 1.0 : (double)duck.getFollowSpeed(i)));
                    if (this.entity.field_5976) {
                        this.entity.method_5784(class_1313.field_6308, new class_243(0.0, this.entity.field_5992 ? -0.3 : 0.3, 0.0));
                    }
                    duck.interactWithPlayer(i, (class_1657)player);
                });
            }
            if (stack.method_31573(UTags.Items.FALLS_SLOWLY) && !this.entity.method_24828() && Math.signum(this.entity.method_18798().field_1351) != (double)this.getPhysics().getGravitySignum()) {
                double ticks = this.entity.field_6012;
                double shift = Math.sin(ticks / 9.0) / 9.0;
                double rise = -Math.cos(ticks / 9.0) * (double)this.getPhysics().getGravitySignum();
                this.entity.field_5982 = this.entity.field_5982;
                this.entity.method_36456(this.entity.method_36454() + 0.3f);
                this.entity.method_18799(this.entity.method_18798().method_18805(0.25, 0.0, 0.25).method_1031(0.0, rise, 0.0).method_1019(this.entity.method_5828(1.0f)).method_1029().method_1021(shift));
            }
            return duck.onGroundTick(i).method_23665();
        }
        return false;
    }

    @Override
    public void tick() {
        this.physics.tick();
    }

    @Override
    public Physics getPhysics() {
        return this.physics;
    }

    @Override
    public Race getSpecies() {
        return this.race.get();
    }

    @Override
    public void setSpecies(Race race) {
        this.race.set(race);
    }

    @Override
    public boolean collidesWithClouds() {
        return this.entity.method_6983().method_31573(UTags.Items.FLOATS_ON_CLOUDS) || this.getSpecies().hasPersistentWeatherMagic();
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10582("owner_race", this.getSpecies().getId().toString());
        this.physics.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_10573("owner_race", 8)) {
            this.setSpecies(Race.fromName(compound.method_10558("owner_race"), Race.HUMAN));
        }
        this.physics.fromNBT(compound, lookup);
    }

    @Override
    public class_1542 asEntity() {
        return this.entity;
    }

    public static interface ClingyItem {
        default public boolean isClingy(class_1799 stack) {
            return EnchantmentUtil.getLevel(UEnchantments.CLINGY, stack) > 0;
        }

        default public class_2394 getParticleEffect(IItemEntity entity) {
            return class_2398.field_11245;
        }

        default public float getFollowDistance(IItemEntity entity) {
            return 6 * (1 + EnchantmentUtil.getLevel(UEnchantments.CLINGY, ((ItemImpl)entity.get()).asEntity().method_6983()));
        }

        default public float getFollowSpeed(IItemEntity entity) {
            return Math.min(1.0f, 0.02f * (float)(1 + EnchantmentUtil.getLevel(UEnchantments.CLINGY, ((ItemImpl)entity.get()).asEntity().method_6983())));
        }

        default public void interactWithPlayer(IItemEntity entity, class_1657 player) {
        }
    }
}

