/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellInventory;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.entity.AttributeContainer;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.ItemTracker;
import com.minelittlepony.unicopia.entity.LandingEventHandler;
import com.minelittlepony.unicopia.entity.Transportation;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.behaviour.Guest;
import com.minelittlepony.unicopia.entity.damage.MagicalDamageSource;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.effect.CorruptInfluenceStatusEffect;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.mob.LevitatingItemEntity;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.input.Heuristic;
import com.minelittlepony.unicopia.input.Interactable;
import com.minelittlepony.unicopia.item.GlassesItem;
import com.minelittlepony.unicopia.item.TotemOfDying;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.component.BreaksIntoItemComponent;
import com.minelittlepony.unicopia.item.component.UDataComponentTypes;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.DataTrackerManager;
import com.minelittlepony.unicopia.network.track.Trackable;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.projectile.ProjectileImpactListener;
import com.minelittlepony.unicopia.server.world.DragonBreathStore;
import com.minelittlepony.unicopia.util.Tickable;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.serialization.NbtMap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2752;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

public abstract class Living<T extends class_1309>
implements Equine<T>,
Caster<T>,
AttributeContainer {
    protected final T entity;
    private final SpellInventory spells;
    private final Interactable sneakingHeuristic;
    private final Interactable landedHeuristic;
    private final Interactable jumpingHeuristic;
    private boolean invisible = false;
    @Nullable
    private Caster<?> attacker;
    @Nullable
    private transient Caster<?> host;
    private Optional<Living<?>> target = Optional.empty();
    private int invinsibilityTicks;
    private final List<Tickable> tickers = new ArrayList<Tickable>();
    private final LandingEventHandler landEvent = this.addTicker(new LandingEventHandler(this));
    private final NbtMap<class_2960, Float> enchants = NbtMap.of(class_2960.field_25139, Codec.FLOAT);
    private final ItemTracker armour = this.addTicker(new ItemTracker(this));
    private final Transportation<T> transportation = new Transportation(this);
    protected final DataTrackerManager trackers;
    protected final DataTracker tracker;
    protected final DataTracker.Entry<Optional<UUID>> carrierId;

    protected Living(T entity) {
        this.entity = entity;
        this.trackers = Trackable.of(entity).getDataTrackers();
        this.tracker = this.trackers.getPrimaryTracker();
        this.spells = SpellSlots.ofUnbounded(this);
        this.sneakingHeuristic = this.addTicker(new Interactable(() -> entity.method_5715()));
        this.landedHeuristic = this.addTicker(new Interactable(() -> entity.method_24828()));
        this.jumpingHeuristic = this.addTicker(new Interactable(((LivingEntityDuck)entity)::isJumping));
        this.carrierId = this.tracker.startTracking(TrackableDataType.UUID, Optional.empty());
    }

    public <Q extends Tickable> Q addTicker(Q tickable) {
        this.tickers.add(Objects.requireNonNull(tickable, "tickable cannot be null"));
        return tickable;
    }

    public boolean isInvisible() {
        return this.invisible && SpellPredicate.IS_DISGUISE.isOn(this);
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    public void waitForFall(LandingEventHandler.Callback callback) {
        this.landEvent.setCallback(callback);
    }

    public boolean sneakingChanged() {
        return this.sneakingHeuristic.hasChanged(Heuristic.ONCE);
    }

    public boolean landedChanged() {
        return this.landedHeuristic.hasChanged(Heuristic.ONCE);
    }

    public Interactable getJumpingHeuristic() {
        return this.jumpingHeuristic;
    }

    @Override
    public SpellSlots getSpellSlot() {
        return this.spells.getSlots();
    }

    public NbtMap<class_2960, Float> getEnchants() {
        return this.enchants;
    }

    public ItemTracker getArmour() {
        return this.armour;
    }

    public Transportation<T> getTransportation() {
        return this.transportation;
    }

    @Override
    public final T asEntity() {
        return this.entity;
    }

    public Optional<UUID> getCarrierId() {
        return this.carrierId.get();
    }

    public void setCarrier(UUID carrier) {
        this.carrierId.set(Optional.ofNullable(carrier));
    }

    public void setCarrier(class_1297 carrier) {
        this.setCarrier(carrier == null ? null : carrier.method_5667());
    }

    @Nullable
    public Optional<Living<?>> getTarget() {
        return this.target;
    }

    public void setTarget(Living<?> target) {
        this.target = Optional.ofNullable(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBeingCarried() {
        class_1297 vehicle = this.entity.method_5854();
        if (vehicle == null) return false;
        if (!this.getCarrierId().filter(vehicle.method_5667()::equals).isPresent()) return false;
        return true;
    }

    @Override
    public boolean hasFeatherTouch() {
        return EnchantmentUtil.hasAnyEnchantmentsIn(this.entity, UTags.Enchantments.PERMITS_CLOUD_INTERACTION);
    }

    @Override
    public boolean beforeUpdate() {
        this.landEvent.beforeTick();
        if (this.entity.method_6059(UEffects.PARALYSIS) && this.entity.method_18798().method_37268() > 0.0) {
            this.entity.method_18799(this.entity.method_18798().method_18805(0.0, 1.0, 0.0));
            this.updateVelocity();
        }
        return false;
    }

    @Override
    public void tick() {
        this.tickers.forEach(Tickable::tick);
        this.spells.tick(Situation.BODY);
        if (!(this.entity instanceof class_1657) && !this.entity.method_5765() && this.getCarrierId().isPresent() && !this.asWorld().field_9236 && ((class_1309)this.entity).field_6012 % 10 == 0) {
            UUID carrierId = this.getCarrierId().get();
            class_1297 carrier = ((class_3218)this.asWorld()).method_14190(carrierId);
            if (carrier != null) {
                this.asEntity().method_5873(carrier, true);
                Living.transmitPassengers(carrier);
            } else {
                Unicopia.LOGGER.warn("No passenger with id {]", (Object)carrierId);
            }
        }
        if (this.invinsibilityTicks > 0) {
            --this.invinsibilityTicks;
        }
        if (this.entity.method_6059(UEffects.PARALYSIS) && this.entity.method_18798().method_37268() > 0.0) {
            this.entity.method_18799(this.entity.method_18798().method_18805(0.0, 1.0, 0.0));
            this.updateVelocity();
        }
        if (this.isBeingCarried()) {
            Pony carrier = Pony.of(this.entity.method_5854()).orElse(null);
            if (!Abilities.CARRY.canUse(carrier.getCompositeRace()) && !Abilities.HUG.canUse(carrier.getCompositeRace())) {
                this.entity.method_5848();
                this.entity.method_29495(carrier.getOriginVector());
                Living.transmitPassengers(carrier.asEntity());
            }
            this.entity.method_36456(((class_1657)carrier.asEntity()).method_36454());
        }
        this.updateDragonBreath();
        if (EnchantmentUtil.getGemfinderLevel(this.entity) > 0) {
            InteractionManager.getInstance().playLoopingSound((class_1297)this.entity, 8, 0L);
        }
        this.transportation.tick();
    }

    @Override
    @Nullable
    public final class_1324 getAttributeInstance(class_6880<class_1320> attribute) {
        return this.asEntity().method_5996(attribute);
    }

    public boolean canBeSeenBy(class_1297 entity) {
        return !this.isInvisible() && this.getSpellSlot().get(SpellPredicate.IS_DISGUISE).filter(spell -> spell.getDisguise().getAppearance() == entity).isEmpty();
    }

    public Optional<class_243> adjustMovementSpeedInWater(class_243 speed) {
        return Optional.empty();
    }

    private void updateDragonBreath() {
        if (!this.entity.method_37908().field_9236 && (this.entity instanceof class_1657 || this.entity.method_16914())) {
            class_243 targetPos = this.entity.method_5720().method_1021(2.0).method_1019(this.entity.method_33571());
            if (this.entity.method_37908().method_22347(class_2338.method_49638((class_2374)targetPos))) {
                String name = this.entity.method_5476().getString();
                DragonBreathStore.popAll(this.entity.method_5682(), name).forEach(stack -> {
                    class_243 randomPos;
                    class_1799 payload = stack.payload();
                    class_1792 item = payload.method_7909();
                    boolean deliverAggressively = payload.method_31573(UTags.Items.IS_DELIVERED_AGGRESSIVELY);
                    class_243 class_2432 = randomPos = deliverAggressively ? targetPos.method_1031(0.0, 2.0, 0.0) : targetPos.method_1019(VecHelper.triangular(this.entity.method_59922(), 0.1, 0.5));
                    if (deliverAggressively && item instanceof class_1747) {
                        class_1747 blockItem = (class_1747)item;
                        do {
                            class_1799 instance = payload.method_7971(1);
                            class_2338 pos = class_2338.method_49638((class_2374)randomPos);
                            if (!this.entity.method_37908().method_22347(pos)) {
                                stack.store().put(name, instance);
                            } else {
                                for (int i = 0; i < 10; ++i) {
                                    ParticleUtils.spawnParticle(this.entity.method_37908(), (class_2394)class_2398.field_11240, randomPos.method_1019(VecHelper.triangular(this.entity.method_59922(), 0.1, 0.5)), class_243.field_1353);
                                }
                                class_1750 context = new class_1750(this.entity.method_37908(), (class_1657)null, class_1268.field_5808, instance, class_3965.method_17778((class_243)class_243.field_1353, (class_2350)class_2350.field_11036, (class_2338)pos));
                                class_2680 state = blockItem.method_7711().method_9605(context);
                                if (state == null) {
                                    state = blockItem.method_7711().method_9564();
                                }
                                this.entity.method_37908().method_8501(pos, state);
                                class_2498 sound = state.method_26231();
                                this.entity.method_37908().method_8396(null, pos, sound.method_10598(), class_3419.field_15245, (sound.method_10597() + 1.0f) * 0.5f, sound.method_10599() * 0.8f);
                            }
                            randomPos = targetPos.method_1019(VecHelper.triangular(this.entity.method_59922(), 0.1, 0.5));
                        } while (!payload.method_7960());
                    } else if (!this.entity.method_37908().method_22347(class_2338.method_49638((class_2374)randomPos))) {
                        stack.store().put(name, stack.payload());
                    } else {
                        for (int i = 0; i < 10; ++i) {
                            ParticleUtils.spawnParticle(this.entity.method_37908(), (class_2394)class_2398.field_11240, randomPos.method_1019(VecHelper.triangular(this.entity.method_59922(), 0.1, 0.5)), class_243.field_1353);
                        }
                        class_1542 itemEntity = (class_1542)class_1299.field_6052.method_5883(this.entity.method_37908());
                        itemEntity.method_6979(payload);
                        itemEntity.method_33574(randomPos);
                        itemEntity.method_37908().method_8649((class_1297)itemEntity);
                        this.entity.method_37908().method_43129(null, this.entity, USounds.ITEM_DRAGON_BREATH_ARRIVE, this.entity.method_5634(), 1.0f, 1.0f);
                        UCriteria.SEND_DRAGON_BREATH.triggerReceived((class_1309)this.entity, payload.method_7972());
                    }
                });
            }
        }
    }

    public boolean onUpdatePassengerPosition(class_1297 passender, class_1297.class_4738 positionUpdater) {
        return false;
    }

    @Nullable
    public final Caster<?> getAttacker() {
        return this.attacker;
    }

    public Optional<Boolean> onDamage(class_1282 source, float amount) {
        class_1588 mob;
        if (this.entity.method_5668() instanceof LevitatingItemEntity && (source.method_49708(class_8111.field_42340) || source.method_48789(class_8103.field_42250))) {
            return Optional.of(false);
        }
        if (Guest.of(source.method_5529()).hostIs(this) || Guest.of(source.method_5526()).hostIs(this)) {
            class_6880 type = source.method_48793();
            return Optional.of(this.entity.method_5643(type.method_40225(class_8111.field_42325) ? this.entity.method_48923().method_48795(class_8111.field_42326) : (type.method_40225(class_8111.field_42332) ? this.entity.method_48923().method_48795(class_8111.field_42331) : new class_1282(type, this.entity, this.entity)), amount));
        }
        Caster<Object> caster = Guest.of(this.entity).getHost();
        if (caster instanceof Living) {
            Living l = (Living)caster;
            l.asEntity().method_5643(source, amount);
        }
        if (source.method_48789(class_8103.field_42253) && (this.invinsibilityTicks > 0 || this.tryCaptureLightning())) {
            return Optional.of(false);
        }
        if (source instanceof MagicalDamageSource) {
            TrinketsDelegate.EquippedStack glasses;
            BreaksIntoItemComponent afterBroken;
            MagicalDamageSource magical = (MagicalDamageSource)source;
            Caster<?> attacker = magical.getSpell();
            if (attacker != null) {
                this.attacker = attacker;
            }
            if ((afterBroken = (BreaksIntoItemComponent)(glasses = GlassesItem.getForEntity(this.entity)).stack().method_57824(UDataComponentTypes.ITEM_AFTER_BREAKING)) != null && magical.method_48789(afterBroken.damageType()) && afterBroken != null) {
                afterBroken.getItemAfterBreaking().ifPresent(b -> {
                    glasses.set(glasses.stack().method_60503((class_1935)b));
                    afterBroken.getBreakingSound().ifPresent(sound -> this.playSound((class_3414)sound, 1.0f, 1.0f));
                });
            }
        }
        if ((caster = this.entity) instanceof class_1588 && (mob = (class_1588)caster).method_6059(UEffects.CORRUPT_INFLUENCE) && mob.method_59922().method_43048(4000) == 0) {
            CorruptInfluenceStatusEffect.reproduce(mob);
        }
        return Optional.empty();
    }

    public void onDeath(class_1282 damage, boolean usedTotem) {
        TotemOfDying.tryUseTotem(damage, this.entity);
    }

    public void onAttacking(class_1297 target) {
    }

    public TriState canBeHurtByWater() {
        return TriState.DEFAULT;
    }

    public Optional<class_2338> chooseClimbingPos() {
        return this.getSpellSlot().get(SpellPredicate.IS_DISGUISE).map(AbstractDisguiseSpell::getDisguise).filter(EntityAppearance::canClimbWalls).map(v -> this.entity.method_24515());
    }

    private boolean tryCaptureLightning() {
        return this.getInventoryStacks().filter(stack -> stack.method_31574(UItems.EMPTY_JAR)).findFirst().map(stack -> {
            this.invinsibilityTicks = 20;
            stack.method_7971(1);
            this.giveBackItem(UItems.LIGHTNING_JAR.method_7854());
            return stack;
        }).isPresent();
    }

    protected Stream<class_1799> getInventoryStacks() {
        return Stream.of(this.entity.method_5998(class_1268.field_5808), this.entity.method_5998(class_1268.field_5810));
    }

    public Stream<class_1799> getArmourStacks() {
        if (!TrinketsDelegate.hasTrinkets()) {
            return StreamSupport.stream(this.entity.method_5661().spliterator(), false);
        }
        return Stream.concat(TrinketsDelegate.getInstance(this.entity).getEquipped((class_1309)this.entity, TrinketsDelegate.NECKLACE).map(TrinketsDelegate.EquippedStack::stack), StreamSupport.stream(this.entity.method_5661().spliterator(), false));
    }

    protected void giveBackItem(class_1799 stack) {
        this.entity.method_5775(stack);
    }

    @Override
    public boolean onProjectileImpact(class_1676 projectile) {
        return this.getSpellSlot().get().filter(effect -> !effect.isDead() && effect instanceof ProjectileImpactListener && ((ProjectileImpactListener)((Object)effect)).onProjectileImpact(projectile)).isPresent();
    }

    public float onImpact(float distance, float damageMultiplier, class_1282 cause) {
        float fallDistance = this.landEvent.fire(this.getEffectiveFallDistance(distance));
        this.getSpellSlot().get(SpellPredicate.IS_DISGUISE).ifPresent(spell -> spell.getDisguise().onImpact(this, fallDistance, damageMultiplier, cause));
        return fallDistance;
    }

    protected float getEffectiveFallDistance(float distance) {
        return distance;
    }

    @Override
    public float getCloudWalkingStrength() {
        return this.asWorld().method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9129).map(featherFalling -> {
            int maxLevel = ((class_1887)featherFalling.comp_349()).method_8183();
            int level = class_1890.method_8203((class_6880)featherFalling, this.entity);
            return Float.valueOf(class_3532.method_15363((float)((float)level / (float)maxLevel), (float)0.0f, (float)1.0f));
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.enchants.toNBT(compound, lookup);
        this.spells.getSlots().toNBT(compound, lookup);
        this.getCarrierId().ifPresent(id -> compound.method_25927("carrier", id));
        this.toSyncronisedNbt(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.enchants.fromNBT(compound, lookup);
        this.spells.getSlots().fromNBT(compound, lookup);
        this.setCarrier(compound.method_25928("carrier") ? compound.method_25926("carrier") : null);
        this.fromSynchronizedNbt(compound, lookup);
    }

    public void toSyncronisedNbt(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10566("armour", (class_2520)this.armour.toNBT(lookup));
    }

    public void fromSynchronizedNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.armour.fromNBT(compound.method_10562("armour"), lookup);
    }

    public void updateVelocity() {
        Living.updateVelocity(this.entity);
    }

    @Override
    public boolean canUse(Ability<?> ability) {
        return ability.canUse(this.getCompositeRace());
    }

    public static Optional<Living<?>> getOrEmpty(class_1297 entity) {
        return Equine.of(entity, a -> a instanceof Living);
    }

    public static Living<?> living(class_1297 entity) {
        return Living.getOrEmpty(entity).orElse(null);
    }

    public static <E extends class_1309> Living<E> living(E entity) {
        return Equine.of(entity, e -> e instanceof Living).orElse(null);
    }

    public static void updateVelocity(@Nullable class_1297 entity) {
        if (entity != null) {
            entity.field_6037 = true;
        }
    }

    public static void transmitPassengers(@Nullable class_1297 entity) {
        class_1937 class_19372;
        if (entity != null && (class_19372 = entity.method_37908()) instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            sw.method_14178().method_18751(entity, (class_2596)new class_2752(entity));
        }
    }
}

