/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.behaviour;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.compat.pehkui.PehkUtil;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.behaviour.AxolotlBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.BeeBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.BlazeBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.BreezeBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.CamelBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.ChickenBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.CreeperBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.behaviour.EndermanBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.behaviour.FallingBlockBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.GhastBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.HoppingBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.IronGolemBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.MinecartBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.MobBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.PlayerBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.RangedAttackBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.SheepBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.ShulkerBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.SilverfishBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.SpellcastingIllagerBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.SteedBehaviour;
import com.minelittlepony.unicopia.entity.behaviour.TraderBehaviour;
import com.minelittlepony.unicopia.entity.duck.EntityDuck;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.LimbAnimationUtil;
import com.minelittlepony.unicopia.util.RegistryUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1473;
import net.minecraft.class_1501;
import net.minecraft.class_1530;
import net.minecraft.class_1540;
import net.minecraft.class_1547;
import net.minecraft.class_1657;
import net.minecraft.class_1673;
import net.minecraft.class_1680;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import org.jetbrains.annotations.Nullable;

public class EntityBehaviour<T extends class_1297> {
    private static final EntityBehaviour<class_1297> DEFAULT = new EntityBehaviour();
    private static final class_2378<EntityBehaviour<?>> REGISTRY = RegistryUtils.createSimple(Unicopia.id("entity_behaviour"));

    public void update(Living<?> source, T entity, Disguise spell) {
        if (source instanceof Pony) {
            this.update((Pony)source, entity, spell);
        }
    }

    protected void update(Pony pony, T entity, Disguise spell) {
    }

    public void onImpact(Caster<?> source, T entity, float distance, float damageMultiplier, class_1282 cause) {
    }

    public T onCreate(T entity, EntityAppearance context, boolean wasNew) {
        entity.method_5646();
        PehkUtil.clearScale(entity);
        return entity;
    }

    public void onDestroy(T entity) {
        entity.method_5684(false);
        entity.method_5875(false);
        entity.method_5650(class_1297.class_5529.field_26998);
    }

    public boolean isEqual(T a, class_1297 b) {
        return a.method_5864() == b.method_5864();
    }

    public Optional<Float> getCameraDistance(class_1297 entity, Pony player) {
        if (entity == null) {
            return Optional.empty();
        }
        double normalHeight = class_1657.field_18135.comp_2186();
        double entityHeight = entity.method_18377(entity.method_18376()).comp_2186();
        return Optional.of(Float.valueOf((float)(entityHeight / normalHeight)));
    }

    public Optional<class_4048> getDimensions(T entity, Optional<class_4048> current) {
        if (entity == null) {
            return Optional.empty();
        }
        class_4048 dims = entity.method_18377(entity.method_18376());
        float h = Math.max(0.001f, dims.comp_2186());
        float w = Math.max(0.001f, dims.comp_2185());
        if (current.isPresent() && h == current.get().comp_2186() && w == current.get().comp_2185()) {
            return current;
        }
        return Optional.of(class_4048.method_18384((float)w, (float)h));
    }

    public void copyBaseAttributes(class_1309 from, class_1297 to) {
        this.copyBaseAttributes(from, to, class_243.field_1353);
    }

    /*
     * Unable to fully structure code
     */
    public void copyBaseAttributes(class_1309 from, class_1297 to, class_243 positionOffset) {
        to.field_6012 = from.field_6012;
        ((EntityDuck)to).setRemovalReason(from.method_35049());
        to.method_24830(from.method_24828());
        if (!from.method_37908().field_9236) {
            clip = to.field_5960;
            to.field_5960 = false;
            vel = from.method_5828(1.0f);
            if (!(to instanceof class_1530)) {
                to.method_5784(class_1313.field_6308, vel);
            } else {
                to.method_18799(class_243.field_1353);
            }
            to.field_5960 = clip;
        } else {
            to.field_5992 = from.field_5992;
            to.field_5976 = from.field_5976;
        }
        if (EntityAppearance.isAxisAligned(to)) {
            x = positionOffset.field_1352 + Math.floor(from.method_23317()) + 0.5;
            y = positionOffset.field_1351 + Math.floor(from.method_23318());
            z = positionOffset.field_1350 + Math.floor(from.method_23321()) + 0.5;
            to.field_6014 = x;
            to.field_6036 = y;
            to.field_5969 = z;
            to.field_6038 = x;
            to.field_5971 = y;
            to.field_5989 = z;
            to.method_30634(x, y, z);
            if (to instanceof class_1540) {
                fbe = (class_1540)to;
                fbe.method_6963(from.method_24515());
            }
        } else {
            to.method_5719((class_1297)from);
            to.field_6014 = positionOffset.field_1352 + from.field_6014;
            to.field_6036 = positionOffset.field_1351 + from.field_6036;
            to.field_5969 = positionOffset.field_1350 + from.field_5969;
            to.field_6038 = positionOffset.field_1352 + from.field_6038;
            to.field_5971 = positionOffset.field_1351 + from.field_5971;
            to.field_5989 = positionOffset.field_1350 + from.field_5989;
        }
        to.method_18799(from.method_18798());
        to.method_36457(from.method_36455());
        to.field_6004 = from.field_6004;
        to.method_36456(from.method_36454());
        to.field_5982 = from.field_5982;
        to.field_5973 = from.field_5973;
        to.field_6039 = from.field_6039;
        to.field_6017 = 0.0f;
        to.method_24830(from.method_24828());
        if (from.method_5655()) ** GOTO lbl-1000
        if (from instanceof class_1657) {
            player = (class_1657)from;
            ** if (!player.method_31549().field_7477) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl55
        }
lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
lbl55:
        // 2 sources

        to.method_5684(v0);
        to.field_5994 = from.field_5994;
        if (to instanceof class_1309) {
            l = (class_1309)to;
            l.field_6241 = from.field_6241;
            l.field_6259 = from.field_6259;
            l.field_6283 = from.field_6283;
            l.field_6220 = from.field_6220;
            LimbAnimationUtil.copy(from.field_42108, l.field_42108);
            l.field_6251 = from.field_6251;
            l.field_6229 = from.field_6229;
            l.field_6279 = from.field_6279;
            l.field_6252 = from.field_6252;
            l.field_6235 = from.field_6235;
            l.field_6213 = from.field_6213;
            l.field_20347 = from.field_20347;
            l.field_6218 = from.field_6218;
            l.method_6033(from.method_6032() / from.method_6063() * l.method_6063());
            from.method_5855(l.method_5669() / l.method_5748() * from.method_5748());
            this.copyInventory(from, l);
        }
        if (to instanceof class_1321) {
            tameable = (class_1321)to;
            tameable.method_24346(from.method_5715());
        }
        if (to instanceof class_1547) {
            skeleton = (class_1547)to;
            skeleton.method_19540(from.method_6014() > 0);
        }
        if (to instanceof LivingEntityDuck) {
            duck = (LivingEntityDuck)to;
            duck.updateItemUsage(from.method_6058(), from.method_6030(), from.method_6014());
        }
        if (from.field_6012 < 100 || from instanceof class_1657 && ((player = (class_1657)from).method_7337() || player.method_7325())) {
            to.method_5646();
        }
        if (to.method_5809()) {
            from.method_5639(1.0f);
        } else {
            from.method_5646();
        }
        to.method_5660(from.method_5715());
        if (to instanceof class_1657) {
            to.method_18380(from.method_18376());
        }
    }

    protected void copyInventory(class_1309 from, class_1309 l) {
        for (class_1304 i : class_1304.values()) {
            if (this.skipSlot(i)) continue;
            class_1799 neu = from.method_6118(i);
            class_1799 old = l.method_6118(i);
            if (old == neu) continue;
            l.method_5673(i, neu);
        }
    }

    protected boolean skipSlot(class_1304 slot) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSneakingOnGround(Caster<?> source) {
        Object e = source.asEntity();
        if (!e.method_5715()) return false;
        if (!e.method_24828()) return false;
        if (!(e instanceof class_1657)) return true;
        class_1657 player = (class_1657)e;
        if (player.method_31549().field_7479) return false;
        return true;
    }

    public static <T extends class_1297> void register(Supplier<EntityBehaviour<T>> behaviour, class_1299<?> ... types) {
        for (class_1299<?> type : types) {
            class_2378.method_10230(REGISTRY, (class_2960)class_1299.method_5890(type), behaviour.get());
        }
    }

    public static <T extends class_1297> EntityBehaviour<T> forEntity(@Nullable T entity) {
        if (entity == null) {
            return DEFAULT;
        }
        return REGISTRY.method_17966(class_1299.method_5890((class_1299)entity.method_5864())).orElse(DEFAULT);
    }

    public static void bootstrap() {
    }

    static {
        EntityBehaviour.register(PlayerBehaviour::new, class_1299.field_6097);
        EntityBehaviour.register(FallingBlockBehaviour::new, class_1299.field_6089);
        EntityBehaviour.register(MobBehaviour::new, class_1299.field_6134);
        EntityBehaviour.register(IronGolemBehaviour::new, class_1299.field_6147);
        EntityBehaviour.register(HoppingBehaviour::new, class_1299.field_6140, class_1299.field_6069, class_1299.field_6102);
        EntityBehaviour.register(TraderBehaviour::new, class_1299.field_6077, class_1299.field_17713);
        EntityBehaviour.register(SteedBehaviour::new, class_1299.field_6139, class_1299.field_6067, class_1299.field_6075, class_1299.field_6048);
        EntityBehaviour.register(SheepBehaviour::new, class_1299.field_6115);
        EntityBehaviour.register(BeeBehaviour::new, class_1299.field_20346);
        EntityBehaviour.register(GhastBehaviour::new, class_1299.field_6107);
        EntityBehaviour.register(AxolotlBehaviour::new, class_1299.field_28315);
        EntityBehaviour.register(EndermanBehaviour::new, class_1299.field_6091);
        EntityBehaviour.register(() -> new RangedAttackBehaviour<class_1501>(USounds.Vanilla.field_14789, class_1673::new), class_1299.field_6074, class_1299.field_17714);
        EntityBehaviour.register(() -> new RangedAttackBehaviour<class_1473>(USounds.Vanilla.field_14745, class_1680::new), class_1299.field_6047);
        EntityBehaviour.register(SpellcastingIllagerBehaviour::new, class_1299.field_6065, class_1299.field_6090);
        EntityBehaviour.register(ShulkerBehaviour::new, class_1299.field_6109);
        EntityBehaviour.register(CreeperBehaviour::new, class_1299.field_6046);
        EntityBehaviour.register(SilverfishBehaviour::new, class_1299.field_6125);
        EntityBehaviour.register(ChickenBehaviour::new, class_1299.field_6132);
        EntityBehaviour.register(BlazeBehaviour::new, class_1299.field_6099);
        EntityBehaviour.register(BreezeBehaviour::new, class_1299.field_47244);
        EntityBehaviour.register(MinecartBehaviour::new, class_1299.field_6126, class_1299.field_6136, class_1299.field_6080, class_1299.field_6058, class_1299.field_6096, class_1299.field_6142, class_1299.field_6053);
        EntityBehaviour.register(CamelBehaviour::new, class_1299.field_40116);
    }
}

