/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.behaviour;

import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.player.PlayerAttributes;
import com.minelittlepony.unicopia.util.Swap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2726;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public interface EntitySwap {
    public static final Swap<class_1297> POSITION = Swap.of(class_1297::method_19538, (entity, pos) -> {
        entity.method_5814(pos.method_10216(), pos.method_10214(), pos.method_10215());
        if (entity instanceof class_1314) {
            class_1314 pae = (class_1314)entity;
            if (!(entity instanceof class_1657)) {
                pae.method_5942().method_6340();
            }
        }
    });
    public static final Swap<class_1297> VELOCITY = Swap.of(class_1297::method_18798, (entity, vel) -> {
        entity.method_18799(vel);
        Living.updateVelocity(entity);
    });
    public static final Swap<class_1297> PITCH = Swap.of(class_1297::method_36455, class_1297::method_36457);
    public static final Swap<class_1297> YAW = Swap.of(class_1297::method_36454, class_1297::method_36456);
    public static final Swap<class_1297> HEAD_YAW = Swap.of(class_1297::method_5791, (entity, headYaw) -> {
        entity.method_5847(headYaw.floatValue());
        class_1937 patt0$temp = entity.method_37908();
        if (patt0$temp instanceof class_3218) {
            class_3218 sw = (class_3218)patt0$temp;
            sw.method_14178().method_18751(entity, (class_2596)new class_2726(entity, (byte)class_3532.method_15375((float)(entity.method_5791() * 256.0f / 360.0f))));
        }
    });
    public static final Swap<class_1297> BODY_YAW = Swap.of(class_1297::method_43078, class_1297::method_5636);
    public static final Swap<class_1297> FIRE_TICKS = Swap.of(class_1297::method_20802, class_1297::method_20803);
    public static final Swap<class_1297> PASSENGERS = Swap.of(entity -> new ArrayList(entity.method_5685()), (entity, passengers) -> {
        entity.method_5772();
        passengers.forEach(passenger -> passenger.method_5804(entity));
        Living.transmitPassengers(entity);
    });
    public static final Swap<class_1309> STATUS_EFFECTS = Swap.of(entity -> Set.copyOf(entity.method_6088().values()), (entity, effects) -> {
        entity.method_6012();
        effects.forEach(arg_0 -> ((class_1309)entity).method_6092(arg_0));
    });
    public static final Swap<class_1309> MAX_HEALTH = Swap.of(class_1309::method_6063, (e, newMax) -> {
        float oldHealthPercentage = e.method_6032() / e.method_6063();
        e.method_5996(class_5134.field_23716).method_6200(PlayerAttributes.HEALTH_SWAPPING_MODIFIER_ID);
        float change = newMax.floatValue() - e.method_6063();
        if (!class_3532.method_15347((float)change, (float)0.0f)) {
            e.method_5996(class_5134.field_23716).method_26837(PlayerAttributes.healthChange(change));
        }
        e.method_6033(oldHealthPercentage * newMax.floatValue());
    });
    public static final Swap<class_1309> HEALTH = Swap.of(class_1309::method_6032, class_1309::method_6063, class_1309::method_6033, Number::floatValue);
    public static final Swap<class_1309> AIR = Swap.of(class_1297::method_5669, class_1297::method_5748, class_1297::method_5855, Number::intValue);
    public static final List<Swap<class_1297>> REGISTRY = new ArrayList<Swap<class_1297>>(List.of(Swap.union(POSITION, VELOCITY, PITCH, YAW, HEAD_YAW, BODY_YAW, FIRE_TICKS, PASSENGERS), Swap.union(STATUS_EFFECTS, MAX_HEALTH, HEALTH, AIR).upcast(e -> e instanceof class_1309)));
    public static final Swap<class_1297> ALL = Swap.union(REGISTRY);
}

