/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.item.component.BufferflyVariantComponent;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ButterflyEntity
extends class_1421 {
    private static final int MAX_BREEDING_COOLDOWN = 300;
    private static final int MAX_REST_TICKS = 40;
    private static final int BREEDING_INTERVAL = 20;
    private static final int FLOWER_DETECTION_RANGE = 10;
    private static final int FLOWER_UPDATE_INTERVAL = 100;
    private static final class_2940<Boolean> RESTING = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(ButterflyEntity.class, (class_2941)class_2943.field_13327);
    private Optional<class_2338> hoveringPosition = Optional.empty();
    private Optional<class_2338> flowerPosition = Optional.empty();
    private final Map<class_2338, Long> visited = new HashMap<class_2338, Long>();
    private int ticksResting;
    private int breedingCooldown;

    public ButterflyEntity(class_1299<ButterflyEntity> type, class_1937 world) {
        super(type, world);
        this.setVariant(Variant.random(world.field_9229));
        this.setResting(true);
    }

    public static class_5132.class_5133 createButterflyAttributes() {
        return ButterflyEntity.method_26828().method_26868(class_5134.field_23716, 2.0);
    }

    public static boolean canSpawn(class_1299<? extends ButterflyEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return true;
    }

    public float method_6017() {
        return super.method_6017() * 0.95f;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return USounds.ENTITY_BUTTERFLY_HURT;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public boolean method_5696() {
        return true;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(VARIANT, (Object)Variant.BUTTERFLY.ordinal());
        builder.method_56912(RESTING, (Object)false);
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
    }

    public void method_5773() {
        super.method_5773();
        class_243 vel = this.method_18798();
        this.method_18800(vel.field_1352, vel.field_1351 * 0.6 + (double)0.02f, vel.field_1350);
    }

    public boolean isResting() {
        return (Boolean)this.method_5841().method_12789(RESTING);
    }

    public void setResting(boolean resting) {
        this.method_5841().method_12778(RESTING, (Object)resting);
        if (!resting) {
            this.hoveringPosition = Optional.empty();
            this.flowerPosition = Optional.empty();
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.method_5841().method_12789(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.method_5841().method_12778(VARIANT, (Object)variant.ordinal());
    }

    protected boolean isAggressor(class_1297 e) {
        if (e instanceof ButterflyEntity) {
            return false;
        }
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (player.method_5998(class_1268.field_5808).method_31573(class_3489.field_20344)) {
                this.method_5980((class_1309)player);
                return false;
            }
            if (player.method_7337() || player.method_7325()) {
                return false;
            }
            if (player.method_5624() || player.field_6250 > 0.0f || player.field_6212 > 0.0f) {
                return true;
            }
        } else if (!class_1301.field_6156.test(e)) {
            return false;
        }
        return e.method_18798().method_37267() > (double)1.4f;
    }

    public void method_6007() {
        super.method_6007();
        if (this.breedingCooldown > 0) {
            --this.breedingCooldown;
        }
        class_2338 below = class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, -0.5, 0.0));
        this.visited.entrySet().removeIf(e -> (Long)e.getValue() < (long)(this.field_6012 - 500));
        if (this.isResting()) {
            if (!this.flowerPosition.isPresent()) {
                this.setResting(false);
                return;
            }
            if (this.method_37908().method_8320(below).method_26215() || !this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(3.0), this::isAggressor).isEmpty() || this.ticksResting++ > 40 || this.method_37908().field_9229.method_43048(500) == 0 || this.method_37908().method_8520(below)) {
                this.setResting(false);
                return;
            }
            if (!this.method_37908().field_9236 && this.field_6012 % 20 == 0 && this.method_37908().field_9229.method_43048(200) == 0 && this.canBreed()) {
                this.breed();
            }
        } else {
            this.ticksResting = 0;
            class_1309 class_13092 = this.method_5968();
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                if (player.method_31481() || !player.method_5998(class_1268.field_5808).method_31573(class_3489.field_20344)) {
                    this.method_5980(null);
                }
                if (this.method_5739((class_1297)player) > 3.0f) {
                    this.moveTowards(player.method_24515());
                } else {
                    this.method_5762((double)this.field_5974.method_43057() * 0.1 - (double)0.05f, (double)this.field_5974.method_43057() * 0.1, (double)this.field_5974.method_43057() * 0.1 - (double)0.05f);
                }
            } else {
                this.updateFlowerPosition().map(flower -> {
                    if (flower.method_19769((class_2374)this.method_19538(), 1.0)) {
                        this.setResting(true);
                        this.visited.put((class_2338)flower, Long.valueOf(this.field_6012));
                        if (this.breedingCooldown <= 0) {
                            this.breedingCooldown = 30;
                        }
                    }
                    return flower;
                }).or(this::findNextHoverPosition).ifPresent(this::moveTowards);
                if (this.field_5974.method_43048(100) == 0 && this.method_37908().method_8320(below).method_26225()) {
                    this.setResting(true);
                }
            }
        }
    }

    private boolean canBreed() {
        return this.field_6012 > 20 && this.breedingCooldown <= 0 && this.isResting() && this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(2.0), i -> i instanceof ButterflyEntity && i.method_5864() == this.method_5864() && ((ButterflyEntity)((Object)i)).isResting()).size() == 1;
    }

    private boolean breed() {
        this.breedingCooldown = 300;
        ButterflyEntity copy = (ButterflyEntity)this.method_5864().method_5883(this.method_37908());
        copy.method_5719((class_1297)this);
        this.method_37908().method_8649((class_1297)copy);
        this.setResting(false);
        return true;
    }

    private Optional<class_2338> findNextHoverPosition() {
        class_2338 pos = this.method_24515();
        this.hoveringPosition = this.hoveringPosition.filter(p -> this.method_37908().method_22347(p) && p.method_10264() >= 1 && this.field_5974.method_43048(30) != 0 && p.method_10262((class_2382)pos) >= 4.0).or(() -> Optional.of(pos.method_10069(this.field_5974.method_43048(7) - this.field_5974.method_43048(7), this.field_5974.method_43048(6) - 2, this.field_5974.method_43048(7) - this.field_5974.method_43048(7))));
        return this.hoveringPosition;
    }

    private Optional<class_2338> updateFlowerPosition() {
        if (this.field_6012 > 0 && this.field_6012 % 100 != 0) {
            return this.flowerPosition;
        }
        this.flowerPosition = this.flowerPosition.filter(p -> this.method_37908().method_8320(p).method_26164(class_3481.field_20339)).or(() -> class_2338.method_25998((class_2338)this.method_24515(), (int)10, (int)10, (int)10).filter(p -> !this.visited.containsKey(p) && this.method_37908().method_8320(p).method_26164(class_3481.field_20339)).findFirst().map(p -> {
            this.visited.put((class_2338)p, (long)this.field_6012 - 900L);
            return p;
        }));
        return this.flowerPosition;
    }

    private void moveTowards(class_2338 pos) {
        class_243 motion = class_243.method_26410((class_2382)pos, (double)0.1).method_1020(this.method_19538());
        class_243 vel = this.method_18798();
        this.method_5762((Math.signum(motion.method_10216()) * 0.5 - vel.field_1352) * 0.1, (Math.signum(motion.method_10214()) * 0.7 - vel.field_1351) * 0.1, (Math.signum(motion.method_10215()) * 0.5 - vel.field_1350) * 0.1);
        float direction = (float)(class_3532.method_15349((double)vel.field_1350, (double)vel.field_1352) * 57.29577951308232) - 90.0f;
        this.field_6250 = 0.5f;
        this.field_6241 += class_3532.method_15393((float)(direction - this.field_6241));
    }

    public boolean method_5640(double distance) {
        double d = 64.0 * ButterflyEntity.method_5824();
        return distance < d * d;
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 cause) {
        return false;
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public boolean method_5979(class_1936 world, class_3730 reason) {
        return reason != class_3730.field_16459 || this.method_23318() >= (double)world.method_8615() && world.method_22339(this.method_24515()) > 3;
    }

    public class_1542 method_5699(class_1799 stack, float yOffset) {
        return super.method_5699(BufferflyVariantComponent.set(stack, new BufferflyVariantComponent(this.getVariant(), true)), yOffset);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("ticksResting", this.ticksResting);
        nbt.method_10569("breedingCooldown", this.breedingCooldown);
        this.hoveringPosition.ifPresent(pos -> nbt.method_10566("hoveringPosition", NbtSerialisable.encode(class_2338.field_25064, pos, (class_7225.class_7874)this.method_56673())));
        this.flowerPosition.ifPresent(pos -> nbt.method_10566("flowerPosition", NbtSerialisable.encode(class_2338.field_25064, pos, (class_7225.class_7874)this.method_56673())));
        class_2487 visited = new class_2487();
        this.visited.forEach((pos, time) -> visited.method_10544(String.valueOf(pos.method_10063()), time.longValue()));
        nbt.method_10566("visited", (class_2520)visited);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.ticksResting = nbt.method_10550("ticksResting");
        this.breedingCooldown = nbt.method_10550("breedingCooldown");
        this.hoveringPosition = NbtSerialisable.decode(class_2338.field_25064, nbt.method_10580("hoveringPosition"), (class_7225.class_7874)this.method_56673());
        this.flowerPosition = NbtSerialisable.decode(class_2338.field_25064, nbt.method_10580("flowerPosition"), (class_7225.class_7874)this.method_56673());
        class_2487 visited = nbt.method_10562("visited");
        this.visited.clear();
        visited.method_10541().forEach(key -> {
            try {
                this.visited.put(class_2338.method_10092((long)Long.valueOf(key)), visited.method_10537(key));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public static enum Variant implements class_3542
    {
        BUTTERFLY,
        YELLOW,
        LIME,
        RED,
        GREEN,
        BLUE,
        PURPLE,
        MAGENTA,
        PINK,
        HEDYLIDAE,
        LYCAENIDAE,
        NYMPHALIDAE,
        MONARCH,
        WHITE_MONARCH,
        BRIMSTONE;

        public static final Variant[] VALUES;
        public static final Codec<Variant> CODEC;
        public static final class_9139<ByteBuf, Variant> PACKET_CODEC;
        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final class_2960 skin = Unicopia.id("textures/entity/butterfly/" + this.name + ".png");

        public class_2960 getSkin() {
            return this.skin;
        }

        public static Variant byId(int index) {
            return VALUES[Math.max(0, index) % VALUES.length];
        }

        static Variant random(class_5819 rand) {
            return VALUES[rand.method_43048(VALUES.length)];
        }

        public String method_15434() {
            return this.name;
        }

        static {
            VALUES = Variant.values();
            CODEC = class_3542.method_28140(Variant::values);
            PACKET_CODEC = class_9135.method_56375(i -> VALUES[i], Enum::ordinal);
        }
    }
}

