/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.minelittlepony.unicopia.entity.damage.UDamageSources;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1702;

public interface ManaConsumptionUtil {
    public static final float MANA_PER_FOOD = 10.0f;
    public static final float HEARTS_PER_FOOD = 0.5f;
    public static final float SATURATION_PER_FOOD = 0.8f;

    public static float consumeMana(MagicReserves.Bar mana, double foodSubtract) {
        if (foodSubtract <= 0.0) {
            return 0.0f;
        }
        float consumedMana = (float)foodSubtract * 10.0f;
        float availableMana = mana.get();
        if (consumedMana <= availableMana) {
            mana.set(availableMana - consumedMana);
            return 0.0f;
        }
        mana.set(0.0f);
        return (float)foodSubtract - availableMana / 10.0f;
    }

    public static float burnFood(class_1657 entity, float foodSubtract) {
        int availableFood;
        class_1702 hunger = entity.method_7344();
        if (foodSubtract <= 0.0f) {
            return 0.0f;
        }
        float availableSaturation = hunger.method_7589();
        if (availableSaturation > 0.0f && foodSubtract > 0.0f) {
            float consumedSaturation = Math.min(foodSubtract * 0.8f, availableSaturation);
            foodSubtract = ManaConsumptionUtil.addExhaustion(hunger, foodSubtract);
            if (consumedSaturation > 0.0f) {
                foodSubtract -= consumedSaturation / 0.8f;
                hunger.method_7581(availableSaturation - consumedSaturation);
            }
        }
        if ((availableFood = hunger.method_7586()) > 0 && foodSubtract > 0.0f) {
            int consumedFood = Math.min((int)Math.floor(foodSubtract), availableFood);
            foodSubtract = ManaConsumptionUtil.addExhaustion(hunger, foodSubtract);
            if (consumedFood > 0) {
                foodSubtract -= (float)consumedFood;
                hunger.method_7585(-consumedFood, 0.3f);
            }
        }
        float availableHearts = entity.method_6032();
        if (foodSubtract > 0.0f) {
            float consumedHearts = Math.max(0.0f, Math.min(availableHearts - 1.0f, foodSubtract * 0.5f));
            foodSubtract = ManaConsumptionUtil.addExhaustion(hunger, foodSubtract);
            foodSubtract -= consumedHearts / 0.5f;
            if (consumedHearts > 0.0f) {
                entity.method_5643((class_1282)UDamageSources.of(entity.method_37908()).damageOf(UDamageTypes.EXHAUSTION), consumedHearts);
            }
        }
        return Math.max(0.0f, foodSubtract);
    }

    public static float getCombinedTotalMana(Pony pony) {
        class_1702 hunger = ((class_1657)pony.asEntity()).method_7344();
        return (float)hunger.method_7586() + pony.getMagicalReserves().getMana().get() / 10.0f + hunger.method_7589() / 0.8f + (((class_1657)pony.asEntity()).method_6032() - 1.0f) / 0.5f;
    }

    public static float addExhaustion(class_1702 hunger, float foodSubtract) {
        hunger.method_7583(0.1f);
        return Math.max(0.0f, foodSubtract - 0.1f);
    }

    public static interface FloatConsumer {
        public void accept(float var1);
    }

    public static interface FloatSupplier {
        public float get();
    }
}

