/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.google.common.collect.Streams;
import com.minelittlepony.common.util.animation.Interpolator;
import com.minelittlepony.common.util.animation.LinearInterpolator;
import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.AbilityDispatcher;
import com.minelittlepony.unicopia.ability.EarthPonyStompAbility;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.SpellSlots;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.RageAbilitySpell;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.TraitDiscovery;
import com.minelittlepony.unicopia.advancement.TriggerCountTracker;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.diet.PonyDiets;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.Trap;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import com.minelittlepony.unicopia.entity.effect.MetamorphosisStatusEffect;
import com.minelittlepony.unicopia.entity.effect.SeaponyGraceStatusEffect;
import com.minelittlepony.unicopia.entity.effect.SunBlindnessStatusEffect;
import com.minelittlepony.unicopia.entity.effect.UEffects;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.entity.player.Acrobatics;
import com.minelittlepony.unicopia.entity.player.CorruptionHandler;
import com.minelittlepony.unicopia.entity.player.LevitatedItemsInventory;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.ManaConsumptionUtil;
import com.minelittlepony.unicopia.entity.player.ManaContainer;
import com.minelittlepony.unicopia.entity.player.Motion;
import com.minelittlepony.unicopia.entity.player.PlayerAttributes;
import com.minelittlepony.unicopia.entity.player.PlayerCamera;
import com.minelittlepony.unicopia.entity.player.PlayerCameraImpl;
import com.minelittlepony.unicopia.entity.player.PlayerCharmTracker;
import com.minelittlepony.unicopia.entity.player.PlayerLevelStore;
import com.minelittlepony.unicopia.entity.player.PlayerPhysics;
import com.minelittlepony.unicopia.entity.player.SkinFeatures;
import com.minelittlepony.unicopia.item.ForageableItem;
import com.minelittlepony.unicopia.item.FriendshipBraceletItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.item.enchantment.UEnchantments;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgPlayerAnimationChange;
import com.minelittlepony.unicopia.network.MsgPlayerCapabilities;
import com.minelittlepony.unicopia.network.MsgPlayerTargetEntity;
import com.minelittlepony.unicopia.network.MsgTribeSelect;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.server.world.UGameRules;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.MeteorlogicalUtil;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Pony
extends Living<class_1657>
implements Copyable<Pony>,
SpellSlots.UpdateCallback {
    static final int INITIAL_SUN_IMMUNITY = 20;
    private final AbilityDispatcher powers = new AbilityDispatcher(this);
    private final PlayerPhysics gravity = this.addTicker(new PlayerPhysics(this, this.tracker));
    private final PlayerCharmTracker charms = new PlayerCharmTracker(this);
    private final PlayerCamera camera = new PlayerCameraImpl(this);
    private final TraitDiscovery discoveries = new TraitDiscovery(this);
    private final Acrobatics acrobatics = new Acrobatics(this, this.tracker);
    private final LevitatedItemsInventory levitatingItems = this.addTicker(new LevitatedItemsInventory(this));
    private final CorruptionHandler corruptionHandler = new CorruptionHandler(this);
    private TriggerCountTracker advancementProgress = new TriggerCountTracker(Map.of());
    private final ManaContainer mana;
    private final PlayerLevelStore levels;
    private final PlayerLevelStore corruption;
    private final Interpolator interpolator = new LinearInterpolator();
    private Race.Composite compositeRace = Race.UNSET.composite();
    private Race respawnRace = Race.UNSET;
    private float magicExhaustion = 0.0f;
    private int ticksInvulnerable;
    private int ticksMetamorphising;
    private int ticksInSun;
    private boolean hasShades;
    private int ticksSunImmunity = 20;
    private PlayerPoser.AnimationInstance animation = PlayerPoser.AnimationInstance.NONE;
    private int animationMaxDuration;
    private int animationDuration;
    private final DataTracker.Entry<Race> race;
    private final DataTracker.Entry<Race> suppressedRace;
    @Nullable
    private Race effectiveRace;
    private Optional<Race> prevMorphedRace = Optional.empty();
    private final DataTracker.Entry<SkinFeatures> features;
    @Nullable
    private class_1297 lookedAtEntity;
    private int ticksUntilLookTimeout;

    public Pony(class_1657 player) {
        super(player);
        this.trackers.addPacketEmitter((sender, initial) -> {
            if (initial) {
                sender.accept(Channel.SERVER_PLAYER_CAPABILITIES.toPacket((Object)new MsgPlayerCapabilities(this, initial)));
            }
        });
        this.race = this.tracker.startTracking(TrackableDataType.RACE, Race.UNSET);
        this.suppressedRace = this.tracker.startTracking(TrackableDataType.RACE, Race.UNSET);
        this.features = this.tracker.startTracking(TrackableDataType.SKIN_FEATURES, SkinFeatures.DEFAULT);
        this.levels = new PlayerLevelStore(this, this.tracker, true, USounds.Vanilla.field_14709);
        this.corruption = new PlayerLevelStore(this, this.tracker, false, USounds.ENTITY_PLAYER_CORRUPTION);
        this.mana = this.addTicker(new ManaContainer(this, this.tracker));
        this.addTicker(this::updateAnimations);
        this.addTicker(this::updateBatPonyAbilities);
        this.addTicker(this::updateCorruptionDecay);
        this.addTicker(new PlayerAttributes(this));
        this.addTicker(this.corruptionHandler);
    }

    public void sendUpdatePacket() {
        if (this.entity instanceof class_3222) {
            Channel.SERVER_PLAYER_CAPABILITIES.sendToAllPlayers((Object)new MsgPlayerCapabilities(this, false), ((class_1657)this.entity).method_37908());
        }
    }

    public void sendUpdateToPlayer() {
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_3222) {
            class_3222 pl = (class_3222)class_13092;
            Channel.SERVER_PLAYER_CAPABILITIES.sendToPlayer((Object)new MsgPlayerCapabilities(this, false), pl);
        }
    }

    public static void registerAttributes(class_5132.class_5133 builder) {
        builder.method_26867(UEntityAttributes.EXTRA_MINING_SPEED);
        builder.method_26867(UEntityAttributes.ENTITY_GRAVITY_MODIFIER);
    }

    @Deprecated
    public void setAnimation(PlayerPoser.Animation animation) {
        this.setAnimation(new PlayerPoser.AnimationInstance(animation, PlayerPoser.Animation.Recipient.ANYONE));
    }

    @Deprecated
    public void setAnimation(PlayerPoser.Animation animation, int duration) {
        this.setAnimation(new PlayerPoser.AnimationInstance(animation, PlayerPoser.Animation.Recipient.ANYONE));
    }

    public void setAnimation(PlayerPoser.Animation animation, PlayerPoser.Animation.Recipient recipient) {
        if (this.getAnimation().isOf(animation) && this.animationDuration > 0) {
            return;
        }
        this.setAnimation(new PlayerPoser.AnimationInstance(animation, recipient), animation.getDuration());
    }

    public void setAnimation(PlayerPoser.Animation animation, PlayerPoser.Animation.Recipient recipient, int duration) {
        if (this.getAnimation().isOf(animation) && this.animationDuration > 0) {
            return;
        }
        this.setAnimation(new PlayerPoser.AnimationInstance(animation, recipient), duration);
    }

    public void setAnimation(PlayerPoser.AnimationInstance animation) {
        this.setAnimation(animation, animation.animation().getDuration());
    }

    public void setAnimation(PlayerPoser.AnimationInstance animation, int duration) {
        if (!animation.equals(this.animation) || duration != this.animationDuration) {
            this.animation = animation;
            this.animationMaxDuration = this.animationDuration = animation.isOf(PlayerPoser.Animation.NONE) ? 0 : Math.max(0, duration);
            if (!this.isClient()) {
                Channel.SERVER_PLAYER_ANIMATION_CHANGE.sendToAllPlayers((Object)new MsgPlayerAnimationChange(this, animation, this.animationDuration), this.asWorld());
            }
            animation.animation().getSound().ifPresent(sound -> this.playSound((class_3414)sound, sound == USounds.ENTITY_PLAYER_WOLOLO ? 0.1f : 0.9f, 1.0f));
            this.sendUpdatePacket();
        }
    }

    public PlayerPoser.AnimationInstance getAnimation() {
        return this.animation;
    }

    public float getAnimationProgress(float delta) {
        if (this.animation.isOf(PlayerPoser.Animation.NONE)) {
            return 0.0f;
        }
        return 1.0f - (float)this.animationDuration / (float)this.animationMaxDuration;
    }

    public TriggerCountTracker getAdvancementProgress() {
        return this.advancementProgress;
    }

    public LevitatedItemsInventory getLevitatingItems() {
        return this.levitatingItems;
    }

    public SkinFeatures getSkinFeatures() {
        return this.features.get();
    }

    public void setSkinFeatures(SkinFeatures features) {
        if (!this.getSkinFeatures().equals(features)) {
            this.features.set(features);
            if (this.isClient()) {
                Channel.UPDATE_PLAYER_FEATURES.sendToServer((Object)features);
            }
        }
    }

    public void setLookedEntity(class_1297 target) {
        if (this.lookedAtEntity != target) {
            this.lookedAtEntity = target;
            this.ticksUntilLookTimeout = 10;
            MsgPlayerTargetEntity packet = new MsgPlayerTargetEntity(target == null ? Optional.empty() : Optional.of(target.method_5628()), Optional.empty(), Optional.empty());
            if (this.isClient()) {
                Channel.CLIENT_PLAYER_LOOK_AT_ENTITY.sendToServer((Object)packet);
            } else if (this.lookedAtEntity == null) {
                Channel.SERVER_PLAYER_LOOK_AT_ENTITY.sendToPlayer((Object)packet, (class_3222)this.entity);
            }
        } else if (target != null) {
            this.ticksUntilLookTimeout = 10;
        }
    }

    public boolean isLookingAt(class_1297 target) {
        return this.lookedAtEntity != null && this.lookedAtEntity == target;
    }

    public void setRespawnRace(Race race) {
        this.respawnRace = race;
    }

    @Override
    public Race getSpecies() {
        if (this.effectiveRace == null) {
            this.effectiveRace = MetamorphosisStatusEffect.getEffectiveRace(this.entity).orElse(this.getPersistentSpecies());
        }
        return this.effectiveRace;
    }

    public Race getPersistentSpecies() {
        return this.race.get();
    }

    @Override
    public Race.Composite getCompositeRace() {
        return this.compositeRace;
    }

    @Override
    public boolean collidesWithClouds() {
        return this.getCompositeRace().canInteractWithClouds() || ((class_1657)this.entity).method_7337();
    }

    @Override
    public void setSpecies(Race race) {
        race = race.validate((class_1657)this.entity);
        Race current = this.getPersistentSpecies();
        this.race.set(race);
        if (race != current) {
            this.clearSuppressedRace();
        }
        this.effectiveRace = null;
        this.ticksInSun = 0;
        if (!race.canCast()) {
            this.levitatingItems.dropEverything();
        }
        this.gravity.updateFlightState();
        ((class_1657)this.entity).method_7355();
        this.recalculateCompositeRace();
    }

    public void setSuppressedRace(Race race) {
        this.suppressedRace.set(race.validate((class_1657)this.entity));
    }

    public void clearSuppressedRace() {
        this.setSuppressedRace(Race.UNSET);
    }

    public Race getSuppressedRace() {
        return this.suppressedRace.get();
    }

    public TraitDiscovery getDiscoveries() {
        return this.discoveries;
    }

    public MagicReserves getMagicalReserves() {
        return this.mana;
    }

    public PlayerCharmTracker getCharms() {
        return this.charms;
    }

    public Acrobatics getAcrobatics() {
        return this.acrobatics;
    }

    @Override
    public Levelled.LevelStore getLevel() {
        return this.levels;
    }

    @Override
    public Levelled.LevelStore getCorruption() {
        return this.corruption;
    }

    public CorruptionHandler getCorruptionhandler() {
        return this.corruptionHandler;
    }

    public boolean canUseSuperMove() {
        return ((class_1657)this.entity).method_7337() || this.getMagicalReserves().getCharge().get() >= this.getMagicalReserves().getCharge().getMax();
    }

    public boolean consumeSuperMove() {
        if (this.canUseSuperMove()) {
            MagicReserves.Bar charge = this.getMagicalReserves().getCharge();
            charge.set(charge.get() - charge.getMax());
            return true;
        }
        return false;
    }

    public boolean isSunImmune() {
        return this.ticksSunImmunity > 0;
    }

    public void setInvulnerabilityTicks(int ticks) {
        this.ticksInvulnerable = Math.max(0, ticks);
    }

    public int getTicksMetamorphising() {
        return this.ticksMetamorphising;
    }

    public void setTicksmetamorphising(int ticks) {
        this.ticksMetamorphising = ticks;
    }

    @Override
    public Affinity getAffinity() {
        return this.getSpecies().getAffinity();
    }

    public AbilityDispatcher getAbilities() {
        return this.powers;
    }

    @Override
    public PlayerPhysics getPhysics() {
        return this.gravity;
    }

    public float getBlockBreakingSpeed() {
        return (float)((class_1657)this.entity).method_5996(UEntityAttributes.EXTRA_MINING_SPEED).method_6194();
    }

    public Motion getMotion() {
        return this.gravity;
    }

    public PlayerCamera getCamera() {
        return this.camera;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public final class_1309 getMaster() {
        return this.asEntity();
    }

    @Override
    public Optional<UUID> getMasterId() {
        return Optional.of(((class_1657)this.asEntity()).method_5667());
    }

    public void forceRespawnOnRaceChange() {
        class_2338 respawnPos;
        if (this.isSpawnInvalid(this.getOrigin()) && !this.isSpawnInvalid(respawnPos = ((class_1657)this.entity).method_14245((class_3218)this.asWorld(), this.getOrigin()))) {
            class_243 pos = respawnPos.method_61082();
            ((class_1657)this.entity).method_30634(pos.field_1352, pos.field_1351, pos.field_1350);
        }
        this.onSpawn();
    }

    public void onSpawn() {
        Race suppressedRace;
        if (this.isSpawnInvalid(this.getOrigin()) && (suppressedRace = this.getSuppressedRace()) != Race.UNSET) {
            this.setSpecies(suppressedRace);
        }
        this.ticksSunImmunity = 20;
        this.sendUpdatePacket();
    }

    public boolean isSpawnInvalid(class_2338 pos) {
        class_3218 sw;
        class_1937 class_19372 = ((class_1657)this.entity).method_37908();
        return class_19372 instanceof class_3218 && (sw = (class_3218)class_19372).method_8597().comp_642() && sw.method_8503().method_27728().method_210() != class_1934.field_9216 && (this.getCompositeRace().includes(Race.BAT) && MeteorlogicalUtil.isPositionExposedToSun(this.asWorld(), pos) || this.getCompositeRace().includes(Race.SEAPONY) && !this.asWorld().method_8316(pos).method_15767(class_3486.field_15517));
    }

    @Override
    public boolean beforeUpdate() {
        if (this.compositeRace.includes(Race.UNSET) || ((class_1657)this.entity).field_6012 % 2 == 0) {
            this.recalculateCompositeRace();
        }
        if (this.ticksInvulnerable > 0) {
            ((class_1657)this.entity).method_5684(--this.ticksInvulnerable > 0);
        }
        if (this.isClient() && ((class_1657)this.entity).method_5765() && ((class_1657)this.entity).method_5715()) {
            Trap trap;
            @Nullable class_1297 vehicle = ((class_1657)this.entity).method_5854();
            if (vehicle instanceof Trap) {
                ((class_1657)this.entity).method_5660(false);
            }
            if (vehicle != null && (!(vehicle instanceof Trap) || (trap = (Trap)vehicle).attemptDismount((class_1297)this.entity))) {
                this.setCarrier((UUID)null);
                ((class_1657)this.entity).method_5848();
                ((class_1657)this.entity).method_29495(vehicle.method_19538());
                Living.transmitPassengers(vehicle);
            }
        }
        this.magicExhaustion = ManaConsumptionUtil.burnFood((class_1657)this.entity, this.magicExhaustion);
        this.powers.tick();
        this.acrobatics.tick();
        SeaponyGraceStatusEffect.update(this.entity);
        if (this.getObservedSpecies() == Race.KIRIN) {
            MagicReserves.Bar energy;
            MagicReserves.Bar charge = this.getMagicalReserves().getCharge();
            if (((class_1657)this.entity).method_5799() || ((class_1657)this.entity).method_32314()) {
                charge.multiply(0.5f);
            }
            if (charge.getPercentFill() >= 1.0f && (energy = this.getMagicalReserves().getEnergy()).getPercentFill() < 0.002f) {
                energy.addPercent(1.03f);
                if (((class_1657)this.entity).field_6012 % 25 == 0) {
                    this.playSound(USounds.ENTITY_PLAYER_HEARTBEAT, 0.17f + (float)((class_1657)this.entity).method_37908().field_9229.method_43059() * 0.03f, 0.5f);
                    this.spawnParticles((class_2394)class_2398.field_11239, 2);
                    energy.addPercent(1.07f);
                }
            }
            if (((class_1657)this.entity).method_6083() == 0 && !EquinePredicates.RAGING.test((class_1297)this.entity) && charge.getPercentFill() >= 1.0f && ((class_1657)this.entity).method_37908().field_9229.method_43048(1000) == 0) {
                SpellType.RAGE.withTraits().apply(this, CastingMethod.INNATE);
            }
        }
        if (this.getCompositeRace().includes(Race.SEAPONY)) {
            if (((class_1657)this.entity).method_5869()) {
                if (((class_1657)this.entity).method_18798().method_1027() > 0.02) {
                    this.spawnParticles((class_2394)class_2398.field_11247, 4);
                }
            } else {
                if (((class_1657)this.entity).method_5669() == ((class_1657)this.entity).method_5748()) {
                    ((class_1657)this.entity).method_5855(((class_1657)this.entity).method_5669() - 1);
                }
                if (((class_1657)this.entity).field_6012 % 60 == 0) {
                    ((class_1657)this.entity).method_5783(class_3417.field_14722, 1.0f, 1.0f);
                }
                if (((class_1657)this.entity).method_5669() == -20) {
                    ((class_1657)this.entity).method_5855(0);
                    ((class_1657)this.entity).method_5643(((class_1657)this.entity).method_48923().method_48834(), 2.0f);
                }
            }
        }
        if (this.ticksUntilLookTimeout > 0 && this.isClient() && --this.ticksUntilLookTimeout <= 0) {
            this.setLookedEntity(null);
        }
        return super.beforeUpdate();
    }

    @Override
    public void onAttacking(class_1297 target) {
        if (this.getObservedSpecies() == Race.KIRIN) {
            class_1309 l;
            boolean killedTarget;
            boolean bl = killedTarget = target instanceof class_1309 && (l = (class_1309)target).method_29504();
            if (killedTarget || ((class_1657)this.entity).method_37908().field_9229.method_43048(10) == 0) {
                MagicReserves.Bar charge = this.getMagicalReserves().getCharge();
                if (charge.getPercentFill() < 1.0f) {
                    class_1309 l2;
                    charge.addPercent(killedTarget ? (target instanceof class_1309 && (l2 = (class_1309)target).method_6109() ? 15 : 10) : 3);
                }
                if (!EquinePredicates.RAGING.test((class_1297)this.entity) && charge.getPercentFill() >= 1.0f && ((class_1657)this.entity).method_37908().field_9229.method_43048(1000) == 0) {
                    SpellType.RAGE.withTraits().apply(this, CastingMethod.INNATE);
                }
            }
        }
    }

    private void recalculateCompositeRace() {
        Race intrinsicRace = this.getPersistentSpecies();
        Race suppressedRace = this.getSuppressedRace();
        Optional<Race> morphedRace = MetamorphosisStatusEffect.getEffectiveRace(this.entity);
        this.effectiveRace = morphedRace.orElse(intrinsicRace);
        this.compositeRace = morphedRace.orElseGet(() -> this.getSpellSlot().get(SpellPredicate.IS_MIMIC).map(AbstractDisguiseSpell::getDisguise).map(EntityAppearance::getAppearance).flatMap(Pony::of).map(Pony::getSpecies).orElse(intrinsicRace)).composite(AmuletSelectors.UNICORN_AMULET.test(this.entity) ? Race.UNICORN : (AmuletSelectors.ALICORN_AMULET.test(this.entity) ? Race.ALICORN : null), AmuletSelectors.PEARL_NECKLACE.test(this.entity) ? suppressedRace.or(Race.SEAPONY) : null);
        UCriteria.PLAYER_CHANGE_RACE.trigger((class_1657)this.entity);
        if (this.prevMorphedRace.isPresent() && morphedRace.isEmpty()) {
            ParticleUtils.spawnParticles(new MagicParticleEffect(8941327), (class_1297)this.entity, 50);
            ((class_1657)this.entity).method_37908().method_43128(null, ((class_1657)this.entity).method_23317(), ((class_1657)this.entity).method_23318(), ((class_1657)this.entity).method_23321(), USounds.ENTITY_PLAYER_CHANGELING_TRANSFORM, ((class_1657)this.entity).method_5634(), 1.0f, 1.0f);
        }
        this.prevMorphedRace = morphedRace;
    }

    @Override
    public Optional<class_2338> chooseClimbingPos() {
        if (this.getObservedSpecies() == Race.CHANGELING && this.getSpellSlot().get(SpellPredicate.IS_DISGUISE).isEmpty() && (this.acrobatics.isFaceClimbable(((class_1657)this.entity).method_37908(), ((class_1657)this.entity).method_24515(), ((class_1657)this.entity).method_5735()) || this.acrobatics.canHangAt(((class_1657)this.entity).method_24515()))) {
            return Optional.of(((class_1657)this.entity).method_24515());
        }
        return super.chooseClimbingPos();
    }

    private void updateAnimations() {
        if (this.acrobatics.distanceClimbed > 0.0 && (this.animation.isOf(PlayerPoser.Animation.CLIMB) && ((class_1657)this.entity).method_5715() || this.animation.isOf(PlayerPoser.Animation.HANG)) && ((class_1657)this.entity).method_24832().isPresent() && ((class_1657)this.entity).method_18798().method_1033() < (double)0.08f) {
            if (this.animation.renderBothArms()) {
                this.animationDuration = 2;
            }
            return;
        }
        if (this.animationDuration <= 0 || --this.animationDuration <= 0) {
            if (this.animation.renderBothArms() && this.acrobatics.distanceClimbed > 0.0) {
                return;
            }
            if (!this.getAnimation().isOf(PlayerPoser.Animation.NONE)) {
                this.setAnimation(PlayerPoser.AnimationInstance.NONE);
            }
        }
    }

    private void updateBatPonyAbilities() {
        if (this.ticksSunImmunity > 0) {
            --this.ticksSunImmunity;
        }
        if (this.getObservedSpecies() == Race.BAT && !((class_1657)this.entity).method_30230()) {
            boolean hasShades = TrinketsDelegate.getInstance(this.entity).getEquipped(this.entity, TrinketsDelegate.FACE).anyMatch(s -> s.stack().method_31573(UTags.Items.PROTECTS_BAT_PONY_EYES));
            if (!this.hasShades && hasShades && this.getObservedSpecies() == Race.BAT) {
                UCriteria.WEAR_SHADES.trigger((class_1297)this.entity);
            }
            this.hasShades = hasShades;
            if (!hasShades && this.ticksSunImmunity <= 0 && MeteorlogicalUtil.isLookingIntoSun(this.asWorld(), (class_1297)this.entity)) {
                if (!this.isClient()) {
                    ((class_1657)this.entity).method_6092(new class_1293(UEffects.SUN_BLINDNESS, 250, 2, true, false));
                    UCriteria.LOOK_INTO_SUN.trigger((class_1297)this.entity);
                } else if (this.isClientPlayer()) {
                    InteractionManager.getInstance().playLoopingSound((class_1297)this.entity, 0, ((class_1657)this.entity).method_5628());
                }
            }
            if (SunBlindnessStatusEffect.hasSunExposure(this.entity)) {
                if (this.ticksInSun < 200) {
                    ++this.ticksInSun;
                }
                if (this.ticksInSun == 1) {
                    if (!this.isClient()) {
                        ((class_1657)this.entity).method_6092(new class_1293(UEffects.SUN_BLINDNESS, 250, 1, true, false));
                    } else if (this.isClientPlayer()) {
                        InteractionManager.getInstance().playLoopingSound((class_1297)this.entity, 0, ((class_1657)this.entity).method_5628());
                    }
                }
            } else if (this.ticksInSun > 0) {
                --this.ticksInSun;
            }
        }
    }

    private void updateCorruptionDecay() {
    }

    @Override
    public void tick() {
        Race newRace;
        super.tick();
        Race currentRace = this.getPersistentSpecies();
        if (!currentRace.isUnset() && (newRace = currentRace.validate((class_1657)this.entity)) != currentRace) {
            this.setSpecies(newRace);
        }
    }

    @Override
    public boolean canBeSeenBy(class_1297 entity) {
        if (entity instanceof class_1588) {
            class_1588 hostile = (class_1588)entity;
            if (this.getObservedSpecies() == Race.BAT && hostile.method_5968() != this.entity && hostile.method_6065() != this.entity && entity.method_5739((class_1297)this.entity) > entity.method_17681()) {
                if (entity.method_5715() && entity.method_5739((class_1297)this.entity) > 4.0f) {
                    return false;
                }
                float vel = (float)this.getPhysics().getHorizontalMotion();
                float velocityScale = class_3532.method_15363((float)(vel * 15.0f), (float)0.0f, (float)1.0f);
                int light = this.asWorld().method_22339(this.getPhysics().getHeadPosition());
                float lightScale = (float)light / 15.0f;
                float approachFactor = (velocityScale + lightScale) / 2.0f;
                float f = entity.method_5715() ? 0.8f : 0.3f;
                if (approachFactor < f) {
                    return false;
                }
            }
        }
        return super.canBeSeenBy(entity);
    }

    @Override
    public Optional<class_243> adjustMovementSpeedInWater(class_243 speed) {
        if (this.getObservedSpecies() == Race.KIRIN) {
            return Optional.of(speed.method_18805(0.5, 1.0, 0.5));
        }
        if (this.getCompositeRace().includes(Race.SEAPONY)) {
            float factor = ((class_1657)this.entity).method_5681() ? 1.132f : 1.0232f;
            float max = 0.6f;
            return Optional.of(new class_243(class_3532.method_15350((double)(speed.field_1352 * (double)factor), (double)(-max), (double)max), speed.field_1351 * (speed.field_1351 > 0.0 ? 1.2 : 1.101), class_3532.method_15350((double)(speed.field_1350 * (double)factor), (double)(-max), (double)max)));
        }
        return Optional.empty();
    }

    public Optional<Living<?>> getEntityInArms() {
        return Living.getOrEmpty(((class_1657)this.entity).method_31483()).filter(Living::isBeingCarried);
    }

    @Override
    public boolean onUpdatePassengerPosition(class_1297 passender, class_1297.class_4738 positionUpdater) {
        class_1297 passenger = ((class_1657)this.entity).method_31483();
        if (Living.getOrEmpty(passenger).filter(Living::isBeingCarried).isPresent()) {
            class_243 carryPosition = new class_243(0.0, 0.0, (double)((class_1657)this.entity).method_17681());
            float leanAmount = ((LivingEntityDuck)this.entity).getLeaningPitch();
            carryPosition = carryPosition.method_1037(-leanAmount * (float)Math.PI / 4.0f).method_1019(new class_243(0.0, -0.5, 0.0).method_1021((double)leanAmount));
            carryPosition = carryPosition.method_1024(-((class_1657)this.entity).method_43078() * ((float)Math.PI / 180));
            carryPosition = ((class_1657)this.entity).method_19538().method_1019(carryPosition);
            positionUpdater.accept(passenger, carryPosition.field_1352, carryPosition.field_1351, carryPosition.field_1350);
            return true;
        }
        return false;
    }

    public int getImplicitEnchantmentLevel(class_6880<class_1887> enchantment, int initial) {
        if ((enchantment == class_1893.field_9105 || enchantment == class_1893.field_9128 || enchantment == class_1893.field_9114 || enchantment == class_1893.field_9100) && this.getCompositeRace().includes(Race.SEAPONY)) {
            return class_3532.method_15340((int)(initial + 3), (int)((class_1887)enchantment.comp_349()).method_8187(), (int)((class_1887)enchantment.comp_349()).method_8183());
        }
        return initial;
    }

    public Optional<Float> modifyDamage(class_1282 cause, float amount) {
        if (this.getObservedSpecies() == Race.KIRIN) {
            MagicReserves.Bar charge = this.getMagicalReserves().getCharge();
            charge.addPercent(class_3532.method_15363((float)(amount / 10.0f), (float)5.0f, (float)15.0f));
            float anger = charge.getPercentFill();
            this.getMagicalReserves().getEnergy().addPercent(50.0f * anger);
            this.playSound(USounds.ENTITY_PLAYER_KIRIN_RAGE, 0.2f, 1.25f);
            this.spawnParticles((class_2394)class_2398.field_11239, 2);
            if (anger > 0.0f && ((class_1657)this.entity).method_37908().field_9229.method_43057() < anger / 2.0f && this.consumeSuperMove()) {
                SpellType.RAGE.withTraits().apply(this, CastingMethod.INNATE);
            }
        }
        if (!(!EffectUtils.hasExtraDefenses(this.entity) || cause.method_48789(class_8103.field_43116) || cause.method_49708(class_8111.field_42349) || cause.method_48789(class_8103.field_42246) || cause.method_48789(class_8103.field_42242) || cause.method_49708(class_8111.field_42330) || cause.method_49708(class_8111.field_42354))) {
            return Optional.of(Float.valueOf(amount /= (float)((cause.method_49708(class_8111.field_42323) ? 3 : 2) * (((class_1657)this.entity).method_6032() < 5.0f ? 3 : 1))));
        }
        return Optional.empty();
    }

    public void onDropItem(class_1542 itemDropped) {
        Equine.of(itemDropped).ifPresent(eq -> {
            eq.setSpecies(this.getSpecies());
            eq.getPhysics().setBaseGravityModifier(this.gravity.getPersistantGravityModifier());
        });
    }

    @Override
    public float onImpact(float distance, float damageMultiplier, class_1282 cause) {
        double radius;
        distance = super.onImpact(distance, damageMultiplier, cause);
        if (EffectUtils.hasExtraDefenses(this.entity) && (radius = (double)(distance / 10.0f)) > 0.0) {
            EarthPonyStompAbility.spawnEffectAround(this, (class_1297)this.entity, ((class_1657)this.entity).method_23312(), radius, radius);
        }
        return distance;
    }

    @Override
    protected float getEffectiveFallDistance(float distance) {
        boolean extraProtection = this.getSpellSlot().get(SpellType.SHIELD).isPresent();
        if (!((class_1657)this.entity).method_7337() && !((class_1657)this.entity).method_7325()) {
            if (extraProtection) {
                distance /= this.getLevel().getScaled(3.0f) + 1.0f;
                if (((class_1657)this.entity).method_5715()) {
                    distance /= 2.0f;
                }
            }
            if (this.getCompositeRace().canFly() || EffectUtils.hasExtraDefenses(this.entity)) {
                distance -= 5.0f;
            }
        }
        return Math.max(0.0f, distance);
    }

    public class_4174 onEat(class_1799 stack, class_4174 food) {
        if (this.isClient()) {
            return food;
        }
        if (this.getObservedSpecies() == Race.KIRIN && (stack.method_31573(UTags.Items.COOLS_OFF_KIRINS) || stack.method_57824(class_9334.field_49651) == class_1844.field_49274)) {
            this.getMagicalReserves().getCharge().multiply(0.5f);
            this.getSpellSlot().get(SpellType.RAGE).ifPresent(RageAbilitySpell::setExtenguishing);
        }
        PonyDiets.getInstance().getEffects(stack, this).ailment().effects().afflict((class_1657)this.asEntity(), stack);
        return food;
    }

    public class_1269 interact(class_1268 hand, class_3965 hit) {
        class_1269 result;
        if (((class_1657)this.entity).method_21823() || ((class_1657)this.entity).method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 stack = ((class_1657)this.entity).method_5998(hand);
        if (stack.method_7960() && (result = this.levitatingItems.interact(hit)).method_23665()) {
            return class_1269.field_5812;
        }
        return ForageableItem.use((class_1657)this.entity, stack, ((class_1657)this.entity).method_37908(), hand, hit);
    }

    public class_1269 interact(class_1268 hand, class_1297 entity, @Nullable class_3966 hit) {
        class_1269 result;
        if (((class_1657)this.entity).method_21823() || ((class_1657)this.entity).method_7325()) {
            return class_1269.field_5811;
        }
        if (((class_1657)this.entity).method_5998(hand).method_7960() && (result = this.levitatingItems.interact(entity, hit)).method_23665()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 onStartedBreakingBlock(class_1268 hand, class_2338 pos, class_2350 direction) {
        if (hand == class_1268.field_5808 && !((class_1657)this.entity).method_7325()) {
            this.levitatingItems.startMining(((class_1657)this.entity).method_37908().method_8320(pos), pos, direction);
        }
        return class_1269.field_5811;
    }

    public class_1269 onStoppedBreakingBlock(class_2338 pos) {
        return class_1269.field_5811;
    }

    public class_1269 onAttackEntity(class_1268 hand, class_1297 entity, @Nullable class_3966 hit) {
        class_1269 result;
        if (((class_1657)this.entity).method_7325()) {
            return class_1269.field_5811;
        }
        if (((class_1657)this.entity).method_5998(hand).method_7960() && (result = this.levitatingItems.attack(entity, hit)).method_23665()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void onKill(class_1297 killedEntity, class_1282 damage) {
        if (killedEntity != null && killedEntity.method_5864() == class_1299.field_6078 && this.getPhysics().isFlying()) {
            UCriteria.KILL_PHANTOM_WHILE_FLYING.trigger((class_1297)this.entity);
        }
    }

    @Override
    public boolean subtractEnergyCost(double foodSubtract) {
        List<Pony> partyMembers;
        if (this.getSpellSlot().get(SpellPredicate.IS_CORRUPTING).isPresent()) {
            int corruptionTaken = (int)(foodSubtract * (double)(AmuletSelectors.ALICORN_AMULET.test(this.entity) ? 0.9f : 0.5f));
            foodSubtract -= (double)corruptionTaken;
            this.getCorruption().add(corruptionTaken);
        }
        if (!(partyMembers = FriendshipBraceletItem.getPartyMembers(this, 10.0).toList()).isEmpty()) {
            foodSubtract /= (double)(partyMembers.size() + 1);
            for (Pony member : partyMembers) {
                member.directTakeEnergy(foodSubtract);
            }
        }
        this.directTakeEnergy(foodSubtract);
        return ((class_1657)this.entity).method_7337() || ((class_1657)this.entity).method_6032() > 1.0f && this.mana.getMana().getPercentFill() > 0.1f;
    }

    protected void directTakeEnergy(double foodSubtract) {
        if (!((class_1657)this.entity).method_7337() && !((class_1657)this.entity).method_37908().field_9236) {
            this.magicExhaustion += ManaConsumptionUtil.consumeMana(this.mana.getMana(), foodSubtract);
        }
    }

    @Override
    protected Stream<class_1799> getInventoryStacks() {
        return Streams.concat((Stream[])new Stream[]{super.getInventoryStacks(), ((class_1657)this.entity).method_31548().field_7547.stream()});
    }

    @Override
    protected void giveBackItem(class_1799 stack) {
        if (!((class_1657)this.entity).method_7270(stack)) {
            ((class_1657)this.entity).method_7328(stack, false);
        }
    }

    public Optional<class_2561> trySleep(class_2338 pos) {
        if (AmuletSelectors.ALICORN_AMULET.test(this.entity)) {
            return Optional.of(class_2561.method_43471((String)"block.unicopia.bed.not_tired"));
        }
        return this.findAllSpellsInRange(10.0).filter(p -> p instanceof Pony && ((Pony)p).isEnemy(this)).findFirst().map(p -> class_2561.method_43471((String)"block.unicopia.bed.not_safe"));
    }

    public class_1269 canSleepNow() {
        if (this.asWorld().method_8450().method_8355(UGameRules.DO_NOCTURNAL_BAT_PONIES) && this.getSpecies().isNocturnal()) {
            return this.asWorld().method_8530() || this.asWorld().method_8594() >= 4 ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean isEnemy(Affine other) {
        return this.getArmour().contains((class_1935)UItems.ALICORN_AMULET) || super.isEnemy(other);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10566("mana", (class_2520)this.mana.toNBT(lookup));
        compound.method_10569("levels", this.levels.get());
        compound.method_10569("corruption", this.corruption.get());
        compound.method_10566("advancementTriggerCounts", NbtSerialisable.encode(TriggerCountTracker.CODEC, this.advancementProgress, lookup));
        compound.method_10566("levitatingItems", (class_2520)this.levitatingItems.toNBT(lookup));
        super.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.levels.set(compound.method_10550("levels"));
        this.corruption.set(compound.method_10550("corruption"));
        this.mana.fromNBT(compound.method_10562("mana"), lookup);
        this.levitatingItems.fromNBT(compound.method_10562("levitatingItems"), lookup);
        this.advancementProgress = NbtSerialisable.decode(TriggerCountTracker.CODEC, compound.method_10580("advancementTriggerCounts"), lookup).orElseGet(() -> new TriggerCountTracker(Map.of()));
        super.fromNBT(compound, lookup);
    }

    @Override
    public void toSyncronisedNbt(class_2487 compound, class_7225.class_7874 lookup) {
        super.toSyncronisedNbt(compound, lookup);
        compound.method_10582("playerSpecies", Race.REGISTRY.method_10221((Object)this.getPersistentSpecies()).toString());
        compound.method_10582("suppressedSpecies", Race.REGISTRY.method_10221((Object)this.getSuppressedRace()).toString());
        compound.method_10548("magicExhaustion", this.magicExhaustion);
        compound.method_10569("ticksInSun", this.ticksInSun);
        compound.method_10556("hasShades", this.hasShades);
        compound.method_10566("acrobatics", (class_2520)this.acrobatics.toNBT(lookup));
        compound.method_10566("powers", (class_2520)this.powers.toNBT(lookup));
        compound.method_10566("gravity", (class_2520)this.gravity.toNBT(lookup));
        compound.method_10566("charms", (class_2520)this.charms.toNBT(lookup));
        compound.method_10566("discoveries", (class_2520)this.discoveries.toNBT(lookup));
        compound.method_10569("ticksInvulnerable", this.ticksInvulnerable);
        compound.method_10569("ticksMetamorphising", this.ticksMetamorphising);
    }

    @Override
    public void fromSynchronizedNbt(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromSynchronizedNbt(compound, lookup);
        this.setSpecies(Race.fromName(compound.method_10558("playerSpecies"), Race.HUMAN));
        this.setSuppressedRace(Race.fromName(compound.method_10558("suppressedSpecies"), Race.UNSET));
        this.powers.fromNBT(compound.method_10562("powers"), lookup);
        this.gravity.fromNBT(compound.method_10562("gravity"), lookup);
        this.charms.fromNBT(compound.method_10562("charms"), lookup);
        this.discoveries.fromNBT(compound.method_10562("discoveries"), lookup);
        this.acrobatics.fromNBT(compound.method_10562("acrobatics"), lookup);
        this.magicExhaustion = compound.method_10583("magicExhaustion");
        this.ticksInvulnerable = compound.method_10550("ticksInvulnerable");
        this.ticksInSun = compound.method_10550("ticksInSun");
        this.hasShades = compound.method_10577("hasShades");
        this.ticksMetamorphising = compound.method_10550("ticksMetamorphising");
    }

    @Override
    public void copyFrom(Pony oldPlayer, boolean alive) {
        Race newRace;
        boolean forcedSwap = !alive && this.entity instanceof class_3222 && ((class_1657)this.entity).method_37908().method_8450().method_8355(UGameRules.SWAP_TRIBE_ON_DEATH) && oldPlayer.respawnRace.isUnset() || oldPlayer.getPersistentSpecies().isUnset();
        Race oldSuppressedRace = oldPlayer.getSuppressedRace();
        Race race = newRace = oldPlayer.respawnRace != Race.UNSET && !alive ? oldPlayer.respawnRace : oldPlayer.getSpecies();
        if (forcedSwap || !newRace.canCast()) {
            this.getSpellSlot().clear();
        } else {
            this.getSpellSlot().copyFrom(oldPlayer.getSpellSlot(), alive);
        }
        if (forcedSwap) {
            oldSuppressedRace = Race.UNSET;
            Channel.SERVER_SELECT_TRIBE.sendToPlayer((Object)new MsgTribeSelect(Race.allPermitted((class_1657)this.entity), "gui.unicopia.tribe_selection.respawn"), (class_3222)this.entity);
        }
        if (!alive && !this.asWorld().method_8450().method_8355(class_1928.field_19389)) {
            class_1661 inventory = ((class_1657)oldPlayer.asEntity()).method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (!EnchantmentUtil.consumeEnchantment(this.entryFor(UEnchantments.HEART_BOUND), 1, stack, ((class_1657)this.entity).method_37908().field_9229, EnchantmentUtil.getLuck(3, oldPlayer.asEntity()))) continue;
                ((class_1657)this.asEntity()).method_31548().method_5447(i, stack);
            }
        }
        this.levitatingItems.copyFrom(oldPlayer.levitatingItems, alive);
        this.setSpecies(newRace);
        this.setSuppressedRace(oldSuppressedRace);
        this.getDiscoveries().copyFrom(oldPlayer.getDiscoveries(), alive);
        this.getPhysics().copyFrom(oldPlayer.getPhysics(), alive);
        if (!forcedSwap) {
            this.getArmour().copyFrom(oldPlayer.getArmour(), alive);
            this.getCharms().copyFrom(oldPlayer.getCharms(), alive);
            this.corruption.set(oldPlayer.getCorruption().get());
            this.levels.set(oldPlayer.getLevel().get());
        }
        this.mana.copyFrom(oldPlayer.mana, !forcedSwap);
        this.advancementProgress.copyFrom(oldPlayer.advancementProgress, alive);
        this.onSpawn();
    }

    @Override
    public void onSpellAdded(Spell spell) {
        if (spell.getAffinity() == Affinity.BAD && ((class_1657)this.entity).method_37908().field_9229.method_43048(20) == 0) {
            this.getCorruption().add(((class_1657)this.entity).method_59922().method_39332(1, 10));
        }
        this.getCorruption().add((int)spell.getTypeAndTraits().traits().getCorruption() * 10 + spell.getTypeAndTraits().type().getAffinity().getCorruption());
    }

    public boolean isClientPlayer() {
        return InteractionManager.getInstance().isClientPlayer((class_1657)this.asEntity());
    }

    @Nullable
    public static Pony of(@Nullable class_1657 player) {
        return player == null ? null : (Pony)((Equine.Container)player).get();
    }

    public static Stream<Pony> stream(Stream<class_1297> entities) {
        return entities.flatMap(entity -> Pony.of(entity).stream());
    }

    public static Optional<Pony> of(class_1297 entity) {
        return Equine.of(entity, a -> a instanceof Pony);
    }

    public static boolean equal(GameProfile one, GameProfile two) {
        return one == two || one != null && two != null && one.getId().equals(two.getId());
    }

    public static boolean equal(class_1297 one, class_1297 two) {
        return Objects.equals(one, two) || one instanceof class_1657 && two instanceof class_1657 && Pony.equal((class_1657)one, (class_1657)two);
    }

    public static boolean equal(class_1657 one, class_1657 two) {
        return one == two || one != null && two != null && Pony.equal(one.method_7334(), two.method_7334());
    }
}

