/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.player;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.MeteorlogicalUtil;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_5539;

public class SpawnLocator {
    private static class_2338 findOverworldSpawn(class_3218 world, int x, int z, boolean avoidAir) {
        int startHeight;
        boolean hasCeiling = world.method_8597().comp_643();
        class_2818 chunk = world.method_8497(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
        int n = startHeight = hasCeiling ? world.method_14178().method_12129().method_12100((class_5539)world) : chunk.method_12005(class_2902.class_2903.field_13197, x & 0xF, z & 0xF);
        if (startHeight < world.method_31607()) {
            return null;
        }
        int terrainHeight = chunk.method_12005(class_2902.class_2903.field_13202, x & 0xF, z & 0xF);
        if (terrainHeight <= startHeight && terrainHeight > chunk.method_12005(class_2902.class_2903.field_13200, x & 0xF, z & 0xF)) {
            return null;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int y = startHeight + 1; y >= world.method_31607(); --y) {
            mutable.method_10103(x, y, z);
            class_2680 state = world.method_8320((class_2338)mutable);
            TriState pass = SpawnLocator.checkAtmosphere(state.method_26227(), avoidAir);
            if (pass == TriState.TRUE) continue;
            if (pass == TriState.FALSE) {
                return null;
            }
            if (!class_2248.method_9501((class_265)state.method_26220((class_1922)world, (class_2338)mutable), (class_2350)class_2350.field_11036)) continue;
            return mutable.method_10084().method_10062();
        }
        return null;
    }

    private static class_2338 findAdjustedOverworldSpawn(class_3218 world, class_1657 entity, class_238 box, class_2338 basePos, int x, int z, int spawnRadius, boolean avoidAir, boolean avoidSun) {
        class_2338 spawnPos = SpawnLocator.findOverworldSpawn(world, x, z, avoidAir);
        if (spawnPos == null) {
            return null;
        }
        if (avoidSun && MeteorlogicalUtil.isPositionExposedToSun((class_1937)world, spawnPos) && MeteorlogicalUtil.isPositionExposedToSun((class_1937)world, spawnPos = SpawnLocator.findUndergroundSpaceBelow(world, entity, basePos, spawnRadius, box, spawnPos))) {
            return null;
        }
        if (!SpawnLocator.checkAtmosphere(world, spawnPos, avoidAir)) {
            return null;
        }
        return spawnPos;
    }

    public static class_2338 findAdjustedOverworldSpawn(class_3218 world, class_1657 entity, class_238 box, class_2338 basePos, int x, int z, Operation<class_2338> operation) {
        boolean avoidSun = Pony.of(entity).getCompositeRace().includes(Race.BAT);
        boolean avoidAir = Pony.of(entity).getCompositeRace().includes(Race.SEAPONY);
        if (!avoidSun && !avoidAir) {
            return (class_2338)operation.call(new Object[]{world, x, z});
        }
        int spawnRadius = Math.max(16, world.method_8503().method_3829(world));
        return SpawnLocator.findAdjustedOverworldSpawn(world, entity, box, basePos, x, z, spawnRadius, avoidAir, avoidSun);
    }

    private static TriState checkAtmosphere(class_3610 state, boolean avoidAir) {
        if (avoidAir) {
            if (state.method_15769()) {
                return TriState.TRUE;
            }
            if (!state.method_15767(class_3486.field_15517)) {
                return TriState.FALSE;
            }
        }
        return state.method_15769() ? TriState.DEFAULT : TriState.FALSE;
    }

    private static boolean checkAtmosphere(class_3218 world, class_2338 pos, boolean avoidAir) {
        if (avoidAir) {
            return world.method_8316(pos).method_15767(class_3486.field_15517);
        }
        return world.method_8316(pos).method_15769();
    }

    private static class_2338 findUndergroundSpaceBelow(class_3218 world, class_1657 entity, class_2338 basePos, int spawnRadius, class_238 box, class_2338 pos) {
        class_2338.class_2339 mutable = pos.method_25503();
        mutable.method_10100(0, -1, 0);
        while (!world.method_8587((class_1297)entity, box.method_997(mutable.method_61082())) && mutable.method_10264() >= basePos.method_10264() - spawnRadius * 2 && mutable.method_10264() > world.method_31607() + 1) {
            mutable.method_10098(class_2350.field_11033);
        }
        while (world.method_8587((class_1297)entity, box.method_997(mutable.method_10074().method_61082())) && mutable.method_10264() >= basePos.method_10264() - spawnRadius * 2 && mutable.method_10264() > world.method_31607() + 1) {
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable.method_10062();
    }
}

