/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.item;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.HeavyProjectileItem;
import com.minelittlepony.unicopia.item.UItemModifierIds;
import com.minelittlepony.unicopia.projectile.PhysicsBodyProjectileEntity;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class HorseShoeItem
extends HeavyProjectileItem {
    private final float projectileInnacuracy;
    private final float baseProjectileSpeed;

    public HorseShoeItem(class_1792.class_1793 settings, float projectileDamage, float projectileInnacuracy, float baseProjectileSpeed) {
        super(settings.method_57348(class_9285.method_57480().method_57487(UEntityAttributes.EXTENDED_ATTACK_DISTANCE, new class_1322(UItemModifierIds.ATTACK_RANGE_MODIFIER_ID, -3.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486()), projectileDamage);
        this.projectileInnacuracy = projectileInnacuracy;
        this.baseProjectileSpeed = baseProjectileSpeed;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574((class_1792)this);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        float degradation = (float)stack.method_7919() / (float)stack.method_7936();
        float inaccuracy = this.projectileInnacuracy + degradation * 30.0f;
        tooltip.add((class_2561)class_2561.method_43473());
        Race.Composite race = InteractionManager.getInstance().getClientPony().map(Pony::getCompositeRace).orElse(null);
        float speed = this.baseProjectileSpeed;
        if (race != null) {
            if (race.any(Race::canUseEarth)) {
                speed += 0.5f;
            }
            if (!race.includes(Race.ALICORN) && race.physical().canFly()) {
                speed /= 1.5f;
            }
        }
        speed /= 1.5f;
        tooltip.add((class_2561)class_2561.method_43469((String)"item.unicopia.horse_shoe.accuracy", (Object[])new Object[]{Float.valueOf(100.0f * (30.0f - inaccuracy) / 30.0f)}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.unicopia.horse_shoe.speed", (Object[])new Object[]{Float.valueOf(Math.max(0.2f, speed *= 1.0f - 0.6f * degradation))}).method_27692(class_124.field_1080));
    }

    @Override
    public PhysicsBodyProjectileEntity createProjectile(class_1799 stack, class_1937 world, @Nullable class_1657 player) {
        PhysicsBodyProjectileEntity projectile = super.createProjectile(stack, world, player);
        projectile.setDamageType(UDamageTypes.HORSESHOE);
        float degradation = (float)stack.method_7919() / (float)stack.method_7936();
        if (player != null) {
            Pony pony = Pony.of(player);
            Race.Composite race = pony.getCompositeRace();
            float speed = this.baseProjectileSpeed + 0.1f;
            if (race.any(Race::canUseEarth)) {
                speed += 0.5f;
            }
            if (!race.includes(Race.ALICORN) && race.physical().canFly()) {
                speed /= 1.5f;
            }
            speed /= 1.5f;
            float inaccuracy = this.projectileInnacuracy + degradation * 30.0f;
            projectile.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, Math.max(0.2f, speed *= 1.0f - 0.6f * degradation), inaccuracy);
        }
        return projectile;
    }

    public void method_58654(class_1676 entity, double x, double y, double z, float power, float uncertainty) {
        float degradation = 0.0f;
        if (entity instanceof PhysicsBodyProjectileEntity) {
            PhysicsBodyProjectileEntity p = (PhysicsBodyProjectileEntity)entity;
            class_1799 stack = p.method_7495();
            degradation = (float)stack.method_7919() / (float)stack.method_7936();
        }
        float speed = Math.max(0.2f, (this.baseProjectileSpeed + 0.1f) / 1.5f * (1.0f - 0.6f * degradation));
        float inaccuracy = this.projectileInnacuracy + degradation * 30.0f;
        entity.method_7485(x, y, z, speed, inaccuracy);
    }

    @Override
    public class_3414 getThrowSound(class_1799 stack) {
        return (class_3414)USounds.Vanilla.field_15001.comp_349();
    }
}

