/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.mixin;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.duck.LivingEntityDuck;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_5132;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class MixinLivingEntity
extends class_1297
implements LivingEntityDuck,
Equine.Container<Living<?>> {
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    @Shadow
    protected boolean field_6272;
    @Shadow
    private Optional<class_2338> field_22418;
    private Equine<?> caster;

    private MixinLivingEntity() {
        super(null, null);
    }

    @Shadow
    protected abstract void method_6085(int var1, boolean var2);

    @Override
    public Equine<?> create() {
        return new Creature((class_1309)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Living<?> get() {
        MixinLivingEntity mixinLivingEntity = this;
        synchronized (mixinLivingEntity) {
            if (this.caster == null) {
                this.caster = this.create();
            }
            return (Living)this.caster;
        }
    }

    @Override
    @Accessor(value="jumping")
    public abstract boolean isJumping();

    @Override
    @Accessor(value="leaningPitch")
    public abstract float getLeaningPitch();

    @Override
    @Accessor(value="leaningPitch")
    public abstract void setLeaningPitch(float var1);

    @Override
    @Accessor(value="lastLeaningPitch")
    public abstract float getLastLeaningPitch();

    @Override
    @Accessor(value="lastLeaningPitch")
    public abstract void setLastLeaningPitch(float var1);

    @Override
    @Accessor
    public abstract double getServerX();

    @Override
    @Accessor
    public abstract double getServerY();

    @Override
    @Accessor
    public abstract double getServerZ();

    @Inject(method={"createLivingAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, at={@At(value="RETURN")})
    private static void onCreateAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        Creature.registerAttributes((class_5132.class_5133)info.getReturnValue());
    }

    @Inject(method={"isClimbing()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onIsClimbing(CallbackInfoReturnable<Boolean> info) {
        if (this.field_5976) {
            ((Living)this.get()).chooseClimbingPos().ifPresent(pos -> {
                this.field_22418 = Optional.of(pos);
                info.setReturnValue((Object)true);
            });
        }
    }

    @Inject(method={"isPushable()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPushable(CallbackInfoReturnable<Boolean> info) {
        Caster.of(this).flatMap(c -> c.getSpellSlot().get(SpellPredicate.IS_DISGUISE)).map(AbstractDisguiseSpell::getDisguise).map(EntityAppearance::getAppearance).filter(class_1297::method_5810).ifPresent(v -> info.setReturnValue((Object)false));
    }

    @Inject(method={"canSee(Lnet/minecraft/entity/Entity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanSee(class_1297 other, CallbackInfoReturnable<Boolean> info) {
        if (!((Living)this.get()).canBeSeenBy(other)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"applyFluidMovingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void applyFluidMovingSpeed(double gravity, boolean falling, class_243 motion, CallbackInfoReturnable<class_243> info) {
        ((Living)this.get()).adjustMovementSpeedInWater((class_243)info.getReturnValue()).ifPresent(arg_0 -> info.setReturnValue(arg_0));
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void beforeTick(CallbackInfo info) {
        if (((Living)this.get()).beforeUpdate()) {
            info.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void afterTick(CallbackInfo info) {
        ((Living)this.get()).tick();
    }

    @Inject(method={"<clinit>()V"}, at={@At(value="RETURN")}, remap=false)
    @Dynamic(value="Compiler-generated class-init() method")
    private static void clinit(CallbackInfo info) {
        Creature.boostrap();
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        ((Living)this.get()).onDamage(source, amount).ifPresent(arg_0 -> info.setReturnValue(arg_0));
    }

    @Inject(method={"tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z"}, at={@At(value="RETURN")})
    private void onOnDeath(class_1282 source, CallbackInfoReturnable<Boolean> info) {
        if (!this.method_31481() && !this.field_6272) {
            ((Living)this.get()).onDeath(source, (Boolean)info.getReturnValue());
        }
    }

    @Inject(method={"onAttacking(Lnet/minecraft/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnAttacking(class_1297 target, CallbackInfo info) {
        ((Living)this.get()).onAttacking(target);
    }

    @ModifyVariable(method={"handleFallDamage(FFLnet/minecraft/entity/damage/DamageSource;)Z"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float onHandleFallDamage(float distance, float distanceAgain, float damageMultiplier, class_1282 cause) {
        return ((Living)this.get()).onImpact(distance, damageMultiplier, cause);
    }

    @Inject(method={"hurtByWater()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanBeHurtByWater(CallbackInfoReturnable<Boolean> info) {
        TriState hurtByWater = ((Living)this.get()).canBeHurtByWater();
        if (hurtByWater != TriState.DEFAULT) {
            info.setReturnValue((Object)hurtByWater.get());
        }
    }

    @Inject(method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    private void onWriteCustomDataToTag(class_2487 tag, CallbackInfo info) {
        tag.method_10566("unicopia_caster", (class_2520)this.get().toNBT((class_7225.class_7874)this.method_37908().method_30349()));
    }

    @Inject(method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"}, at={@At(value="HEAD")})
    private void onReadCustomDataFromTag(class_2487 tag, CallbackInfo info) {
        if (tag.method_10545("unicopia_caster")) {
            ((Living)this.get()).fromNBT(tag.method_10562("unicopia_caster"), (class_7225.class_7874)this.method_37908().method_30349());
        }
    }

    @Override
    public void updateItemUsage(class_1268 hand, class_1799 stack, int time) {
        this.field_6277 = stack;
        this.field_6222 = time;
        if (!this.method_37908().field_9236) {
            this.method_6085(1, !stack.method_7960());
            this.method_6085(2, hand == class_1268.field_5810);
        }
    }
}

