/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.mixin;

import com.minelittlepony.unicopia.entity.duck.RotatedView;
import com.minelittlepony.unicopia.server.world.BlockDestructionManager;
import com.minelittlepony.unicopia.server.world.WeatherAccess;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1937.class})
abstract class MixinWorld
implements class_1936,
BlockDestructionManager.Source,
RotatedView,
WeatherAccess {
    private final Supplier<BlockDestructionManager> destructions = BlockDestructionManager.create((class_1937)this);
    @Nullable
    private Float rainGradientOverride;
    @Nullable
    private Float thunderGradientOverride;
    private boolean mirrorEntityStatuses;

    MixinWorld() {
    }

    @Override
    public void setMirrorEntityStatuses(boolean enable) {
        this.mirrorEntityStatuses = enable;
    }

    @Override
    public BlockDestructionManager getDestructionManager() {
        return this.destructions.get();
    }

    @Override
    public void setWeatherOverride(Float rain, Float thunder) {
        this.rainGradientOverride = rain;
        this.thunderGradientOverride = thunder;
    }

    @Inject(method={"sendEntityStatus(Lnet/minecraft/entity/Entity;B)V"}, at={@At(value="HEAD")})
    private void onSendEntityStatus(class_1297 entity, byte status, CallbackInfo info) {
        if (this.mirrorEntityStatuses) {
            entity.method_5711(status);
        }
    }

    @Inject(method={"getThunderGradient"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetThunderGradient(float delta, CallbackInfoReturnable<Float> info) {
        if (this.thunderGradientOverride != null) {
            info.setReturnValue((Object)Float.valueOf(this.thunderGradientOverride.floatValue() * ((class_1937)this).method_8430(delta)));
        }
    }

    @Inject(method={"getRainGradient"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetRainGradient(float delta, CallbackInfoReturnable<Float> info) {
        if (this.rainGradientOverride != null) {
            info.setReturnValue((Object)this.rainGradientOverride);
        }
    }

    @Inject(method={"hasRain"}, at={@At(value="RETURN")}, cancellable=true)
    private void onHasRain(class_2338 pos, CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue((Object)((Boolean)info.getReturnValue() != false && this.isBelowCloudLayer(pos) || this.isInRangeOfStorm(pos) ? 1 : 0));
    }
}

