/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.network.track;

import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.MsgTrackedValues;
import com.minelittlepony.unicopia.network.track.ObjectTracker;
import com.minelittlepony.unicopia.network.track.TrackableObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class DataTrackerManager {
    private final class_1297 entity;
    private final class_5455 lookup;
    final boolean isClient;
    private final List<DataTracker> trackers = new ObjectArrayList();
    private final List<ObjectTracker<?>> objectTrackers = new ObjectArrayList();
    private final List<PacketEmitter> packetEmitters = new ObjectArrayList();
    private DataTracker primaryTracker;

    public DataTrackerManager(class_1297 entity) {
        this.entity = entity;
        this.lookup = entity.method_37908().method_30349();
        this.isClient = entity.method_37908().field_9236;
        this.primaryTracker = this.checkoutTracker();
    }

    public synchronized void addPacketEmitter(PacketEmitter packetEmitter) {
        this.packetEmitters.add(packetEmitter);
    }

    public DataTracker getPrimaryTracker() {
        return this.primaryTracker;
    }

    public synchronized DataTracker checkoutTracker() {
        DataTracker tracker = new DataTracker(this.trackers.size());
        this.trackers.add(tracker);
        this.packetEmitters.add((sender, initial) -> {
            Optional<MsgTrackedValues.TrackerEntries> update;
            Optional<MsgTrackedValues.TrackerEntries> optional = update = initial ? tracker.getInitialPairs((class_7225.class_7874)this.lookup) : tracker.getDirtyPairs((class_7225.class_7874)this.lookup);
            if (update.isPresent()) {
                sender.accept(Channel.SERVER_TRACKED_ENTITY_DATA.toPacket((Object)new MsgTrackedValues(this.entity.method_5628(), Optional.empty(), update)));
            }
        });
        return tracker;
    }

    public synchronized <T extends TrackableObject<T>> ObjectTracker<T> checkoutTracker(Supplier<T> objFunction) {
        ObjectTracker tracker = new ObjectTracker(this.objectTrackers.size(), objFunction);
        this.objectTrackers.add(tracker);
        this.packetEmitters.add((sender, initial) -> {
            Optional<MsgTrackedValues.TrackerObjects> update;
            Optional<MsgTrackedValues.TrackerObjects> optional = update = initial ? tracker.getInitialPairs((class_7225.class_7874)this.lookup) : tracker.getDirtyPairs((class_7225.class_7874)this.lookup);
            if (update.isPresent()) {
                sender.accept(Channel.SERVER_TRACKED_ENTITY_DATA.toPacket((Object)new MsgTrackedValues(this.entity.method_5628(), update, Optional.empty())));
            }
        });
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(Consumer<class_2596<?>> sender) {
        DataTrackerManager dataTrackerManager = this;
        synchronized (dataTrackerManager) {
            for (PacketEmitter emitter : this.packetEmitters) {
                emitter.sendPackets(sender, false);
            }
        }
    }

    public synchronized void copyTo(DataTrackerManager destination) {
        int i;
        for (i = 0; i < this.trackers.size(); ++i) {
            this.trackers.get(i).copyTo(i >= destination.trackers.size() ? destination.checkoutTracker() : destination.trackers.get(i));
        }
        for (i = 0; i < this.objectTrackers.size(); ++i) {
            this.objectTrackers.get(i).copyTo(destination.objectTrackers.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendInitial(class_3222 player, Consumer<class_2596<class_2602>> sender) {
        DataTrackerManager dataTrackerManager = this;
        synchronized (dataTrackerManager) {
            for (PacketEmitter emitter : this.packetEmitters) {
                emitter.sendPackets(sender, true);
            }
        }
    }

    synchronized void load(MsgTrackedValues packet) {
        packet.updatedTrackers().ifPresent(update -> {
            DataTracker tracker = this.trackers.get(update.id());
            if (tracker != null) {
                tracker.load((MsgTrackedValues.TrackerEntries)update, this.lookup);
            }
        });
        packet.updatedObjects().ifPresent(update -> {
            ObjectTracker<?> tracker = this.objectTrackers.get(update.id());
            if (tracker != null) {
                tracker.load((MsgTrackedValues.TrackerObjects)update, this.lookup);
            }
        });
    }

    public static interface PacketEmitter {
        public void sendPackets(Consumer<class_2596<?>> var1, boolean var2);
    }
}

