/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.network.track;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.entity.player.SkinFeatures;
import com.minelittlepony.unicopia.util.Untyped;
import com.minelittlepony.unicopia.util.serialization.PacketCodecUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record TrackableDataType<T>(int id, class_9139<class_9129, TypedValue<T>> codec) {
    private static final Int2ObjectMap<TrackableDataType<?>> REGISTRY = new Int2ObjectOpenHashMap();
    public static final class_9139<class_9129, TypedValue<?>> PACKET_CODEC = class_9135.field_49675.method_56430().method_56432(id -> Objects.requireNonNull((TrackableDataType)REGISTRY.get(id.intValue()), "Unknown trackable data type id: " + id), type -> type.id()).method_56440(value -> (TrackableDataType)Untyped.cast(value.type), TrackableDataType::codec);
    public static final TrackableDataType<Integer> INT = TrackableDataType.of(class_2960.method_60654((String)"integer"), class_9135.field_49675);
    public static final TrackableDataType<Float> FLOAT = TrackableDataType.of(class_2960.method_60654((String)"float"), class_9135.field_48552);
    public static final TrackableDataType<Boolean> BOOLEAN = TrackableDataType.of(class_2960.method_60654((String)"boolean"), class_9135.field_48547);
    public static final TrackableDataType<Optional<UUID>> UUID = TrackableDataType.of(class_2960.method_60654((String)"uuid"), class_9135.method_56382((class_9139)class_4844.field_48453));
    public static final TrackableDataType<class_2487> NBT = TrackableDataType.of(class_2960.method_60654((String)"nbt"), class_9135.field_48556);
    public static final TrackableDataType<class_2487> COMPRESSED_NBT = TrackableDataType.of(class_2960.method_60654((String)"compressed_nbt"), class_9135.field_48556);
    public static final TrackableDataType<Optional<class_2338>> OPTIONAL_POS = TrackableDataType.of(class_2960.method_60654((String)"optional_pos"), PacketCodecUtils.OPTIONAL_POS);
    public static final TrackableDataType<Optional<class_243>> OPTIONAL_VECTOR = TrackableDataType.of(class_2960.method_60654((String)"optional_vector"), PacketCodecUtils.OPTIONAL_VECTOR);
    private static final TrackableDataType<Optional<class_5321<?>>> OPTIONAL_REGISTRY_KEY = TrackableDataType.of(class_2960.method_60654((String)"optional_registry_key"), PacketCodecUtils.OPTIONAL_REGISTRY_KEY);
    public static final TrackableDataType<Race> RACE = TrackableDataType.of(Unicopia.id("race"), class_9135.method_56365(Race.REGISTRY_KEY));
    public static final TrackableDataType<SkinFeatures> SKIN_FEATURES = TrackableDataType.of(Unicopia.id("skin_features"), SkinFeatures.PACKET_CODEC);

    public static <T> TrackableDataType<Optional<class_5321<T>>> ofRegistryKey() {
        return (TrackableDataType)Untyped.cast(OPTIONAL_REGISTRY_KEY);
    }

    public static <T> TrackableDataType<T> of(class_2960 typeName, class_9139<? super class_9129, T> codec) {
        return (TrackableDataType)Untyped.cast(REGISTRY.computeIfAbsent(typeName.hashCode(), t -> {
            AtomicReference ref = new AtomicReference();
            ref.set(new TrackableDataType(t, codec.method_56430().method_56432(value -> new TypedValue<Object>((TrackableDataType)ref.get(), value), value -> value.value)));
            return (TrackableDataType)ref.get();
        }));
    }

    public static class TypedValue<T> {
        final TrackableDataType<T> type;
        public T value;

        public TypedValue(TrackableDataType<T> type, T value) {
            this.type = type;
            this.value = value;
        }
    }
}

