/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.entity.mob.FloatingArtefactEntity;
import com.minelittlepony.unicopia.entity.mob.SpellbookEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.server.world.UnicopiaWorldProperties;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;

public record Altar(class_2338 origin, Set<class_2338> pillars) {
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034};
    private static final Predicate<class_1297> IS_PARTICIPANT = class_1301.field_6154.and(e -> e instanceof FloatingArtefactEntity || e instanceof SpellbookEntity);
    public static final Codec<Altar> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("origin").forGetter(Altar::origin), (App)CodecUtils.setOf(class_2338.field_25064).fieldOf("pillars").forGetter(Altar::pillars)).apply((Applicative)instance, Altar::new));
    private static final int INNER_RADIUS = 4;
    private static final int PILLAR_OFFSET_FROM_CENTER = 2;
    private static final class_2338 PILLAR_A = new class_2338(4, 0, 2);
    private static final class_2338 PILLAR_B = new class_2338(4, 0, -2);

    public static Optional<Altar> locateAltar(class_1937 world, class_2338 startingPoint) {
        class_2338.class_2339 mutable = startingPoint.method_25503();
        if (!world.method_8311((class_2338)mutable)) {
            return Optional.empty();
        }
        mutable.method_10098(class_2350.field_11033);
        if (!world.method_8320((class_2338)mutable).method_27852(class_2246.field_23261)) {
            return Optional.empty();
        }
        for (int i = 0; i < 4; ++i) {
            mutable.method_10101((class_2382)startingPoint);
            mutable.method_10098(class_2350.field_11033);
            mutable.method_10104(class_2350.method_10139((int)i), 2);
            if (!world.method_8320((class_2338)mutable).method_27852(class_2246.field_10114) || !Altar.checkSlab(world, (class_2338)mutable)) continue;
            mutable.method_10098(class_2350.field_11036);
            class_2680 fireState = world.method_8320((class_2338)mutable);
            if (!fireState.method_26215() && !fireState.method_26164(class_3481.field_21952)) {
                return Optional.empty();
            }
            class_2338 firePos = mutable.method_10062();
            mutable.method_10098(class_2350.field_11033);
            HashSet<class_2338> pillars = new HashSet<class_2338>();
            if (!Altar.checkPillarPair(world, mutable, class_2470.field_11467, pillars::add)) continue;
            if (!Altar.checkPillarPair(world, mutable, class_2470.field_11463, pillars::add)) continue;
            if (!Altar.checkPillarPair(world, mutable, class_2470.field_11465, pillars::add)) continue;
            if (!Altar.checkPillarPair(world, mutable, class_2470.field_11464, pillars::add)) continue;
            return Optional.of(new Altar(firePos, pillars));
        }
        return Optional.empty();
    }

    private static boolean checkSlab(class_1937 world, class_2338 pos) {
        return !PosHelper.fastAny(pos, p -> !Altar.isObsidian(world, p), HORIZONTALS);
    }

    private static boolean checkPillarPair(class_1937 world, class_2338.class_2339 center, class_2470 rotation, Consumer<class_2338> pillarPosCollector) {
        return Altar.checkPillar(world, center, (class_2382)PILLAR_A.method_10070(rotation), pillarPosCollector) && Altar.checkPillar(world, center, (class_2382)PILLAR_B.method_10070(rotation), pillarPosCollector);
    }

    private static boolean checkPillar(class_1937 world, class_2338.class_2339 pos, class_2382 pillarPos, Consumer<class_2338> pillarPosCollector) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (Altar.isObsidian(world, (class_2338)pos.method_30927(pillarPos)) && Altar.isObsidian(world, (class_2338)pos.method_10098(class_2350.field_11036)) && Altar.isObsidian(world, (class_2338)pos.method_10098(class_2350.field_11036)) && Altar.isObsidian(world, (class_2338)pos.method_10098(class_2350.field_11036)) && world.method_8311((class_2338)pos.method_10098(class_2350.field_11036))) {
            pillarPosCollector.accept(pos.method_10098(class_2350.field_11033).method_10062());
            pos.method_10103(x, y, z);
            return true;
        }
        return false;
    }

    private static boolean isObsidian(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return state.method_27852(class_2246.field_10540) || state.method_27852(class_2246.field_22423);
    }

    private static boolean checkState(class_1937 world, class_2338 pos, class_2248 block) {
        return world.method_8320(pos).method_27852(block);
    }

    public void generateDecorations(class_1937 world) {
        world.method_8652(this.origin, UBlocks.SPECTRAL_FIRE.method_9564(), 19);
        this.pillars.forEach(pillar -> {
            FloatingArtefactEntity artefact = (FloatingArtefactEntity)UEntities.FLOATING_ARTEFACT.method_5883(world);
            artefact.setStack(UItems.ALICORN_BADGE.method_7854());
            artefact.method_33574(pillar.method_10084().method_46558());
            artefact.method_5684(true);
            artefact.setAltar(this);
            this.removeExisting(null, world, (class_2338)pillar);
            world.method_8649((class_1297)artefact);
        });
        if (!world.field_9236) {
            UnicopiaWorldProperties.forWorld((class_3218)world).addAltar(this.origin());
        }
    }

    public void tearDown(@Nullable class_1297 except, class_1937 world) {
        if (!world.field_9236) {
            UnicopiaWorldProperties.forWorld((class_3218)world).removeAltar(this.origin());
        }
        this.pillars.forEach(pillar -> this.removeExisting(except, world, (class_2338)pillar));
    }

    private void removeExisting(@Nullable class_1297 except, class_1937 world, class_2338 pillar) {
        world.method_8333(except, new class_238(pillar.method_10084()), IS_PARTICIPANT).forEach(class_1297::method_5768);
    }

    public boolean isValid(class_1937 world) {
        return Altar.checkState(world, this.origin, UBlocks.SPECTRAL_FIRE) && Altar.checkState(world, this.origin.method_10074(), class_2246.field_10114) && Altar.checkSlab(world, this.origin.method_10074()) && this.pillars.stream().allMatch(pillar -> Altar.isObsidian(world, pillar) && world.method_8311(pillar.method_10084()) && Altar.isObsidian(world, pillar.method_10074()) && Altar.isObsidian(world, pillar.method_10087(2)) && Altar.isObsidian(world, pillar.method_10087(3)));
    }
}

