/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgSkyAngle;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class UnicopiaWorldProperties
extends class_18 {
    static final Codec<Set<class_2338>> POS_CODEC = CodecUtils.setOf(class_2338.field_25064);
    private final class_3218 world;
    private Race defaultRace = Race.UNSET;
    private float tangentalSkyAngle;
    private final Set<class_2338> activeAltarPositions = new HashSet<class_2338>();

    public static UnicopiaWorldProperties forWorld(class_3218 world) {
        return (UnicopiaWorldProperties)world.method_17983().method_17924(new class_18.class_8645(() -> new UnicopiaWorldProperties(world), (nbt, lookup) -> new UnicopiaWorldProperties(world, (class_2487)nbt), class_4284.field_19212), "unicopia_tribes");
    }

    private UnicopiaWorldProperties(class_3218 world) {
        this.world = world;
    }

    private UnicopiaWorldProperties(class_3218 world, class_2487 tag) {
        this(world);
        this.defaultRace = Race.fromName(tag.method_10558("defaultRace"), Race.HUMAN);
        this.tangentalSkyAngle = tag.method_10583("tangentalSkyAngle");
        NbtSerialisable.decode(POS_CODEC, (class_2520)tag.method_10554("activeAltars", 10), (class_7225.class_7874)world.method_30349()).ifPresent(this.activeAltarPositions::addAll);
    }

    public Race getDefaultRace() {
        return this.defaultRace;
    }

    public Race setDefaultRace(Race race) {
        this.defaultRace = race;
        this.method_80();
        return this.defaultRace;
    }

    public float getTangentalSkyAngle() {
        return this.tangentalSkyAngle;
    }

    public void setTangentalSkyAngle(float angle) {
        this.tangentalSkyAngle = class_3532.method_15393((float)angle);
        this.method_80();
        Channel.SERVER_SKY_ANGLE.sendToAllPlayers((Object)new MsgSkyAngle(this.tangentalSkyAngle), (class_1937)this.world);
    }

    public void removeAltar(class_2338 center) {
        this.activeAltarPositions.remove(center);
        this.method_80();
    }

    public void addAltar(class_2338 center) {
        this.activeAltarPositions.add(center);
        this.method_80();
    }

    public boolean isActiveAltar(class_2338 center) {
        return this.activeAltarPositions.contains(center);
    }

    public boolean isActiveAltar(class_1297 entity) {
        int i = 0;
        while ((float)i < entity.method_17682()) {
            if (this.isActiveAltar(entity.method_24515().method_10086(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10582("defaultRace", Race.REGISTRY.method_10221((Object)this.defaultRace).toString());
        tag.method_10548("tangentalSkyAngle", this.tangentalSkyAngle);
        tag.method_10566("activeAltars", NbtSerialisable.encode(POS_CODEC, this.activeAltarPositions, lookup));
        return tag;
    }
}

